/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.bootstrap;

import io.netty5.bootstrap.Bootstrap;
import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelInitializer;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.local.LocalAddress;
import io.netty5.channel.local.LocalChannel;
import io.netty5.channel.local.LocalHandler;
import io.netty5.channel.local.LocalServerChannel;
import io.netty5.util.AttributeKey;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ServerBootstrapTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testHandlerRegister() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference error = new AtomicReference();
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        try {
            ServerBootstrap sb = new ServerBootstrap();
            sb.channel(LocalServerChannel.class).group((EventLoopGroup)group).childHandler(new ChannelHandler(){}).handler(new ChannelHandler(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    try {
                        Assertions.assertTrue((boolean)ctx.executor().inEventLoop());
                    }
                    catch (Throwable cause) {
                        error.set(cause);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            sb.register().syncUninterruptibly();
            latch.await();
            Assertions.assertNull(error.get());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testParentHandler() throws Exception {
        ServerBootstrapTest.testParentHandler(false);
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testParentHandlerViaChannelInitializer() throws Exception {
        ServerBootstrapTest.testParentHandler(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testParentHandler(boolean channelInitializer) throws Exception {
        LocalAddress addr = new LocalAddress(UUID.randomUUID().toString());
        final CountDownLatch readLatch = new CountDownLatch(1);
        final CountDownLatch initLatch = new CountDownLatch(1);
        final ChannelHandler handler = new ChannelHandler(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                initLatch.countDown();
                ctx.fireChannelActive();
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                readLatch.countDown();
                ctx.fireChannelRead(msg);
            }
        };
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        Channel sch = null;
        Channel cch = null;
        try {
            ServerBootstrap sb = new ServerBootstrap();
            sb.channel(LocalServerChannel.class).group((EventLoopGroup)group).childHandler(new ChannelHandler(){});
            if (channelInitializer) {
                sb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{handler});
                    }
                });
            } else {
                sb.handler(handler);
            }
            Bootstrap cb = new Bootstrap();
            ((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class).handler(new ChannelHandler(){});
            sch = (Channel)sb.bind((SocketAddress)addr).get();
            cch = (Channel)cb.connect((SocketAddress)addr).get();
            initLatch.await();
            readLatch.await();
        }
        finally {
            if (sch != null) {
                sch.close().syncUninterruptibly();
            }
            if (cch != null) {
                cch.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
        }
    }

    @Test
    public void optionsAndAttributesMustBeAvailableOnChildChannelInit() throws Exception {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        LocalAddress addr = new LocalAddress(UUID.randomUUID().toString());
        final AttributeKey key = AttributeKey.valueOf((String)UUID.randomUUID().toString());
        final AtomicBoolean requestServed = new AtomicBoolean();
        ServerBootstrap sb = new ServerBootstrap().group((EventLoopGroup)group).channel(LocalServerChannel.class).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)4242).childAttr(key, (Object)"value").childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            protected void initChannel(LocalChannel ch) throws Exception {
                Integer option = (Integer)ch.config().getOption(ChannelOption.CONNECT_TIMEOUT_MILLIS);
                Assertions.assertEquals((int)4242, (int)option);
                Assertions.assertEquals((Object)"value", (Object)ch.attr(key).get());
                requestServed.set(true);
            }
        });
        Channel serverChannel = (Channel)sb.bind((SocketAddress)addr).get();
        Bootstrap cb = new Bootstrap();
        ((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class).handler(new ChannelHandler(){});
        Channel clientChannel = (Channel)cb.connect((SocketAddress)addr).get();
        serverChannel.close().syncUninterruptibly();
        clientChannel.close().syncUninterruptibly();
        group.shutdownGracefully();
        Assertions.assertTrue((boolean)requestServed.get());
    }
}

