/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.AbstractChannel;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelConfig;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelId;
import io.netty5.channel.ChannelMetadata;
import io.netty5.channel.ChannelOutboundBuffer;
import io.netty5.channel.DefaultChannelConfig;
import io.netty5.channel.DefaultChannelId;
import io.netty5.channel.EventLoop;
import io.netty5.util.NetUtil;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.ImmediateEventExecutor;
import io.netty5.util.concurrent.Promise;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractChannelTest {
    @Test
    public void ensureInitialRegistrationFiresActive() throws Throwable {
        EventLoop eventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        Mockito.when((Object)eventLoop.inEventLoop()).thenReturn((Object)true);
        Mockito.when((Object)eventLoop.unsafe()).thenReturn((Object)((EventLoop.Unsafe)Mockito.mock(EventLoop.Unsafe.class)));
        Mockito.when((Object)eventLoop.newPromise()).thenReturn((Object)ImmediateEventExecutor.INSTANCE.newPromise());
        TestChannel channel = new TestChannel(eventLoop);
        ChannelHandler handler = (ChannelHandler)Mockito.spy((Object)new ChannelHandler(){

            public void handlerAdded(ChannelHandlerContext ctx) {
            }

            public void channelRegistered(ChannelHandlerContext ctx) {
                ctx.fireChannelRegistered();
            }

            public void channelActive(ChannelHandlerContext ctx) {
                ctx.fireChannelActive();
            }
        });
        channel.pipeline().addLast(new ChannelHandler[]{handler});
        AbstractChannelTest.registerChannel((Channel)channel);
        ((ChannelHandler)Mockito.verify((Object)handler)).handlerAdded((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
        ((ChannelHandler)Mockito.verify((Object)handler)).channelRegistered((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
        ((ChannelHandler)Mockito.verify((Object)handler)).channelActive((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
    }

    @Test
    public void ensureSubsequentRegistrationDoesNotFireActive() throws Throwable {
        EventLoop eventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        Mockito.when((Object)eventLoop.inEventLoop()).thenReturn((Object)true);
        Mockito.when((Object)eventLoop.unsafe()).thenReturn((Object)((EventLoop.Unsafe)Mockito.mock(EventLoop.Unsafe.class)));
        Mockito.when((Object)eventLoop.newPromise()).thenAnswer(inv -> ImmediateEventExecutor.INSTANCE.newPromise());
        ((EventLoop)Mockito.doAnswer(invocationOnMock -> {
            ((Runnable)invocationOnMock.getArgument(0)).run();
            return null;
        }).when((Object)eventLoop)).execute((Runnable)Mockito.any(Runnable.class));
        TestChannel channel = new TestChannel(eventLoop);
        ChannelHandler handler = (ChannelHandler)Mockito.spy((Object)new ChannelHandler(){

            public void channelRegistered(ChannelHandlerContext ctx) {
                ctx.fireChannelRegistered();
            }

            public void channelUnregistered(ChannelHandlerContext ctx) {
                ctx.fireChannelUnregistered();
            }

            public void channelActive(ChannelHandlerContext ctx) {
                ctx.fireChannelActive();
            }
        });
        channel.pipeline().addLast(new ChannelHandler[]{handler});
        AbstractChannelTest.registerChannel((Channel)channel);
        channel.unsafe().deregister(channel.newPromise());
        AbstractChannelTest.registerChannel((Channel)channel);
        ((ChannelHandler)Mockito.verify((Object)handler)).handlerAdded((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
        ((ChannelHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)2))).channelRegistered((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
        ((ChannelHandler)Mockito.verify((Object)handler)).channelActive((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
        ((ChannelHandler)Mockito.verify((Object)handler)).channelUnregistered((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
    }

    @Test
    public void ensureDefaultChannelId() {
        EventLoop eventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        TestChannel channel = new TestChannel(eventLoop);
        ChannelId channelId = channel.id();
        Assertions.assertTrue((boolean)(channelId instanceof DefaultChannelId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClosedChannelExceptionCarryIOException() throws Exception {
        final IOException ioException = new IOException();
        EventLoop eventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        Mockito.when((Object)eventLoop.inEventLoop()).thenReturn((Object)true);
        Mockito.when((Object)eventLoop.unsafe()).thenReturn((Object)((EventLoop.Unsafe)Mockito.mock(EventLoop.Unsafe.class)));
        Mockito.when((Object)eventLoop.newPromise()).thenAnswer(inv -> ImmediateEventExecutor.INSTANCE.newPromise());
        ((EventLoop)Mockito.doAnswer(invocationOnMock -> {
            ((Runnable)invocationOnMock.getArgument(0)).run();
            return null;
        }).when((Object)eventLoop)).execute((Runnable)Mockito.any(Runnable.class));
        try (TestChannel channel = new TestChannel(eventLoop){
            private boolean open;
            private boolean active;
            {
                super(eventLoop);
                this.open = true;
            }

            @Override
            protected AbstractChannel.AbstractUnsafe newUnsafe() {
                return new AbstractChannel.AbstractUnsafe(){

                    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, Promise<Void> promise) {
                        active = true;
                        promise.setSuccess(null);
                    }
                };
            }

            @Override
            protected void doClose() {
                this.active = false;
                this.open = false;
            }

            @Override
            protected void doWrite(ChannelOutboundBuffer in) throws Exception {
                throw ioException;
            }

            @Override
            public boolean isOpen() {
                return this.open;
            }

            @Override
            public boolean isActive() {
                return this.active;
            }
        };){
            AbstractChannelTest.registerChannel((Channel)channel);
            channel.connect(new InetSocketAddress(NetUtil.LOCALHOST, 8888)).sync();
            Assertions.assertSame((Object)ioException, (Object)channel.writeAndFlush("").await().cause());
            AbstractChannelTest.assertClosedChannelException((Future<Void>)channel.writeAndFlush(""), ioException);
            AbstractChannelTest.assertClosedChannelException((Future<Void>)channel.write(""), ioException);
            AbstractChannelTest.assertClosedChannelException((Future<Void>)channel.bind(new InetSocketAddress(NetUtil.LOCALHOST, 8888)), ioException);
        }
    }

    private static void assertClosedChannelException(Future<Void> future, IOException expected) throws InterruptedException {
        Throwable cause = future.await().cause();
        Assertions.assertTrue((boolean)(cause instanceof ClosedChannelException));
        Assertions.assertSame((Object)expected, (Object)cause.getCause());
    }

    private static void registerChannel(Channel channel) throws Exception {
        channel.register().sync();
    }

    private static class TestChannel
    extends AbstractChannel {
        private static final ChannelMetadata TEST_METADATA = new ChannelMetadata(false);
        private final ChannelConfig config = new DefaultChannelConfig((Channel)this);

        TestChannel(EventLoop eventLoop) {
            super(null, eventLoop);
        }

        public ChannelConfig config() {
            return this.config;
        }

        public boolean isOpen() {
            return true;
        }

        public boolean isActive() {
            return true;
        }

        public ChannelMetadata metadata() {
            return TEST_METADATA;
        }

        protected AbstractChannel.AbstractUnsafe newUnsafe() {
            return new AbstractChannel.AbstractUnsafe(){

                public void connect(SocketAddress remoteAddress, SocketAddress localAddress, Promise<Void> promise) {
                    promise.setFailure((Throwable)new UnsupportedOperationException());
                }
            };
        }

        protected SocketAddress localAddress0() {
            return null;
        }

        protected SocketAddress remoteAddress0() {
            return null;
        }

        protected void doBind(SocketAddress localAddress) {
        }

        protected void doDisconnect() {
        }

        protected void doClose() {
        }

        protected void doBeginRead() {
        }

        protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        }
    }
}

