/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.channel.AbstractCoalescingBufferQueue;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelOutboundInvoker;
import io.netty5.channel.embedded.EmbeddedChannel;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.concurrent.Future;
import java.nio.channels.ClosedChannelException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractCoalescingBufferQueueTest {
    @Test
    public void testDecrementAllWhenWriteAndRemoveAll() {
        AbstractCoalescingBufferQueueTest.testDecrementAll(true);
    }

    @Test
    public void testDecrementAllWhenReleaseAndFailAll() {
        AbstractCoalescingBufferQueueTest.testDecrementAll(false);
    }

    private static void testDecrementAll(boolean write) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
                ReferenceCountUtil.release((Object)msg);
                return ctx.newSucceededFuture();
            }
        }, new ChannelHandlerAdapter(){}});
        AbstractCoalescingBufferQueue queue = new AbstractCoalescingBufferQueue((Channel)channel, 128){

            protected Buffer compose(BufferAllocator alloc, Buffer cumulation, Buffer next) {
                return this.composeIntoComposite(alloc, cumulation, next);
            }

            protected Buffer removeEmptyValue() {
                return BufferAllocator.offHeapUnpooled().allocate(0);
            }
        };
        byte[] bytes = new byte[128];
        queue.add(BufferAllocator.offHeapUnpooled().copyOf(bytes), future -> {
            queue.add(BufferAllocator.offHeapUnpooled().copyOf(bytes));
            Assertions.assertEquals((int)bytes.length, (int)queue.readableBytes());
        });
        Assertions.assertEquals((int)bytes.length, (int)queue.readableBytes());
        ChannelHandlerContext ctx = channel.pipeline().lastContext();
        if (write) {
            queue.writeAndRemoveAll(ctx);
        } else {
            queue.releaseAndFailAll((ChannelOutboundInvoker)ctx, (Throwable)new ClosedChannelException());
        }
        Buffer buffer = queue.remove(channel.bufferAllocator(), 128, channel.newPromise());
        Assertions.assertFalse((buffer.readableBytes() > 0 ? 1 : 0) != 0);
        buffer.close();
        Assertions.assertTrue((boolean)queue.isEmpty());
        Assertions.assertEquals((int)0, (int)queue.readableBytes());
        Assertions.assertFalse((boolean)channel.finish());
    }
}

