/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.socket.ServerSocketChannel;
import io.netty5.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public abstract class AbstractEventLoopTest {
    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testShutdownGracefullyNoQuietPeriod() throws Exception {
        EventLoopGroup loop = this.newEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        b.group(loop).channel(this.newChannel()).childHandler(new ChannelHandler(){});
        b.bind(0).sync();
        Future f = loop.shutdownGracefully(0L, 1L, TimeUnit.MINUTES);
        Assertions.assertTrue((boolean)loop.awaitTermination(600L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)f.syncUninterruptibly().isSuccess());
        Assertions.assertTrue((boolean)loop.isShutdown());
        Assertions.assertTrue((boolean)loop.isTerminated());
    }

    protected abstract EventLoopGroup newEventLoopGroup();

    protected abstract Class<? extends ServerSocketChannel> newChannel();
}

