/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.channel.AdaptiveRecvBufferAllocator;
import io.netty5.channel.ChannelConfig;
import io.netty5.channel.RecvBufferAllocator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public class AdaptiveRecvBufferAllocatorTest {
    @Mock
    private ChannelConfig config;
    private RecvBufferAllocator.Handle handle;

    @BeforeEach
    public void setup() {
        this.config = (ChannelConfig)Mockito.mock(ChannelConfig.class);
        Mockito.when((Object)this.config.isAutoRead()).thenReturn((Object)true);
        AdaptiveRecvBufferAllocator recvBufferAllocator = new AdaptiveRecvBufferAllocator(64, 512, 0xA00000);
        this.handle = recvBufferAllocator.newHandle();
        this.handle.reset(this.config);
    }

    @Test
    public void rampUpBeforeReadCompleteWhenLargeDataPending() {
        try (BufferAllocator alloc = BufferAllocator.onHeapUnpooled();){
            AdaptiveRecvBufferAllocatorTest.allocReadExpected(this.handle, alloc, 512);
            AdaptiveRecvBufferAllocatorTest.allocReadExpected(this.handle, alloc, 8192);
            AdaptiveRecvBufferAllocatorTest.allocReadExpected(this.handle, alloc, 131072);
            AdaptiveRecvBufferAllocatorTest.allocReadExpected(this.handle, alloc, 0x200000);
            this.handle.readComplete();
            this.handle.reset(this.config);
            AdaptiveRecvBufferAllocatorTest.allocReadExpected(this.handle, alloc, 0x800000);
        }
    }

    @Test
    public void memoryAllocationIntervalsTest() {
        this.computingNext(512L, 512);
        this.computingNext(8192L, 1110);
        this.computingNext(8192L, 1200);
        this.computingNext(4096L, 1300);
        this.computingNext(4096L, 1500);
        this.computingNext(2048L, 1700);
        this.computingNext(2048L, 1550);
        this.computingNext(2048L, 2000);
        this.computingNext(2048L, 1900);
    }

    private void computingNext(long expectedSize, int actualReadBytes) {
        Assertions.assertEquals((long)expectedSize, (long)this.handle.guess());
        this.handle.reset(this.config);
        this.handle.lastBytesRead(actualReadBytes);
        this.handle.readComplete();
    }

    @Test
    public void lastPartialReadDoesNotRampDown() {
        try (BufferAllocator alloc = BufferAllocator.onHeapUnpooled();){
            AdaptiveRecvBufferAllocatorTest.allocReadExpected(this.handle, alloc, 512);
            AdaptiveRecvBufferAllocatorTest.allocRead(this.handle, alloc, 8192, 1);
            this.handle.readComplete();
            this.handle.reset(this.config);
            AdaptiveRecvBufferAllocatorTest.allocReadExpected(this.handle, alloc, 8192);
        }
    }

    @Test
    public void lastPartialReadCanRampUp() {
        try (BufferAllocator alloc = BufferAllocator.onHeapUnpooled();){
            AdaptiveRecvBufferAllocatorTest.allocReadExpected(this.handle, alloc, 512);
            AdaptiveRecvBufferAllocatorTest.allocRead(this.handle, alloc, 8192, 8191);
            this.handle.readComplete();
            this.handle.reset(this.config);
            AdaptiveRecvBufferAllocatorTest.allocReadExpected(this.handle, alloc, 131072);
        }
    }

    private static void allocReadExpected(RecvBufferAllocator.Handle handle, BufferAllocator alloc, int expectedSize) {
        AdaptiveRecvBufferAllocatorTest.allocRead(handle, alloc, expectedSize, expectedSize);
    }

    private static void allocRead(RecvBufferAllocator.Handle handle, BufferAllocator alloc, int expectedBufferSize, int lastRead) {
        try (Buffer buf = handle.allocate(alloc);){
            Assertions.assertEquals((int)expectedBufferSize, (int)buf.capacity());
            handle.attemptedBytesRead(expectedBufferSize);
            handle.lastBytesRead(lastRead);
            handle.incMessagesRead(1);
        }
    }
}

