/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty5.bootstrap.Bootstrap;
import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelInitializer;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.LoggingHandler;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.local.LocalChannel;
import io.netty5.channel.local.LocalHandler;
import io.netty5.channel.local.LocalServerChannel;
import org.junit.jupiter.api.Assertions;

class BaseChannelTest {
    private final LoggingHandler loggingHandler = new LoggingHandler();

    BaseChannelTest() {
    }

    ServerBootstrap getLocalServerBootstrap() {
        MultithreadEventLoopGroup serverGroup = new MultithreadEventLoopGroup(LocalHandler.newFactory());
        ServerBootstrap sb = new ServerBootstrap();
        sb.group((EventLoopGroup)serverGroup);
        sb.channel(LocalServerChannel.class);
        sb.childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
            }
        });
        return sb;
    }

    Bootstrap getLocalClientBootstrap() {
        MultithreadEventLoopGroup clientGroup = new MultithreadEventLoopGroup(LocalHandler.newFactory());
        Bootstrap cb = new Bootstrap();
        cb.channel(LocalChannel.class);
        cb.group((EventLoopGroup)clientGroup);
        cb.handler((ChannelHandler)this.loggingHandler);
        return cb;
    }

    static ByteBuf createTestBuf(int len) {
        ByteBuf buf = Unpooled.buffer((int)len, (int)len);
        buf.setIndex(0, len);
        return buf;
    }

    static Buffer createTestBuffer(int len) {
        Buffer buf = BufferAllocator.onHeapUnpooled().allocate(len);
        buf.writerOffset(len);
        return buf;
    }

    void assertLog(String firstExpected, String ... otherExpected) {
        String actual = this.loggingHandler.getLog();
        if (firstExpected.equals(actual)) {
            return;
        }
        for (String e : otherExpected) {
            if (!e.equals(actual)) continue;
            return;
        }
        Assertions.assertEquals((Object)firstExpected, (Object)actual);
    }

    void setInterest(LoggingHandler.Event ... events) {
        this.loggingHandler.setInterest(events);
    }
}

