/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.bootstrap.Bootstrap;
import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelInitializer;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.embedded.EmbeddedChannel;
import io.netty5.channel.local.LocalAddress;
import io.netty5.channel.local.LocalChannel;
import io.netty5.channel.local.LocalHandler;
import io.netty5.channel.local.LocalServerChannel;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ChannelInitializerTest {
    private static final int TIMEOUT_MILLIS = 1000;
    private static final LocalAddress SERVER_ADDRESS = new LocalAddress("addr");
    private EventLoopGroup group;
    private ServerBootstrap server;
    private Bootstrap client;
    private InspectableHandler testHandler;

    @BeforeEach
    public void setUp() {
        this.group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        this.server = (ServerBootstrap)new ServerBootstrap().group(this.group).channel(LocalServerChannel.class).localAddress((SocketAddress)SERVER_ADDRESS);
        this.client = (Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(LocalChannel.class).handler(new ChannelHandler(){});
        this.testHandler = new InspectableHandler();
    }

    @AfterEach
    public void tearDown() {
        this.group.shutdownGracefully(0L, 1000L, TimeUnit.MILLISECONDS).syncUninterruptibly();
    }

    @Test
    public void testInitChannelThrowsRegisterFirst() {
        this.testInitChannelThrows(true);
    }

    @Test
    public void testInitChannelThrowsRegisterAfter() {
        this.testInitChannelThrows(false);
    }

    private void testInitChannelThrows(boolean registerFirst) {
        final Exception exception = new Exception();
        final AtomicReference causeRef = new AtomicReference();
        ChannelPipeline pipeline = new LocalChannel(this.group.next()).pipeline();
        if (registerFirst) {
            pipeline.channel().register().syncUninterruptibly();
        }
        pipeline.addFirst(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                throw exception;
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                causeRef.set(cause);
                super.exceptionCaught(ctx, cause);
            }
        }});
        if (!registerFirst) {
            Assertions.assertTrue((boolean)(pipeline.channel().register().awaitUninterruptibly().cause() instanceof ClosedChannelException));
        }
        pipeline.channel().close().syncUninterruptibly();
        pipeline.channel().closeFuture().syncUninterruptibly();
        Assertions.assertSame((Object)exception, causeRef.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChannelInitializerInInitializerCorrectOrdering() throws Exception {
        final ChannelHandler handler1 = new ChannelHandler(){};
        final ChannelHandler handler2 = new ChannelHandler(){};
        final ChannelHandler handler3 = new ChannelHandler(){};
        final ChannelHandler handler4 = new ChannelHandler(){};
        ((Bootstrap)this.client.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{handler1});
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{handler2});
                        ch.pipeline().addLast(new ChannelHandler[]{handler3});
                    }
                }});
                ch.pipeline().addLast(new ChannelHandler[]{handler4});
            }
        })).localAddress((SocketAddress)LocalAddress.ANY);
        Channel channel = (Channel)this.client.bind().get();
        try {
            channel.executor().submit(() -> {}).syncUninterruptibly();
            Iterator handlers = channel.pipeline().iterator();
            Assertions.assertSame((Object)handler1, ((Map.Entry)handlers.next()).getValue());
            Assertions.assertSame((Object)handler2, ((Map.Entry)handlers.next()).getValue());
            Assertions.assertSame((Object)handler3, ((Map.Entry)handlers.next()).getValue());
            Assertions.assertSame((Object)handler4, ((Map.Entry)handlers.next()).getValue());
            Assertions.assertFalse((boolean)handlers.hasNext());
        }
        finally {
            channel.close().syncUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChannelInitializerReentrance() throws Exception {
        final AtomicInteger registeredCalled = new AtomicInteger(0);
        final ChannelHandler handler1 = new ChannelHandler(){

            public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
                registeredCalled.incrementAndGet();
            }
        };
        final AtomicInteger initChannelCalled = new AtomicInteger(0);
        ((Bootstrap)this.client.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                initChannelCalled.incrementAndGet();
                ch.pipeline().addLast(new ChannelHandler[]{handler1});
                ch.pipeline().fireChannelRegistered();
            }
        })).localAddress((SocketAddress)LocalAddress.ANY);
        Channel channel = (Channel)this.client.bind().get();
        try {
            channel.executor().submit(() -> {}).syncUninterruptibly();
            Assertions.assertEquals((int)1, (int)initChannelCalled.get());
            Assertions.assertEquals((int)2, (int)registeredCalled.get());
        }
        finally {
            channel.close().syncUninterruptibly();
        }
    }

    @Test
    @Timeout(value=1000L, unit=TimeUnit.MILLISECONDS)
    public void firstHandlerInPipelineShouldReceiveChannelRegisteredEvent() throws Exception {
        this.testChannelRegisteredEventPropagation(new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel channel) {
                channel.pipeline().addFirst(new ChannelHandler[]{ChannelInitializerTest.this.testHandler});
            }
        });
    }

    @Test
    @Timeout(value=1000L, unit=TimeUnit.MILLISECONDS)
    public void lastHandlerInPipelineShouldReceiveChannelRegisteredEvent() throws Exception {
        this.testChannelRegisteredEventPropagation(new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{ChannelInitializerTest.this.testHandler});
            }
        });
    }

    @Test
    public void testAddFirstChannelInitializer() {
        ChannelInitializerTest.testAddChannelInitializer(true);
    }

    @Test
    public void testAddLastChannelInitializer() {
        ChannelInitializerTest.testAddChannelInitializer(false);
    }

    private static void testAddChannelInitializer(final boolean first) {
        final AtomicBoolean called = new AtomicBoolean();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelInitializer<Channel> handler = new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        called.set(true);
                    }
                };
                if (first) {
                    ch.pipeline().addFirst(new ChannelHandler[]{handler});
                } else {
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                }
            }
        }});
        channel.finish();
        Assertions.assertTrue((boolean)called.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testChannelRegisteredEventPropagation(ChannelInitializer<LocalChannel> init) throws Exception {
        Channel clientChannel = null;
        Channel serverChannel = null;
        try {
            this.server.childHandler(init);
            serverChannel = (Channel)this.server.bind().get();
            clientChannel = (Channel)this.client.connect((SocketAddress)SERVER_ADDRESS).get();
            Assertions.assertEquals((int)1, (int)this.testHandler.channelRegisteredCount.get());
        }
        catch (Throwable throwable) {
            ChannelInitializerTest.closeChannel(clientChannel);
            ChannelInitializerTest.closeChannel(serverChannel);
            throw throwable;
        }
        ChannelInitializerTest.closeChannel(clientChannel);
        ChannelInitializerTest.closeChannel(serverChannel);
    }

    private static void closeChannel(Channel c) {
        if (c != null) {
            c.close().syncUninterruptibly();
        }
    }

    private static final class InspectableHandler
    implements ChannelHandler {
        final AtomicInteger channelRegisteredCount = new AtomicInteger(0);

        private InspectableHandler() {
        }

        public void channelRegistered(ChannelHandlerContext ctx) {
            this.channelRegisteredCount.incrementAndGet();
            ctx.fireChannelRegistered();
        }
    }
}

