/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.CompositeBuffer;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelConfig;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelMetadata;
import io.netty5.channel.ChannelOutboundBuffer;
import io.netty5.channel.DefaultChannelConfig;
import io.netty5.channel.EventLoop;
import io.netty5.channel.IoExecutionContext;
import io.netty5.channel.IoHandler;
import io.netty5.channel.SingleThreadEventLoop;
import io.netty5.channel.embedded.EmbeddedChannel;
import io.netty5.util.CharsetUtil;
import io.netty5.util.concurrent.Promise;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChannelOutboundBufferTest {
    @Test
    public void testEmptyNioBuffers() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buffer.nioBufferCount());
        ByteBuffer[] buffers = buffer.nioBuffers();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)buffers);
        for (ByteBuffer b : buffers) {
            org.junit.jupiter.api.Assertions.assertNull((Object)b);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buffer.nioBufferCount());
        ChannelOutboundBufferTest.release(buffer);
    }

    @Test
    public void flushingEmptyBuffers() throws Exception {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        Buffer buf = BufferAllocator.onHeapUnpooled().allocate(0);
        buffer.addMessage((Object)buf, 0, channel.newPromise());
        buffer.addFlush();
        AtomicInteger messageCounter = new AtomicInteger();
        ChannelOutboundBuffer.MessageProcessor messageProcessor = msg -> {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)msg);
            messageCounter.incrementAndGet();
            return true;
        };
        buffer.forEachFlushedMessage(messageProcessor);
        Assertions.assertThat((int)messageCounter.get()).isOne();
        buffer.removeBytes(0L);
        messageCounter.set(0);
        buffer.forEachFlushedMessage(messageProcessor);
        Assertions.assertThat((int)messageCounter.get()).isZero();
    }

    @Test
    public void testNioBuffersSingleBackedByteBuf() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buffer.nioBufferCount());
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)"buf1", (Charset)CharsetUtil.US_ASCII);
        ByteBuffer nioBuf = buf.internalNioBuffer(buf.readerIndex(), buf.readableBytes());
        buffer.addMessage((Object)buf, buf.readableBytes(), channel.newPromise());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        buffer.addFlush();
        ByteBuffer[] buffers = buffer.nioBuffers();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)buffers);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        for (int i = 0; i < buffer.nioBufferCount(); ++i) {
            if (i == 0) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)buffers[0], (Object)nioBuf);
                continue;
            }
            org.junit.jupiter.api.Assertions.assertNull((Object)buffers[i]);
        }
        ChannelOutboundBufferTest.release(buffer);
    }

    @Test
    public void testNioBuffersSingleBacked() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buffer.nioBufferCount());
        Buffer buf = BufferAllocator.onHeapUnpooled().copyOf("buf1".getBytes(CharsetUtil.US_ASCII));
        buffer.addMessage((Object)buf, buf.readableBytes(), channel.newPromise());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        buffer.addFlush();
        ByteBuffer[] buffers = buffer.nioBuffers();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)buffers);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        for (int i = 0; i < buffer.nioBufferCount(); ++i) {
            if (i == 0) {
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buf.countReadableComponents());
                buf.forEachReadable(0, (index, component) -> {
                    org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)index, (String)"Expected buffer to only have a single component.");
                    org.junit.jupiter.api.Assertions.assertEquals((Object)buffers[0], (Object)component.readableBuffer());
                    return true;
                });
                continue;
            }
            org.junit.jupiter.api.Assertions.assertNull((Object)buffers[i]);
        }
        ChannelOutboundBufferTest.release(buffer);
    }

    @Test
    public void testNioBuffersExpandByteBuf() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        ByteBuf buf = Unpooled.directBuffer().writeBytes("buf1".getBytes(CharsetUtil.US_ASCII));
        for (int i = 0; i < 64; ++i) {
            buffer.addMessage((Object)buf.copy(), buf.readableBytes(), channel.newPromise());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        buffer.addFlush();
        ByteBuffer[] buffers = buffer.nioBuffers();
        org.junit.jupiter.api.Assertions.assertEquals((int)64, (int)buffer.nioBufferCount());
        for (int i = 0; i < buffer.nioBufferCount(); ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)buffers[i], (Object)buf.internalNioBuffer(buf.readerIndex(), buf.readableBytes()));
        }
        ChannelOutboundBufferTest.release(buffer);
        buf.release();
    }

    @Test
    public void testNioBuffersExpand() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        Buffer buf = BufferAllocator.offHeapUnpooled().copyOf("buf1".getBytes(CharsetUtil.US_ASCII));
        for (int i = 0; i < 64; ++i) {
            buffer.addMessage((Object)buf.copy(), buf.readableBytes(), channel.newPromise());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        buffer.addFlush();
        ByteBuffer[] buffers = buffer.nioBuffers();
        org.junit.jupiter.api.Assertions.assertEquals((int)64, (int)buffer.nioBufferCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buf.countReadableComponents());
        buf.forEachReadable(0, (index, component) -> {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)index);
            ByteBuffer expected = component.readableBuffer();
            for (int i = 0; i < buffer.nioBufferCount(); ++i) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)buffers[i]);
            }
            return true;
        });
        ChannelOutboundBufferTest.release(buffer);
        buf.close();
    }

    @Test
    public void testNioBuffersExpand2ByteBuf() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        CompositeByteBuf comp = Unpooled.compositeBuffer((int)256);
        ByteBuf buf = Unpooled.directBuffer().writeBytes("buf1".getBytes(CharsetUtil.US_ASCII));
        for (int i = 0; i < 65; ++i) {
            comp.addComponent(true, buf.copy());
        }
        buffer.addMessage((Object)comp, comp.readableBytes(), channel.newPromise());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        buffer.addFlush();
        ByteBuffer[] buffers = buffer.nioBuffers();
        org.junit.jupiter.api.Assertions.assertEquals((int)65, (int)buffer.nioBufferCount());
        for (int i = 0; i < buffer.nioBufferCount(); ++i) {
            if (i < 65) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)buffers[i], (Object)buf.internalNioBuffer(buf.readerIndex(), buf.readableBytes()));
                continue;
            }
            org.junit.jupiter.api.Assertions.assertNull((Object)buffers[i]);
        }
        ChannelOutboundBufferTest.release(buffer);
        buf.release();
    }

    @Test
    public void testNioBuffersExpand2() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        Buffer buf = BufferAllocator.offHeapUnpooled().copyOf("buf1".getBytes(CharsetUtil.US_ASCII));
        List sends = Stream.generate(() -> buf.copy().send()).limit(65L).collect(Collectors.toList());
        CompositeBuffer comp = BufferAllocator.offHeapUnpooled().compose(sends);
        buffer.addMessage((Object)comp, comp.readableBytes(), channel.newPromise());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        buffer.addFlush();
        ByteBuffer[] buffers = buffer.nioBuffers();
        org.junit.jupiter.api.Assertions.assertEquals((int)65, (int)buffer.nioBufferCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buf.countReadableComponents());
        buf.forEachReadable(0, (index, component) -> {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)index);
            ByteBuffer expected = component.readableBuffer();
            for (int i = 0; i < buffer.nioBufferCount(); ++i) {
                if (i < 65) {
                    org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)buffers[i]);
                    continue;
                }
                org.junit.jupiter.api.Assertions.assertNull((Object)buffers[i]);
            }
            return true;
        });
        ChannelOutboundBufferTest.release(buffer);
        buf.close();
    }

    @Test
    public void testNioBuffersMaxCountByteBuf() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        CompositeByteBuf comp = Unpooled.compositeBuffer((int)256);
        ByteBuf buf = Unpooled.directBuffer().writeBytes("buf1".getBytes(CharsetUtil.US_ASCII));
        for (int i = 0; i < 65; ++i) {
            comp.addComponent(true, buf.copy());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)65, (int)comp.nioBufferCount());
        buffer.addMessage((Object)comp, comp.readableBytes(), channel.newPromise());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        buffer.addFlush();
        int maxCount = 10;
        ByteBuffer[] buffers = buffer.nioBuffers(10, Integer.MAX_VALUE);
        org.junit.jupiter.api.Assertions.assertTrue((buffer.nioBufferCount() <= 10 ? 1 : 0) != 0, (String)"Should not be greater than maxCount");
        for (int i = 0; i < buffer.nioBufferCount(); ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)buffers[i], (Object)buf.internalNioBuffer(buf.readerIndex(), buf.readableBytes()));
        }
        ChannelOutboundBufferTest.release(buffer);
        buf.release();
    }

    @Test
    public void testNioBuffersMaxCount() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        Buffer buf = BufferAllocator.offHeapUnpooled().copyOf("buf1".getBytes(CharsetUtil.US_ASCII));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)buf.readableBytes());
        List sends = Stream.generate(() -> buf.copy().send()).limit(65L).collect(Collectors.toList());
        CompositeBuffer comp = BufferAllocator.offHeapUnpooled().compose(sends);
        org.junit.jupiter.api.Assertions.assertEquals((int)65, (int)comp.countComponents());
        buffer.addMessage((Object)comp, comp.readableBytes(), channel.newPromise());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buffer.nioBufferCount(), (String)"Should still be 0 as not flushed yet");
        buffer.addFlush();
        int maxCount = 10;
        ByteBuffer[] buffers = buffer.nioBuffers(10, Integer.MAX_VALUE);
        org.junit.jupiter.api.Assertions.assertTrue((buffer.nioBufferCount() <= 10 ? 1 : 0) != 0, (String)"Should not be greater than maxCount");
        buf.forEachReadable(0, (index, component) -> {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)index);
            ByteBuffer expected = component.readableBuffer();
            for (int i = 0; i < buffer.nioBufferCount(); ++i) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)buffers[i]);
            }
            return true;
        });
        ChannelOutboundBufferTest.release(buffer);
        buf.close();
    }

    @Test
    public void removeBytesByteBuf() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        ByteBuf buf = Unpooled.directBuffer().writeBytes("buf1".getBytes(CharsetUtil.US_ASCII));
        int size = buf.readableBytes();
        buffer.addMessage((Object)buf, size, channel.newPromise());
        buffer.addFlush();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)buffer.currentProgress());
        buffer.removeBytes((long)(size / 2));
        org.junit.jupiter.api.Assertions.assertEquals((long)(size / 2), (long)buffer.currentProgress());
        Assertions.assertThat((Object)buffer.current()).isNotNull();
        buffer.removeBytes((long)size);
        org.junit.jupiter.api.Assertions.assertNull((Object)buffer.current());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)buffer.currentProgress());
    }

    @Test
    public void removeBytes() {
        TestChannel channel = new TestChannel();
        ChannelOutboundBuffer buffer = new ChannelOutboundBuffer((AbstractChannel)channel);
        Buffer buf = BufferAllocator.onHeapUnpooled().copyOf("buf1".getBytes(CharsetUtil.US_ASCII));
        int size = buf.readableBytes();
        buffer.addMessage((Object)buf, size, channel.newPromise());
        buffer.addFlush();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)buffer.currentProgress());
        buffer.removeBytes((long)(size / 2));
        org.junit.jupiter.api.Assertions.assertEquals((long)(size / 2), (long)buffer.currentProgress());
        Assertions.assertThat((Object)buffer.current()).isNotNull();
        buffer.removeBytes((long)size);
        org.junit.jupiter.api.Assertions.assertNull((Object)buffer.current());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)buffer.currentProgress());
    }

    private static void release(ChannelOutboundBuffer buffer) {
        while (buffer.remove()) {
        }
    }

    @Test
    public void testWritability() {
        final StringBuilder buf = new StringBuilder();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
                buf.append(ctx.channel().isWritable());
                buf.append(' ');
            }
        }});
        ch.config().setWriteBufferLowWaterMark(128 + ChannelOutboundBuffer.CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD);
        ch.config().setWriteBufferHighWaterMark(256 + ChannelOutboundBuffer.CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD);
        ch.write((Object)Unpooled.buffer().writeZero(128));
        ch.write((Object)Unpooled.buffer().writeZero(2));
        Assertions.assertThat((String)buf.toString()).isEmpty();
        ch.unsafe().outboundBuffer().addFlush();
        ch.write((Object)Unpooled.buffer().writeZero(127));
        Assertions.assertThat((String)buf.toString()).isEqualTo("false ");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.unsafe().outboundBuffer().remove());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.unsafe().outboundBuffer().remove());
        Assertions.assertThat((long)ch.unsafe().outboundBuffer().totalPendingWriteBytes()).isEqualTo(127L + (long)ChannelOutboundBuffer.CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD);
        Assertions.assertThat((String)buf.toString()).isEqualTo("false true ");
        ChannelOutboundBufferTest.safeClose(ch);
    }

    @Test
    public void testUserDefinedWritability() {
        final StringBuilder buf = new StringBuilder();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
                buf.append(ctx.channel().isWritable());
                buf.append(' ');
            }
        }});
        ch.config().setWriteBufferLowWaterMark(128);
        ch.config().setWriteBufferHighWaterMark(256);
        ChannelOutboundBuffer cob = ch.unsafe().outboundBuffer();
        for (int i = 1; i <= 30; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cob.getUserDefinedWritability(i));
        }
        cob.setUserDefinedWritability(1, false);
        ch.runPendingTasks();
        Assertions.assertThat((String)buf.toString()).isEqualTo("false ");
        cob.setUserDefinedWritability(1, true);
        ch.runPendingTasks();
        Assertions.assertThat((String)buf.toString()).isEqualTo("false true ");
        ChannelOutboundBufferTest.safeClose(ch);
    }

    @Test
    public void testUserDefinedWritability2() {
        final StringBuilder buf = new StringBuilder();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
                buf.append(ctx.channel().isWritable());
                buf.append(' ');
            }
        }});
        ch.config().setWriteBufferLowWaterMark(128);
        ch.config().setWriteBufferHighWaterMark(256);
        ChannelOutboundBuffer cob = ch.unsafe().outboundBuffer();
        cob.setUserDefinedWritability(1, false);
        ch.runPendingTasks();
        Assertions.assertThat((String)buf.toString()).isEqualTo("false ");
        cob.setUserDefinedWritability(2, false);
        ch.runPendingTasks();
        Assertions.assertThat((String)buf.toString()).isEqualTo("false ");
        cob.setUserDefinedWritability(1, true);
        ch.runPendingTasks();
        Assertions.assertThat((String)buf.toString()).isEqualTo("false ");
        cob.setUserDefinedWritability(2, true);
        ch.runPendingTasks();
        Assertions.assertThat((String)buf.toString()).isEqualTo("false true ");
        ChannelOutboundBufferTest.safeClose(ch);
    }

    @Test
    public void testMixedWritability() {
        final StringBuilder buf = new StringBuilder();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
                buf.append(ctx.channel().isWritable());
                buf.append(' ');
            }
        }});
        ch.config().setWriteBufferLowWaterMark(128);
        ch.config().setWriteBufferHighWaterMark(256);
        ChannelOutboundBuffer cob = ch.unsafe().outboundBuffer();
        ch.executor().execute(() -> {
            ch.write((Object)Unpooled.buffer().writeZero(257));
            Assertions.assertThat((String)buf.toString()).isEqualTo("false ");
            cob.setUserDefinedWritability(1, false);
            ch.runPendingTasks();
            Assertions.assertThat((String)buf.toString()).isEqualTo("false ");
            ch.flush();
            Assertions.assertThat((long)cob.totalPendingWriteBytes()).isEqualTo(0L);
            Assertions.assertThat((String)buf.toString()).isEqualTo("false ");
            cob.setUserDefinedWritability(1, true);
            ch.runPendingTasks();
            Assertions.assertThat((String)buf.toString()).isEqualTo("false true ");
        });
        ChannelOutboundBufferTest.safeClose(ch);
    }

    private static void safeClose(EmbeddedChannel ch) {
        Object m;
        ch.finish();
        do {
            if ((m = ch.readOutbound()) instanceof ByteBuf) {
                ((ByteBuf)m).release();
            }
            if (!(m instanceof Buffer)) continue;
            ((Buffer)m).close();
        } while (m != null);
    }

    private static final class TestChannel
    extends AbstractChannel {
        private static final ChannelMetadata TEST_METADATA = new ChannelMetadata(false);
        private final ChannelConfig config = new DefaultChannelConfig((Channel)this);

        TestChannel() {
            super(null, (EventLoop)new SingleThreadEventLoop(Executors.defaultThreadFactory(), new IoHandler(){

                public int run(IoExecutionContext runner) {
                    return 0;
                }

                public void wakeup(boolean inEventLoop) {
                }

                public void destroy() {
                }

                public void register(Channel channel) {
                }

                public void prepareToDestroy() {
                }

                public void deregister(Channel channel) {
                }
            }));
        }

        protected AbstractChannel.AbstractUnsafe newUnsafe() {
            return new TestUnsafe();
        }

        protected SocketAddress localAddress0() {
            throw new UnsupportedOperationException();
        }

        protected SocketAddress remoteAddress0() {
            throw new UnsupportedOperationException();
        }

        protected void doBind(SocketAddress localAddress) throws Exception {
            throw new UnsupportedOperationException();
        }

        protected void doDisconnect() throws Exception {
            throw new UnsupportedOperationException();
        }

        protected void doClose() throws Exception {
            throw new UnsupportedOperationException();
        }

        protected void doBeginRead() throws Exception {
            throw new UnsupportedOperationException();
        }

        protected void doWrite(ChannelOutboundBuffer in) throws Exception {
            throw new UnsupportedOperationException();
        }

        public ChannelConfig config() {
            return this.config;
        }

        public boolean isOpen() {
            return true;
        }

        public boolean isActive() {
            return true;
        }

        public ChannelMetadata metadata() {
            return TEST_METADATA;
        }

        final class TestUnsafe
        extends AbstractChannel.AbstractUnsafe {
            TestUnsafe() {
                super((AbstractChannel)TestChannel.this);
            }

            public void connect(SocketAddress remoteAddress, SocketAddress localAddress, Promise<Void> promise) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

