/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.channel.AbstractCoalescingBufferQueue;
import io.netty5.channel.Channel;
import io.netty5.channel.CoalescingBufferQueue;
import io.netty5.channel.WriteBufferWaterMark;
import io.netty5.channel.embedded.EmbeddedChannel;
import io.netty5.util.CharsetUtil;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.Promise;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CoalescingBufferQueueTest {
    private Buffer cat;
    private Buffer mouse;
    private Promise<Void> catPromise;
    private Promise<Void> emptyPromise;
    private FutureListener<Void> mouseListener;
    private boolean mouseDone;
    private boolean mouseSuccess;
    private EmbeddedChannel channel;
    private CoalescingBufferQueue writeQueue;

    @BeforeEach
    public void setup() {
        this.mouseDone = false;
        this.mouseSuccess = false;
        this.channel = new EmbeddedChannel();
        this.writeQueue = new CoalescingBufferQueue((Channel)this.channel, 16, true);
        this.catPromise = this.newPromise();
        this.mouseListener = future -> {
            this.mouseDone = true;
            this.mouseSuccess = future.isSuccess();
        };
        this.emptyPromise = this.newPromise();
        this.cat = BufferAllocator.offHeapUnpooled().copyOf("cat".getBytes(CharsetUtil.US_ASCII));
        this.mouse = BufferAllocator.offHeapUnpooled().copyOf("mouse".getBytes(CharsetUtil.US_ASCII));
    }

    @AfterEach
    public void finish() {
        Assertions.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void testAddFirstPromiseRetained() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.assertQueueSize(3, false);
        this.writeQueue.add(this.mouse, this.mouseListener);
        this.assertQueueSize(8, false);
        Promise<Void> aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"catmous", (Object)this.dequeue(7, aggregatePromise));
        Buffer remainder = BufferAllocator.offHeapUnpooled().copyOf("mous".getBytes(CharsetUtil.US_ASCII));
        this.writeQueue.addFirst(remainder, aggregatePromise);
        Promise<Void> aggregatePromise2 = this.newPromise();
        Assertions.assertEquals((Object)"mouse", (Object)this.dequeue(5, aggregatePromise2));
        aggregatePromise2.setSuccess(null);
        Assertions.assertTrue((boolean)this.catPromise.isSuccess());
        Assertions.assertTrue((boolean)this.mouseSuccess);
        Assertions.assertFalse((boolean)this.cat.isAccessible());
        Assertions.assertFalse((boolean)this.mouse.isAccessible());
    }

    @Test
    public void testAggregateWithFullRead() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.assertQueueSize(3, false);
        this.writeQueue.add(this.mouse, this.mouseListener);
        this.assertQueueSize(8, false);
        Promise<Void> aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"catmouse", (Object)this.dequeue(8, aggregatePromise));
        this.assertQueueSize(0, true);
        Assertions.assertFalse((boolean)this.catPromise.isSuccess());
        Assertions.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess(null);
        Assertions.assertTrue((boolean)this.catPromise.isSuccess());
        Assertions.assertTrue((boolean)this.mouseSuccess);
        Assertions.assertFalse((boolean)this.cat.isAccessible());
        Assertions.assertFalse((boolean)this.mouse.isAccessible());
    }

    @Test
    public void testAggregateWithPartialRead() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.writeQueue.add(this.mouse, this.mouseListener);
        Promise<Void> aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"catm", (Object)this.dequeue(4, aggregatePromise));
        this.assertQueueSize(4, false);
        Assertions.assertFalse((boolean)this.catPromise.isSuccess());
        Assertions.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess(null);
        Assertions.assertTrue((boolean)this.catPromise.isSuccess());
        Assertions.assertFalse((boolean)this.mouseDone);
        aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"ouse", (Object)this.dequeue(Integer.MAX_VALUE, aggregatePromise));
        this.assertQueueSize(0, true);
        Assertions.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess(null);
        Assertions.assertTrue((boolean)this.mouseSuccess);
        Assertions.assertFalse((boolean)this.cat.isAccessible());
        Assertions.assertFalse((boolean)this.mouse.isAccessible());
    }

    @Test
    public void testReadExactAddedBufferSizeReturnsOriginal() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.writeQueue.add(this.mouse, this.mouseListener);
        Promise<Void> aggregatePromise = this.newPromise();
        Assertions.assertSame((Object)this.cat, (Object)this.writeQueue.remove(3, aggregatePromise));
        Assertions.assertFalse((boolean)this.catPromise.isSuccess());
        aggregatePromise.setSuccess(null);
        Assertions.assertTrue((boolean)this.catPromise.isSuccess());
        Assertions.assertTrue((boolean)this.cat.isAccessible());
        this.cat.close();
        aggregatePromise = this.newPromise();
        Assertions.assertSame((Object)this.mouse, (Object)this.writeQueue.remove(5, aggregatePromise));
        Assertions.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess(null);
        Assertions.assertTrue((boolean)this.mouseSuccess);
        Assertions.assertTrue((boolean)this.mouse.isAccessible());
        this.mouse.close();
    }

    @Test
    public void testReadEmptyQueueReturnsEmptyBuffer() {
        this.cat.close();
        this.mouse.close();
        this.assertQueueSize(0, true);
        Promise<Void> aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"", (Object)this.dequeue(Integer.MAX_VALUE, aggregatePromise));
        this.assertQueueSize(0, true);
    }

    @Test
    public void testReleaseAndFailAll() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.writeQueue.add(this.mouse, this.mouseListener);
        RuntimeException cause = new RuntimeException("ooops");
        this.writeQueue.releaseAndFailAll((Throwable)cause);
        Promise<Void> aggregatePromise = this.newPromise();
        this.assertQueueSize(0, true);
        Assertions.assertFalse((boolean)this.cat.isAccessible());
        Assertions.assertFalse((boolean)this.mouse.isAccessible());
        Assertions.assertSame((Object)cause, (Object)this.catPromise.cause());
        Assertions.assertEquals((Object)"", (Object)this.dequeue(Integer.MAX_VALUE, aggregatePromise));
        this.assertQueueSize(0, true);
    }

    @Test
    public void testEmptyBuffersAreCoalesced() {
        this.mouse.close();
        Buffer empty = BufferAllocator.offHeapUnpooled().allocate(0);
        this.assertQueueSize(0, true);
        this.writeQueue.add(this.cat, this.catPromise);
        this.writeQueue.add(empty, this.emptyPromise);
        this.assertQueueSize(3, false);
        Promise<Void> aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"cat", (Object)this.dequeue(3, aggregatePromise));
        this.assertQueueSize(0, true);
        Assertions.assertFalse((boolean)this.catPromise.isSuccess());
        Assertions.assertFalse((boolean)this.emptyPromise.isSuccess());
        aggregatePromise.setSuccess(null);
        Assertions.assertTrue((boolean)this.catPromise.isSuccess());
        Assertions.assertTrue((boolean)this.emptyPromise.isSuccess());
        Assertions.assertFalse((boolean)this.cat.isAccessible());
        Assertions.assertFalse((boolean)empty.isAccessible());
    }

    @Test
    public void testMerge() {
        this.writeQueue.add(this.cat, this.catPromise);
        CoalescingBufferQueue otherQueue = new CoalescingBufferQueue((Channel)this.channel);
        otherQueue.add(this.mouse, this.mouseListener);
        otherQueue.copyTo((AbstractCoalescingBufferQueue)this.writeQueue);
        this.assertQueueSize(8, false);
        Promise<Void> aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"catmouse", (Object)this.dequeue(8, aggregatePromise));
        this.assertQueueSize(0, true);
        Assertions.assertFalse((boolean)this.catPromise.isSuccess());
        Assertions.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess(null);
        Assertions.assertTrue((boolean)this.catPromise.isSuccess());
        Assertions.assertTrue((boolean)this.mouseSuccess);
        Assertions.assertFalse((boolean)this.cat.isAccessible());
        Assertions.assertFalse((boolean)this.mouse.isAccessible());
    }

    @Test
    public void testWritabilityChanged() {
        this.testWritabilityChanged0(false);
    }

    @Test
    public void testWritabilityChangedFailAll() {
        this.testWritabilityChanged0(true);
    }

    private void testWritabilityChanged0(boolean fail) {
        this.channel.config().setWriteBufferWaterMark(new WriteBufferWaterMark(3, 4));
        Assertions.assertTrue((boolean)this.channel.isWritable());
        this.writeQueue.add(BufferAllocator.offHeapUnpooled().copyOf(new byte[]{1, 2, 3}));
        Assertions.assertTrue((boolean)this.channel.isWritable());
        this.writeQueue.add(BufferAllocator.offHeapUnpooled().copyOf(new byte[]{4, 5}));
        Assertions.assertFalse((boolean)this.channel.isWritable());
        Assertions.assertEquals((int)5, (int)this.writeQueue.readableBytes());
        if (fail) {
            this.writeQueue.releaseAndFailAll((Throwable)new IllegalStateException());
        } else {
            Buffer buffer = this.writeQueue.removeFirst(this.channel.newPromise());
            Assertions.assertEquals((int)1, (int)buffer.readByte());
            Assertions.assertEquals((int)2, (int)buffer.readByte());
            Assertions.assertEquals((int)3, (int)buffer.readByte());
            Assertions.assertEquals((int)0, (int)buffer.readableBytes());
            buffer.close();
            Assertions.assertTrue((boolean)this.channel.isWritable());
            buffer = this.writeQueue.removeFirst(this.channel.newPromise());
            Assertions.assertEquals((int)4, (int)buffer.readByte());
            Assertions.assertEquals((int)5, (int)buffer.readByte());
            Assertions.assertEquals((int)0, (int)buffer.readableBytes());
            buffer.close();
        }
        Assertions.assertTrue((boolean)this.channel.isWritable());
        Assertions.assertTrue((boolean)this.writeQueue.isEmpty());
    }

    private Promise<Void> newPromise() {
        return this.channel.newPromise();
    }

    private void assertQueueSize(int size, boolean isEmpty) {
        Assertions.assertEquals((int)size, (int)this.writeQueue.readableBytes());
        if (isEmpty) {
            Assertions.assertTrue((boolean)this.writeQueue.isEmpty());
        } else {
            Assertions.assertFalse((boolean)this.writeQueue.isEmpty());
        }
    }

    private String dequeue(int numBytes, Promise<Void> aggregatePromise) {
        Buffer removed = this.writeQueue.remove(numBytes, aggregatePromise);
        String result = removed.toString(CharsetUtil.US_ASCII);
        ReferenceCountUtil.safeRelease((Object)removed);
        return result;
    }
}

