/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.CombinedChannelDuplexHandler;
import io.netty5.channel.embedded.EmbeddedChannel;
import io.netty5.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CombinedChannelDuplexHandlerTest {
    private static final Object MSG = new Object();
    private static final SocketAddress LOCAL_ADDRESS = new InetSocketAddress(0);
    private static final SocketAddress REMOTE_ADDRESS = new InetSocketAddress(0);
    private static final Throwable CAUSE = new Throwable();
    private static final Object USER_EVENT = new Object();

    @Test
    public void testInboundRemoveBeforeAdded() {
        CombinedChannelDuplexHandler handler = new CombinedChannelDuplexHandler(new ChannelHandler(){}, new ChannelHandler(){});
        Assertions.assertThrows(IllegalStateException.class, () -> ((CombinedChannelDuplexHandler)handler).removeInboundHandler());
    }

    @Test
    public void testOutboundRemoveBeforeAdded() {
        CombinedChannelDuplexHandler handler = new CombinedChannelDuplexHandler(new ChannelHandler(){}, new ChannelHandler(){});
        Assertions.assertThrows(IllegalStateException.class, () -> ((CombinedChannelDuplexHandler)handler).removeOutboundHandler());
    }

    @Test
    public void testInboundHandlerImplementsOutboundHandler() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CombinedChannelDuplexHandler(new ChannelHandler(){

            public Future<Void> bind(ChannelHandlerContext ctx, SocketAddress localAddress) {
                return ctx.newFailedFuture((Throwable)new UnsupportedOperationException());
            }
        }, new ChannelHandler(){}));
    }

    @Test
    public void testOutboundHandlerImplementsInboundHandler() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CombinedChannelDuplexHandler(new ChannelHandler(){}, new ChannelHandler(){

            public void channelActive(ChannelHandlerContext ctx) {
            }
        }));
    }

    @Test
    public void testInitNotCalledBeforeAdded() throws Exception {
        CombinedChannelDuplexHandler<ChannelHandler, ChannelHandler> handler = new CombinedChannelDuplexHandler<ChannelHandler, ChannelHandler>(){};
        Assertions.assertThrows(IllegalStateException.class, () -> CombinedChannelDuplexHandlerTest.lambda$testInitNotCalledBeforeAdded$2((CombinedChannelDuplexHandler)handler));
    }

    @Test
    public void testExceptionCaught() {
        final Exception exception = new Exception();
        final ArrayDeque queue = new ArrayDeque();
        ChannelHandler inboundHandler = new ChannelHandler(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                Assertions.assertSame((Object)exception, (Object)cause);
                queue.add(this);
                ctx.fireExceptionCaught(cause);
            }
        };
        ChannelHandler lastHandler = new ChannelHandler(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                Assertions.assertSame((Object)exception, (Object)cause);
                queue.add(this);
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CombinedChannelDuplexHandler(inboundHandler, new ChannelHandler(){}), lastHandler});
        channel.pipeline().fireExceptionCaught((Throwable)exception);
        Assertions.assertFalse((boolean)channel.finish());
        Assertions.assertSame((Object)inboundHandler, queue.poll());
        Assertions.assertSame((Object)lastHandler, queue.poll());
        Assertions.assertTrue((boolean)queue.isEmpty());
    }

    @Test
    public void testInboundEvents() {
        InboundEventHandler inboundHandler = new InboundEventHandler();
        CombinedChannelDuplexHandler handler = new CombinedChannelDuplexHandler((ChannelHandler)inboundHandler, new ChannelHandler(){});
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.pipeline().addLast(new ChannelHandler[]{handler});
        Assertions.assertEquals((Object)((Object)Event.HANDLER_ADDED), (Object)((Object)inboundHandler.pollEvent()));
        CombinedChannelDuplexHandlerTest.doInboundOperations((Channel)channel);
        CombinedChannelDuplexHandlerTest.assertInboundOperations(inboundHandler);
        handler.removeInboundHandler();
        Assertions.assertEquals((Object)((Object)Event.HANDLER_REMOVED), (Object)((Object)inboundHandler.pollEvent()));
        CombinedChannelDuplexHandlerTest.doInboundOperations((Channel)channel);
        Assertions.assertNull((Object)((Object)inboundHandler.pollEvent()));
        try {
            channel.checkException();
            Assertions.fail();
        }
        catch (Throwable cause) {
            Assertions.assertSame((Object)CAUSE, (Object)cause);
        }
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertNull((Object)((Object)inboundHandler.pollEvent()));
    }

    @Test
    public void testOutboundEvents() {
        ChannelHandlerAdapter inboundHandler = new ChannelHandlerAdapter(){};
        OutboundEventHandler outboundHandler = new OutboundEventHandler();
        CombinedChannelDuplexHandler handler = new CombinedChannelDuplexHandler((ChannelHandler)inboundHandler, (ChannelHandler)outboundHandler);
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.pipeline().addLast(new ChannelHandler[]{new OutboundEventHandler()});
        channel.pipeline().addLast(new ChannelHandler[]{handler});
        Assertions.assertEquals((Object)((Object)Event.HANDLER_ADDED), (Object)((Object)outboundHandler.pollEvent()));
        CombinedChannelDuplexHandlerTest.doOutboundOperations((Channel)channel);
        CombinedChannelDuplexHandlerTest.assertOutboundOperations(outboundHandler);
        handler.removeOutboundHandler();
        Assertions.assertEquals((Object)((Object)Event.HANDLER_REMOVED), (Object)((Object)outboundHandler.pollEvent()));
        CombinedChannelDuplexHandlerTest.doOutboundOperations((Channel)channel);
        Assertions.assertNull((Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertFalse((boolean)channel.finish());
        Assertions.assertNull((Object)((Object)outboundHandler.pollEvent()));
    }

    private static void doOutboundOperations(Channel channel) {
        channel.pipeline().bind(LOCAL_ADDRESS).syncUninterruptibly();
        channel.pipeline().connect(REMOTE_ADDRESS, LOCAL_ADDRESS).syncUninterruptibly();
        channel.pipeline().write(MSG).syncUninterruptibly();
        channel.pipeline().flush();
        channel.pipeline().read();
        channel.pipeline().disconnect().syncUninterruptibly();
        channel.pipeline().close().syncUninterruptibly();
        channel.pipeline().deregister().syncUninterruptibly();
    }

    private static void assertOutboundOperations(OutboundEventHandler outboundHandler) {
        Assertions.assertEquals((Object)((Object)Event.BIND), (Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.CONNECT), (Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.WRITE), (Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.FLUSH), (Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.READ), (Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.CLOSE), (Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.CLOSE), (Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.DEREGISTER), (Object)((Object)outboundHandler.pollEvent()));
    }

    private static void doInboundOperations(Channel channel) {
        channel.pipeline().fireChannelRegistered();
        channel.pipeline().fireChannelActive();
        channel.pipeline().fireChannelRead(MSG);
        channel.pipeline().fireChannelReadComplete();
        channel.pipeline().fireExceptionCaught(CAUSE);
        channel.pipeline().fireUserEventTriggered(USER_EVENT);
        channel.pipeline().fireChannelWritabilityChanged();
        channel.pipeline().fireChannelInactive();
        channel.pipeline().fireChannelUnregistered();
    }

    private static void assertInboundOperations(InboundEventHandler handler) {
        Assertions.assertEquals((Object)((Object)Event.REGISTERED), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.ACTIVE), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.CHANNEL_READ), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.CHANNEL_READ_COMPLETE), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.EXCEPTION_CAUGHT), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.USER_EVENT_TRIGGERED), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.CHANNEL_WRITABILITY_CHANGED), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.INACTIVE), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.UNREGISTERED), (Object)((Object)handler.pollEvent()));
    }

    @Test
    public void testNotSharable() {
        Assertions.assertThrows(IllegalStateException.class, () -> new CombinedChannelDuplexHandler<ChannelHandler, ChannelHandler>(){

            public boolean isSharable() {
                return true;
            }
        });
    }

    private static /* synthetic */ void lambda$testInitNotCalledBeforeAdded$2(CombinedChannelDuplexHandler handler) throws Throwable {
        handler.handlerAdded(null);
    }

    private static final class OutboundEventHandler
    implements ChannelHandler {
        private final Queue<Object> queue = new ArrayDeque<Object>();

        private OutboundEventHandler() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.HANDLER_ADDED);
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.HANDLER_REMOVED);
        }

        public Future<Void> bind(ChannelHandlerContext ctx, SocketAddress localAddress) {
            try {
                Assertions.assertSame((Object)LOCAL_ADDRESS, (Object)localAddress);
                this.queue.add((Object)Event.BIND);
                return ctx.newSucceededFuture();
            }
            catch (AssertionError e) {
                return ctx.newFailedFuture((Throwable)((Object)e));
            }
        }

        public Future<Void> connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress) {
            try {
                Assertions.assertSame((Object)REMOTE_ADDRESS, (Object)remoteAddress);
                Assertions.assertSame((Object)LOCAL_ADDRESS, (Object)localAddress);
                this.queue.add((Object)Event.CONNECT);
                return ctx.newSucceededFuture();
            }
            catch (AssertionError e) {
                return ctx.newFailedFuture((Throwable)((Object)e));
            }
        }

        public Future<Void> disconnect(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.DISCONNECT);
            return ctx.newSucceededFuture();
        }

        public Future<Void> close(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.CLOSE);
            return ctx.newSucceededFuture();
        }

        public Future<Void> deregister(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.DEREGISTER);
            return ctx.newSucceededFuture();
        }

        public void read(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.READ);
        }

        public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
            try {
                Assertions.assertSame((Object)MSG, (Object)msg);
                this.queue.add((Object)Event.WRITE);
                return ctx.newSucceededFuture();
            }
            catch (AssertionError e) {
                return ctx.newFailedFuture((Throwable)((Object)e));
            }
        }

        public void flush(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.FLUSH);
        }

        Event pollEvent() {
            Object o = this.queue.poll();
            if (o instanceof AssertionError) {
                throw (AssertionError)o;
            }
            return (Event)((Object)o);
        }
    }

    private static final class InboundEventHandler
    implements ChannelHandler {
        private final Queue<Object> queue = new ArrayDeque<Object>();

        private InboundEventHandler() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.HANDLER_ADDED);
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.HANDLER_REMOVED);
        }

        public void channelRegistered(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.REGISTERED);
        }

        public void channelUnregistered(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.UNREGISTERED);
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.ACTIVE);
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.INACTIVE);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.queue.add((Object)Event.CHANNEL_READ);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.CHANNEL_READ_COMPLETE);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            this.queue.add((Object)Event.USER_EVENT_TRIGGERED);
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.CHANNEL_WRITABILITY_CHANGED);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.queue.add((Object)Event.EXCEPTION_CAUGHT);
        }

        Event pollEvent() {
            Object o = this.queue.poll();
            if (o instanceof AssertionError) {
                throw (AssertionError)o;
            }
            return (Event)((Object)o);
        }
    }

    private static enum Event {
        REGISTERED,
        UNREGISTERED,
        ACTIVE,
        INACTIVE,
        CHANNEL_READ,
        CHANNEL_READ_COMPLETE,
        EXCEPTION_CAUGHT,
        USER_EVENT_TRIGGERED,
        CHANNEL_WRITABILITY_CHANGED,
        HANDLER_ADDED,
        HANDLER_REMOVED,
        BIND,
        CONNECT,
        WRITE,
        FLUSH,
        READ,
        REGISTER,
        DEREGISTER,
        CLOSE,
        DISCONNECT;

    }
}

