/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty5.buffer.BufferInputStream;
import io.netty5.buffer.BufferOutputStream;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.channel.ChannelId;
import io.netty5.channel.DefaultChannelId;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultChannelIdTest {
    @Test
    public void testShortText() {
        String text = DefaultChannelId.newInstance().asShortText();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)text.matches("^[0-9a-f]{8}$"));
    }

    @Test
    public void testLongText() {
        String text = DefaultChannelId.newInstance().asLongText();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)text.matches("^[0-9a-f]{16}-[0-9a-f]{8}-[0-9a-f]{8}-[0-9a-f]{16}-[0-9a-f]{8}$"));
    }

    @Test
    public void testIdempotentMachineId() {
        String a = DefaultChannelId.newInstance().asLongText().substring(0, 16);
        String b = DefaultChannelId.newInstance().asLongText().substring(0, 16);
        Assertions.assertThat((String)a).isEqualTo(b);
    }

    @Test
    public void testIdempotentProcessId() {
        String a = DefaultChannelId.newInstance().asLongText().substring(17, 21);
        String b = DefaultChannelId.newInstance().asLongText().substring(17, 21);
        Assertions.assertThat((String)a).isEqualTo(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerializationByteBuf() throws Exception {
        ChannelId b;
        DefaultChannelId a = DefaultChannelId.newInstance();
        ByteBuf buf = Unpooled.buffer();
        try (ObjectOutputStream out = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(buf));){
            out.writeObject(a);
            out.flush();
        }
        try (ObjectInputStream in = new ObjectInputStream((InputStream)new ByteBufInputStream(buf, true));){
            b = (ChannelId)in.readObject();
        }
        Assertions.assertThat((Comparable)a).isEqualTo((Object)b);
        Assertions.assertThat((Comparable)a).isNotSameAs((Object)b);
        Assertions.assertThat((String)a.asLongText()).isEqualTo(b.asLongText());
    }

    @Test
    public void testSerialization() throws Exception {
        ChannelId b;
        DefaultChannelId a = DefaultChannelId.newInstance();
        Buffer buf = BufferAllocator.onHeapUnpooled().allocate(256);
        try (ObjectOutputStream out = new ObjectOutputStream((OutputStream)new BufferOutputStream(buf));){
            out.writeObject(a);
            out.flush();
        }
        try (ObjectInputStream in = new ObjectInputStream((InputStream)new BufferInputStream(buf.send()));){
            b = (ChannelId)in.readObject();
        }
        Assertions.assertThat((Comparable)a).isEqualTo((Object)b);
        Assertions.assertThat((Comparable)a).isNotSameAs((Object)b);
        Assertions.assertThat((String)a.asLongText()).isEqualTo(b.asLongText());
    }
}

