/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.AbstractChannel;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelConfig;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelMetadata;
import io.netty5.channel.ChannelOutboundBuffer;
import io.netty5.channel.DefaultChannelConfig;
import io.netty5.channel.DefaultChannelPipeline;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.local.LocalHandler;
import io.netty5.util.concurrent.Promise;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class DefaultChannelPipelineTailTest {
    private static EventLoopGroup GROUP;

    @BeforeAll
    public static void init() {
        GROUP = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
    }

    @AfterAll
    public static void destroy() {
        GROUP.shutdownGracefully();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnUnhandledInboundChannelActive() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        EventLoop loop = GROUP.next();
        MyChannel myChannel = new MyChannel(loop){

            @Override
            protected void onUnhandledInboundChannelActive() {
                latch.countDown();
            }
        };
        myChannel.pipeline().fireChannelActive();
        try {
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        }
        finally {
            myChannel.close();
        }
    }

    @Test
    public void testOnUnhandledInboundChannelInactive() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        EventLoop loop = GROUP.next();
        MyChannel myChannel = new MyChannel(loop){

            @Override
            protected void onUnhandledInboundChannelInactive() {
                latch.countDown();
            }
        };
        myChannel.pipeline().fireChannelInactive();
        myChannel.close().syncUninterruptibly();
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnUnhandledInboundException() throws Exception {
        final AtomicReference causeRef = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        EventLoop loop = GROUP.next();
        try (MyChannel myChannel = new MyChannel(loop){

            @Override
            protected void onUnhandledInboundException(Throwable cause) {
                causeRef.set(cause);
                latch.countDown();
            }
        };){
            IOException ex = new IOException("testOnUnhandledInboundException");
            myChannel.pipeline().fireExceptionCaught((Throwable)ex);
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
            Assertions.assertSame((Object)ex, causeRef.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnUnhandledInboundMessage() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        EventLoop loop = GROUP.next();
        try (MyChannel myChannel = new MyChannel(loop){

            @Override
            protected void onUnhandledInboundMessage(Object msg) {
                latch.countDown();
            }
        };){
            myChannel.pipeline().fireChannelRead((Object)"testOnUnhandledInboundMessage");
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnUnhandledInboundReadComplete() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        EventLoop loop = GROUP.next();
        try (MyChannel myChannel = new MyChannel(loop){

            @Override
            protected void onUnhandledInboundReadComplete() {
                latch.countDown();
            }
        };){
            myChannel.pipeline().fireChannelReadComplete();
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnUnhandledInboundUserEventTriggered() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        EventLoop loop = GROUP.next();
        try (MyChannel myChannel = new MyChannel(loop){

            @Override
            protected void onUnhandledInboundUserEventTriggered(Object evt) {
                latch.countDown();
            }
        };){
            myChannel.pipeline().fireUserEventTriggered((Object)"testOnUnhandledInboundUserEventTriggered");
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnUnhandledInboundWritabilityChanged() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        EventLoop loop = GROUP.next();
        try (MyChannel myChannel = new MyChannel(loop){

            @Override
            protected void onUnhandledInboundWritabilityChanged() {
                latch.countDown();
            }
        };){
            myChannel.pipeline().fireChannelWritabilityChanged();
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        }
    }

    private static abstract class MyChannel
    extends AbstractChannel {
        private static final ChannelMetadata METADATA = new ChannelMetadata(false);
        private final ChannelConfig config = new DefaultChannelConfig((Channel)this);
        private boolean active;
        private boolean closed;

        protected MyChannel(EventLoop eventLoop) {
            super(null, eventLoop);
        }

        protected DefaultChannelPipeline newChannelPipeline() {
            return new MyChannelPipeline((Channel)this);
        }

        public ChannelConfig config() {
            return this.config;
        }

        public boolean isOpen() {
            return !this.closed;
        }

        public boolean isActive() {
            return this.isOpen() && this.active;
        }

        public ChannelMetadata metadata() {
            return METADATA;
        }

        protected AbstractChannel.AbstractUnsafe newUnsafe() {
            return new MyUnsafe();
        }

        protected SocketAddress localAddress0() {
            return null;
        }

        protected SocketAddress remoteAddress0() {
            return null;
        }

        protected void doBind(SocketAddress localAddress) throws Exception {
        }

        protected void doDisconnect() throws Exception {
        }

        protected void doClose() throws Exception {
            this.closed = true;
        }

        protected void doBeginRead() throws Exception {
        }

        protected void doWrite(ChannelOutboundBuffer in) throws Exception {
            throw new IOException();
        }

        protected void onUnhandledInboundChannelActive() {
        }

        protected void onUnhandledInboundChannelInactive() {
        }

        protected void onUnhandledInboundException(Throwable cause) {
        }

        protected void onUnhandledInboundMessage(Object msg) {
        }

        protected void onUnhandledInboundReadComplete() {
        }

        protected void onUnhandledInboundUserEventTriggered(Object evt) {
        }

        protected void onUnhandledInboundWritabilityChanged() {
        }

        private class MyChannelPipeline
        extends DefaultChannelPipeline {
            MyChannelPipeline(Channel channel) {
                super(channel);
            }

            protected void onUnhandledInboundChannelActive() {
                MyChannel.this.onUnhandledInboundChannelActive();
            }

            protected void onUnhandledInboundChannelInactive() {
                MyChannel.this.onUnhandledInboundChannelInactive();
            }

            protected void onUnhandledInboundException(Throwable cause) {
                MyChannel.this.onUnhandledInboundException(cause);
            }

            protected void onUnhandledInboundMessage(ChannelHandlerContext ctx, Object msg) {
                MyChannel.this.onUnhandledInboundMessage(msg);
            }

            protected void onUnhandledInboundChannelReadComplete() {
                MyChannel.this.onUnhandledInboundReadComplete();
            }

            protected void onUnhandledInboundUserEventTriggered(Object evt) {
                MyChannel.this.onUnhandledInboundUserEventTriggered(evt);
            }

            protected void onUnhandledChannelWritabilityChanged() {
                MyChannel.this.onUnhandledInboundWritabilityChanged();
            }
        }

        private class MyUnsafe
        extends AbstractChannel.AbstractUnsafe {
            private MyUnsafe() {
                super((AbstractChannel)MyChannel.this);
            }

            public void connect(SocketAddress remoteAddress, SocketAddress localAddress, Promise<Void> promise) {
                if (!this.ensureOpen(promise)) {
                    return;
                }
                if (!MyChannel.this.active) {
                    MyChannel.this.active = true;
                    MyChannel.this.pipeline().fireChannelActive();
                    MyChannel.this.readIfIsAutoRead();
                }
                promise.setSuccess(null);
            }
        }
    }
}

