/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.bootstrap.Bootstrap;
import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelHandlerMask;
import io.netty5.channel.ChannelInitializer;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.ChannelPipelineException;
import io.netty5.channel.DefaultChannelHandlerContext;
import io.netty5.channel.DefaultChannelPipeline;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.embedded.EmbeddedChannel;
import io.netty5.channel.local.LocalAddress;
import io.netty5.channel.local.LocalChannel;
import io.netty5.channel.local.LocalHandler;
import io.netty5.channel.local.LocalServerChannel;
import io.netty5.channel.nio.NioHandler;
import io.netty5.channel.socket.nio.NioSocketChannel;
import io.netty5.util.AbstractReferenceCounted;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.ReferenceCounted;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.ImmediateEventExecutor;
import io.netty5.util.concurrent.Promise;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class DefaultChannelPipelineTest {
    private static final EventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
    private Channel self;
    private Channel peer;

    @AfterAll
    public static void afterClass() throws Exception {
        group.shutdownGracefully().sync();
    }

    private void setUp(final ChannelHandler ... handlers) throws Exception {
        final AtomicReference peerRef = new AtomicReference();
        ServerBootstrap sb = new ServerBootstrap();
        sb.group(group).channel(LocalServerChannel.class);
        sb.childHandler(new ChannelHandler(){

            public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
                peerRef.set(ctx.channel());
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ReferenceCountUtil.release((Object)msg);
            }
        });
        Channel channel = (Channel)sb.bind((SocketAddress)LocalAddress.ANY).get();
        Bootstrap b = new Bootstrap();
        ((Bootstrap)b.group(group)).channel(LocalChannel.class);
        b.handler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            protected void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(handlers);
            }
        });
        this.self = (Channel)b.connect(channel.localAddress()).get();
        this.peer = (Channel)peerRef.get();
        channel.close().sync();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.peer != null) {
            this.peer.close();
            this.peer = null;
        }
        if (this.self != null) {
            this.self = null;
        }
    }

    @Test
    public void testFreeCalled() throws Exception {
        final CountDownLatch free = new CountDownLatch(1);
        AbstractReferenceCounted holder = new AbstractReferenceCounted(){

            protected void deallocate() {
                free.countDown();
            }

            public ReferenceCounted touch(Object hint) {
                return this;
            }
        };
        StringInboundHandler handler = new StringInboundHandler();
        this.setUp(handler);
        this.peer.writeAndFlush((Object)holder).sync();
        Assertions.assertTrue((boolean)free.await(10L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)handler.called);
    }

    private static LocalChannel newLocalChannel() {
        return new LocalChannel(group.next());
    }

    @Test
    public void testAddLastVarArgsSkipsNull() {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        pipeline.addLast(new ChannelHandler[]{null, DefaultChannelPipelineTest.newHandler(), null});
        Assertions.assertEquals((int)1, (int)pipeline.names().size());
        Assertions.assertEquals((Object)"DefaultChannelPipelineTest$TestHandler#0", pipeline.names().get(0));
        pipeline.addLast(new ChannelHandler[]{DefaultChannelPipelineTest.newHandler(), null, DefaultChannelPipelineTest.newHandler()});
        Assertions.assertEquals((int)3, (int)pipeline.names().size());
        Assertions.assertEquals((Object)"DefaultChannelPipelineTest$TestHandler#0", pipeline.names().get(0));
        Assertions.assertEquals((Object)"DefaultChannelPipelineTest$TestHandler#1", pipeline.names().get(1));
        Assertions.assertEquals((Object)"DefaultChannelPipelineTest$TestHandler#2", pipeline.names().get(2));
        pipeline.addLast(new ChannelHandler[]{null});
        Assertions.assertEquals((int)3, (int)pipeline.names().size());
    }

    @Test
    public void testAddFirstVarArgsSkipsNull() {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        pipeline.addFirst(new ChannelHandler[]{null, DefaultChannelPipelineTest.newHandler(), null});
        Assertions.assertEquals((int)1, (int)pipeline.names().size());
        Assertions.assertEquals((Object)"DefaultChannelPipelineTest$TestHandler#0", pipeline.names().get(0));
        pipeline.addFirst(new ChannelHandler[]{DefaultChannelPipelineTest.newHandler(), null, DefaultChannelPipelineTest.newHandler()});
        Assertions.assertEquals((int)3, (int)pipeline.names().size());
        Assertions.assertEquals((Object)"DefaultChannelPipelineTest$TestHandler#2", pipeline.names().get(0));
        Assertions.assertEquals((Object)"DefaultChannelPipelineTest$TestHandler#1", pipeline.names().get(1));
        Assertions.assertEquals((Object)"DefaultChannelPipelineTest$TestHandler#0", pipeline.names().get(2));
        pipeline.addFirst(new ChannelHandler[]{null});
        Assertions.assertEquals((int)3, (int)pipeline.names().size());
    }

    @Test
    public void testRemoveChannelHandler() {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        ChannelHandler handler1 = DefaultChannelPipelineTest.newHandler();
        ChannelHandler handler2 = DefaultChannelPipelineTest.newHandler();
        ChannelHandler handler3 = DefaultChannelPipelineTest.newHandler();
        pipeline.addLast("handler1", handler1);
        pipeline.addLast("handler2", handler2);
        pipeline.addLast("handler3", handler3);
        Assertions.assertSame((Object)pipeline.get("handler1"), (Object)handler1);
        Assertions.assertSame((Object)pipeline.get("handler2"), (Object)handler2);
        Assertions.assertSame((Object)pipeline.get("handler3"), (Object)handler3);
        pipeline.remove(handler1);
        Assertions.assertNull((Object)pipeline.get("handler1"));
        pipeline.remove(handler2);
        Assertions.assertNull((Object)pipeline.get("handler2"));
        pipeline.remove(handler3);
        Assertions.assertNull((Object)pipeline.get("handler3"));
    }

    @Test
    public void testRemoveIfExists() {
        DefaultChannelPipeline pipeline = new DefaultChannelPipeline((Channel)DefaultChannelPipelineTest.newLocalChannel());
        ChannelHandler handler1 = DefaultChannelPipelineTest.newHandler();
        ChannelHandler handler2 = DefaultChannelPipelineTest.newHandler();
        ChannelHandler handler3 = DefaultChannelPipelineTest.newHandler();
        pipeline.addLast("handler1", handler1);
        pipeline.addLast("handler2", handler2);
        pipeline.addLast("handler3", handler3);
        Assertions.assertNotNull((Object)pipeline.removeIfExists(handler1));
        Assertions.assertNull((Object)pipeline.get("handler1"));
        Assertions.assertNotNull((Object)pipeline.removeIfExists("handler2"));
        Assertions.assertNull((Object)pipeline.get("handler2"));
        Assertions.assertNotNull((Object)pipeline.removeIfExists(TestHandler.class));
        Assertions.assertNull((Object)pipeline.get("handler3"));
    }

    @Test
    public void testRemoveIfExistsDoesNotThrowException() {
        DefaultChannelPipeline pipeline = new DefaultChannelPipeline((Channel)DefaultChannelPipelineTest.newLocalChannel());
        ChannelHandler handler1 = DefaultChannelPipelineTest.newHandler();
        ChannelHandler handler2 = DefaultChannelPipelineTest.newHandler();
        pipeline.addLast("handler1", handler1);
        Assertions.assertNull((Object)pipeline.removeIfExists("handlerXXX"));
        Assertions.assertNull((Object)pipeline.removeIfExists(handler2));
        class NonExistingHandler
        implements ChannelHandler {
            NonExistingHandler() {
            }
        }
        Assertions.assertNull((Object)pipeline.removeIfExists(NonExistingHandler.class));
        Assertions.assertNotNull((Object)pipeline.get("handler1"));
    }

    @Test
    public void testRemoveThrowNoSuchElementException() {
        DefaultChannelPipeline pipeline = new DefaultChannelPipeline((Channel)DefaultChannelPipelineTest.newLocalChannel());
        ChannelHandler handler1 = DefaultChannelPipelineTest.newHandler();
        pipeline.addLast("handler1", handler1);
        Assertions.assertThrows(NoSuchElementException.class, () -> pipeline.remove("handlerXXX"));
    }

    @Test
    public void testReplaceChannelHandler() {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        ChannelHandler handler1 = DefaultChannelPipelineTest.newHandler();
        pipeline.addLast("handler1", handler1);
        pipeline.addLast("handler2", handler1);
        pipeline.addLast("handler3", handler1);
        Assertions.assertSame((Object)pipeline.get("handler1"), (Object)handler1);
        Assertions.assertSame((Object)pipeline.get("handler2"), (Object)handler1);
        Assertions.assertSame((Object)pipeline.get("handler3"), (Object)handler1);
        ChannelHandler newHandler1 = DefaultChannelPipelineTest.newHandler();
        pipeline.replace("handler1", "handler1", newHandler1);
        Assertions.assertSame((Object)pipeline.get("handler1"), (Object)newHandler1);
        ChannelHandler newHandler3 = DefaultChannelPipelineTest.newHandler();
        pipeline.replace("handler3", "handler3", newHandler3);
        Assertions.assertSame((Object)pipeline.get("handler3"), (Object)newHandler3);
        ChannelHandler newHandler2 = DefaultChannelPipelineTest.newHandler();
        pipeline.replace("handler2", "handler2", newHandler2);
        Assertions.assertSame((Object)pipeline.get("handler2"), (Object)newHandler2);
    }

    @Test
    public void testReplaceHandlerChecksDuplicateNames() {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        ChannelHandler handler1 = DefaultChannelPipelineTest.newHandler();
        ChannelHandler handler2 = DefaultChannelPipelineTest.newHandler();
        pipeline.addLast("handler1", handler1);
        pipeline.addLast("handler2", handler2);
        ChannelHandler newHandler1 = DefaultChannelPipelineTest.newHandler();
        Assertions.assertThrows(IllegalArgumentException.class, () -> pipeline.replace("handler1", "handler2", newHandler1));
    }

    @Test
    public void testReplaceNameWithGenerated() {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        ChannelHandler handler1 = DefaultChannelPipelineTest.newHandler();
        pipeline.addLast("handler1", handler1);
        Assertions.assertSame((Object)pipeline.get("handler1"), (Object)handler1);
        ChannelHandler newHandler1 = DefaultChannelPipelineTest.newHandler();
        pipeline.replace("handler1", null, newHandler1);
        Assertions.assertSame((Object)pipeline.get("DefaultChannelPipelineTest$TestHandler#0"), (Object)newHandler1);
        Assertions.assertNull((Object)pipeline.get("handler1"));
    }

    @Test
    public void testRenameChannelHandler() {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        ChannelHandler handler1 = DefaultChannelPipelineTest.newHandler();
        pipeline.addLast("handler1", handler1);
        pipeline.addLast("handler2", handler1);
        pipeline.addLast("handler3", handler1);
        Assertions.assertSame((Object)pipeline.get("handler1"), (Object)handler1);
        Assertions.assertSame((Object)pipeline.get("handler2"), (Object)handler1);
        Assertions.assertSame((Object)pipeline.get("handler3"), (Object)handler1);
        ChannelHandler newHandler1 = DefaultChannelPipelineTest.newHandler();
        pipeline.replace("handler1", "newHandler1", newHandler1);
        Assertions.assertSame((Object)pipeline.get("newHandler1"), (Object)newHandler1);
        Assertions.assertNull((Object)pipeline.get("handler1"));
        ChannelHandler newHandler3 = DefaultChannelPipelineTest.newHandler();
        pipeline.replace("handler3", "newHandler3", newHandler3);
        Assertions.assertSame((Object)pipeline.get("newHandler3"), (Object)newHandler3);
        Assertions.assertNull((Object)pipeline.get("handler3"));
        ChannelHandler newHandler2 = DefaultChannelPipelineTest.newHandler();
        pipeline.replace("handler2", "newHandler2", newHandler2);
        Assertions.assertSame((Object)pipeline.get("newHandler2"), (Object)newHandler2);
        Assertions.assertNull((Object)pipeline.get("handler2"));
    }

    @Test
    public void testChannelHandlerContextNavigation() {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        int HANDLER_ARRAY_LEN = 5;
        ChannelHandler[] firstHandlers = DefaultChannelPipelineTest.newHandlers(5);
        ChannelHandler[] lastHandlers = DefaultChannelPipelineTest.newHandlers(5);
        pipeline.addFirst(firstHandlers);
        pipeline.addLast(lastHandlers);
        DefaultChannelPipelineTest.verifyContextNumber(pipeline, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testThrowInExceptionCaught() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger counter = new AtomicInteger();
        LocalChannel channel = DefaultChannelPipelineTest.newLocalChannel();
        try {
            channel.register().syncUninterruptibly();
            channel.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

                public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                    throw new TestException();
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    if (cause instanceof TestException) {
                        ctx.executor().execute(new Runnable(){

                            @Override
                            public void run() {
                                latch.countDown();
                            }
                        });
                    }
                    counter.incrementAndGet();
                    throw new Exception();
                }

                class TestException
                extends Exception {
                    TestException() {
                    }
                }
            }});
            channel.pipeline().fireChannelReadComplete();
            latch.await();
            Assertions.assertEquals((int)1, (int)counter.get());
        }
        finally {
            channel.close().syncUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testThrowInOtherHandlerAfterInvokedFromExceptionCaught() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger counter = new AtomicInteger();
        LocalChannel channel = DefaultChannelPipelineTest.newLocalChannel();
        try {
            channel.register().syncUninterruptibly();
            channel.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                    ctx.fireChannelReadComplete();
                }
            }, new ChannelHandler(){

                public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                    throw new TestException();
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    if (cause instanceof TestException) {
                        ctx.executor().execute(new Runnable(){

                            @Override
                            public void run() {
                                latch.countDown();
                            }
                        });
                    }
                    counter.incrementAndGet();
                    throw new Exception();
                }

                class TestException
                extends Exception {
                    TestException() {
                    }
                }
            }});
            channel.pipeline().fireExceptionCaught((Throwable)new Exception());
            latch.await();
            Assertions.assertEquals((int)1, (int)counter.get());
        }
        finally {
            channel.close().syncUninterruptibly();
        }
    }

    @Test
    public void testFireChannelRegistered() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        pipeline.addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

                    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
                        latch.countDown();
                    }
                }});
            }
        }});
        pipeline.channel().register();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
    }

    @Test
    public void testPipelineOperation() {
        int i;
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        int handlerNum = 5;
        ChannelHandler[] handlers1 = DefaultChannelPipelineTest.newHandlers(5);
        ChannelHandler[] handlers2 = DefaultChannelPipelineTest.newHandlers(5);
        String prefixX = "x";
        for (i = 0; i < 5; ++i) {
            if (i % 2 == 0) {
                pipeline.addFirst("x" + i, handlers1[i]);
                continue;
            }
            pipeline.addLast("x" + i, handlers1[i]);
        }
        for (i = 0; i < 5; ++i) {
            if (i % 2 != 0) {
                pipeline.addBefore("x" + i, String.valueOf(i), handlers2[i]);
                continue;
            }
            pipeline.addAfter("x" + i, String.valueOf(i), handlers2[i]);
        }
        DefaultChannelPipelineTest.verifyContextNumber(pipeline, 10);
    }

    @Test
    public void testChannelHandlerContextOrder() throws InterruptedException {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        CountDownLatch latch = new CountDownLatch(8);
        pipeline.addFirst("1", DefaultChannelPipelineTest.newHandler(latch));
        pipeline.addLast("10", DefaultChannelPipelineTest.newHandler(latch));
        pipeline.addBefore("10", "5", DefaultChannelPipelineTest.newHandler(latch));
        pipeline.addAfter("1", "3", DefaultChannelPipelineTest.newHandler(latch));
        pipeline.addBefore("5", "4", DefaultChannelPipelineTest.newHandler(latch));
        pipeline.addAfter("5", "6", DefaultChannelPipelineTest.newHandler(latch));
        pipeline.addBefore("1", "0", DefaultChannelPipelineTest.newHandler(latch));
        pipeline.addAfter("10", "11", DefaultChannelPipelineTest.newHandler(latch));
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        DefaultChannelHandlerContext ctx = (DefaultChannelHandlerContext)pipeline.firstContext();
        Assertions.assertNotNull((Object)ctx);
        while (ctx != null) {
            int i = DefaultChannelPipelineTest.toInt(ctx.name());
            int j = DefaultChannelPipelineTest.next(ctx);
            if (j != -1) {
                Assertions.assertTrue((i < j ? 1 : 0) != 0);
            } else {
                Assertions.assertNull((Object)ctx.next.next);
            }
            ctx = ctx.next;
        }
        DefaultChannelPipelineTest.verifyContextNumber(pipeline, 8);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testLifeCycleAwareness() throws Exception {
        this.setUp(new ChannelHandler[0]);
        ChannelPipeline p = this.self.pipeline();
        ArrayList handlers = new ArrayList();
        int COUNT = 20;
        CountDownLatch addLatch = new CountDownLatch(20);
        for (int i = 0; i < 20; ++i) {
            LifeCycleAwareTestHandler handler = new LifeCycleAwareTestHandler("handler-" + i);
            p.addFirst(handler.name, (ChannelHandler)handler);
            this.self.executor().execute(() -> {
                handler.validate(true, false);
                handlers.add(handler);
                addLatch.countDown();
            });
        }
        addLatch.await();
        Collections.shuffle(handlers);
        CountDownLatch removeLatch = new CountDownLatch(20);
        for (LifeCycleAwareTestHandler handler : handlers) {
            Assertions.assertSame((Object)((Object)handler), (Object)p.remove(handler.name));
            this.self.executor().execute(() -> {
                handler.validate(true, true);
                removeLatch.countDown();
            });
        }
        removeLatch.await();
    }

    @Test
    @Timeout(value=100000L, unit=TimeUnit.MILLISECONDS)
    public void testRemoveAndForwardInbound() throws Exception {
        BufferedTestHandler handler1 = new BufferedTestHandler();
        BufferedTestHandler handler2 = new BufferedTestHandler();
        this.setUp(handler1, handler2);
        this.self.executor().submit(() -> {
            ChannelPipeline p = this.self.pipeline();
            handler1.inboundBuffer.add(8);
            Assertions.assertEquals((Object)8, (Object)handler1.inboundBuffer.peek());
            Assertions.assertTrue((boolean)handler2.inboundBuffer.isEmpty());
            p.remove((ChannelHandler)handler1);
            Assertions.assertEquals((int)1, (int)handler2.inboundBuffer.size());
            Assertions.assertEquals((Object)8, (Object)handler2.inboundBuffer.peek());
        }).sync();
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testRemoveAndForwardOutbound() throws Exception {
        BufferedTestHandler handler1 = new BufferedTestHandler();
        BufferedTestHandler handler2 = new BufferedTestHandler();
        this.setUp(handler1, handler2);
        this.self.executor().submit(() -> {
            ChannelPipeline p = this.self.pipeline();
            handler2.outboundBuffer.add(8);
            Assertions.assertEquals((Object)8, (Object)handler2.outboundBuffer.peek());
            Assertions.assertTrue((boolean)handler1.outboundBuffer.isEmpty());
            p.remove((ChannelHandler)handler2);
            Assertions.assertEquals((int)1, (int)handler1.outboundBuffer.size());
            Assertions.assertEquals((Object)8, (Object)handler1.outboundBuffer.peek());
        }).sync();
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testReplaceAndForwardOutbound() throws Exception {
        BufferedTestHandler handler1 = new BufferedTestHandler();
        BufferedTestHandler handler2 = new BufferedTestHandler();
        this.setUp(handler1);
        this.self.executor().submit(() -> {
            ChannelPipeline p = this.self.pipeline();
            handler1.outboundBuffer.add(8);
            Assertions.assertEquals((Object)8, (Object)handler1.outboundBuffer.peek());
            Assertions.assertTrue((boolean)handler2.outboundBuffer.isEmpty());
            p.replace((ChannelHandler)handler1, "handler2", (ChannelHandler)handler2);
            Assertions.assertEquals((Object)8, (Object)handler2.outboundBuffer.peek());
        }).sync();
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testReplaceAndForwardInboundAndOutbound() throws Exception {
        BufferedTestHandler handler1 = new BufferedTestHandler();
        BufferedTestHandler handler2 = new BufferedTestHandler();
        this.setUp(handler1);
        this.self.executor().submit(() -> {
            ChannelPipeline p = this.self.pipeline();
            handler1.inboundBuffer.add(8);
            handler1.outboundBuffer.add(8);
            Assertions.assertEquals((Object)8, (Object)handler1.inboundBuffer.peek());
            Assertions.assertEquals((Object)8, (Object)handler1.outboundBuffer.peek());
            Assertions.assertTrue((boolean)handler2.inboundBuffer.isEmpty());
            Assertions.assertTrue((boolean)handler2.outboundBuffer.isEmpty());
            p.replace((ChannelHandler)handler1, "handler2", (ChannelHandler)handler2);
            Assertions.assertEquals((Object)8, (Object)handler2.outboundBuffer.peek());
            Assertions.assertEquals((Object)8, (Object)handler2.inboundBuffer.peek());
        }).sync();
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testRemoveAndForwardInboundOutbound() throws Exception {
        BufferedTestHandler handler1 = new BufferedTestHandler();
        BufferedTestHandler handler2 = new BufferedTestHandler();
        BufferedTestHandler handler3 = new BufferedTestHandler();
        this.setUp(handler1, handler2, handler3);
        this.self.executor().submit(() -> {
            ChannelPipeline p = this.self.pipeline();
            handler2.inboundBuffer.add(8);
            handler2.outboundBuffer.add(8);
            Assertions.assertEquals((Object)8, (Object)handler2.inboundBuffer.peek());
            Assertions.assertEquals((Object)8, (Object)handler2.outboundBuffer.peek());
            Assertions.assertEquals((int)0, (int)handler1.outboundBuffer.size());
            Assertions.assertEquals((int)0, (int)handler3.inboundBuffer.size());
            p.remove((ChannelHandler)handler2);
            Assertions.assertEquals((Object)8, (Object)handler3.inboundBuffer.peek());
            Assertions.assertEquals((Object)8, (Object)handler1.outboundBuffer.peek());
        }).sync();
    }

    @Test
    public void testFirstContextEmptyPipeline() throws Exception {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        Assertions.assertNull((Object)pipeline.firstContext());
    }

    @Test
    public void testLastContextEmptyPipeline() throws Exception {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        Assertions.assertNull((Object)pipeline.lastContext());
    }

    @Test
    public void testFirstHandlerEmptyPipeline() throws Exception {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        Assertions.assertNull((Object)pipeline.first());
    }

    @Test
    public void testLastHandlerEmptyPipeline() throws Exception {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        Assertions.assertNull((Object)pipeline.last());
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelInitializerException() throws Exception {
        final IllegalStateException exception = new IllegalStateException();
        final AtomicReference error = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        EmbeddedChannel channel = new EmbeddedChannel(false, false, new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                throw exception;
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                super.exceptionCaught(ctx, cause);
                error.set(cause);
                latch.countDown();
            }
        }});
        latch.await();
        Assertions.assertFalse((boolean)channel.isActive());
        Assertions.assertSame((Object)exception, error.get());
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testAddHandlerBeforeRegisteredThenRemove() {
        EventLoop loop = group.next();
        CheckEventExecutorHandler handler = new CheckEventExecutorHandler((EventExecutor)loop);
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        pipeline.addFirst(new ChannelHandler[]{handler});
        handler.addedFuture.syncUninterruptibly();
        pipeline.channel().register();
        pipeline.remove((ChannelHandler)handler);
        handler.removedFuture.syncUninterruptibly();
        pipeline.channel().close().syncUninterruptibly();
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testAddHandlerBeforeRegisteredThenReplace() throws Exception {
        EventLoop loop = group.next();
        final CountDownLatch latch = new CountDownLatch(1);
        CheckEventExecutorHandler handler = new CheckEventExecutorHandler((EventExecutor)loop);
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        pipeline.addFirst(new ChannelHandler[]{handler});
        handler.addedFuture.syncUninterruptibly();
        pipeline.channel().register();
        pipeline.replace((ChannelHandler)handler, null, (ChannelHandler)new ChannelHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                latch.countDown();
            }
        });
        handler.removedFuture.syncUninterruptibly();
        latch.await();
        pipeline.channel().close().syncUninterruptibly();
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testAddRemoveHandlerCalled() throws Throwable {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        CallbackCheckHandler handler = new CallbackCheckHandler();
        pipeline.addFirst(new ChannelHandler[]{handler});
        pipeline.remove((ChannelHandler)handler);
        Assertions.assertTrue((boolean)((Boolean)handler.addedHandler.get()));
        Assertions.assertTrue((boolean)((Boolean)handler.removedHandler.get()));
        CallbackCheckHandler handlerType = new CallbackCheckHandler();
        pipeline.addFirst(new ChannelHandler[]{handlerType});
        pipeline.remove(((Object)((Object)handlerType)).getClass());
        Assertions.assertTrue((boolean)((Boolean)handlerType.addedHandler.get()));
        Assertions.assertTrue((boolean)((Boolean)handlerType.removedHandler.get()));
        CallbackCheckHandler handlerName = new CallbackCheckHandler();
        pipeline.addFirst("handler", (ChannelHandler)handlerName);
        pipeline.remove("handler");
        Assertions.assertTrue((boolean)((Boolean)handlerName.addedHandler.get()));
        Assertions.assertTrue((boolean)((Boolean)handlerName.removedHandler.get()));
        CallbackCheckHandler first = new CallbackCheckHandler();
        pipeline.addFirst(new ChannelHandler[]{first});
        pipeline.removeFirst();
        Assertions.assertTrue((boolean)((Boolean)first.addedHandler.get()));
        Assertions.assertTrue((boolean)((Boolean)first.removedHandler.get()));
        CallbackCheckHandler last = new CallbackCheckHandler();
        pipeline.addFirst(new ChannelHandler[]{last});
        pipeline.removeLast();
        Assertions.assertTrue((boolean)((Boolean)last.addedHandler.get()));
        Assertions.assertTrue((boolean)((Boolean)last.removedHandler.get()));
        pipeline.channel().register().syncUninterruptibly();
        Throwable cause = handler.error.get();
        Throwable causeName = handlerName.error.get();
        Throwable causeType = handlerType.error.get();
        Throwable causeFirst = first.error.get();
        Throwable causeLast = last.error.get();
        pipeline.channel().close().syncUninterruptibly();
        DefaultChannelPipelineTest.rethrowIfNotNull(cause);
        DefaultChannelPipelineTest.rethrowIfNotNull(causeName);
        DefaultChannelPipelineTest.rethrowIfNotNull(causeType);
        DefaultChannelPipelineTest.rethrowIfNotNull(causeFirst);
        DefaultChannelPipelineTest.rethrowIfNotNull(causeLast);
    }

    private static void rethrowIfNotNull(Throwable cause) throws Throwable {
        if (cause != null) {
            throw cause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testOperationsFailWhenRemoved() {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        try {
            pipeline.channel().register().syncUninterruptibly();
            ChannelHandler handler = new ChannelHandler(){};
            pipeline.addFirst(new ChannelHandler[]{handler});
            ChannelHandlerContext ctx = pipeline.context(handler);
            pipeline.remove(handler);
            DefaultChannelPipelineTest.testOperationsFailsOnContext(ctx);
        }
        finally {
            pipeline.channel().close().syncUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testOperationsFailWhenReplaced() {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        try {
            pipeline.channel().register().syncUninterruptibly();
            ChannelHandler handler = new ChannelHandler(){};
            pipeline.addFirst(new ChannelHandler[]{handler});
            ChannelHandlerContext ctx = pipeline.context(handler);
            pipeline.replace(handler, null, new ChannelHandler(){});
            DefaultChannelPipelineTest.testOperationsFailsOnContext(ctx);
        }
        finally {
            pipeline.channel().close().syncUninterruptibly();
        }
    }

    private static void testOperationsFailsOnContext(ChannelHandlerContext ctx) {
        DefaultChannelPipelineTest.assertChannelPipelineException((Future<Void>)ctx.writeAndFlush((Object)""));
        DefaultChannelPipelineTest.assertChannelPipelineException((Future<Void>)ctx.write((Object)""));
        DefaultChannelPipelineTest.assertChannelPipelineException((Future<Void>)ctx.bind(new SocketAddress(){}));
        DefaultChannelPipelineTest.assertChannelPipelineException((Future<Void>)ctx.close());
        DefaultChannelPipelineTest.assertChannelPipelineException((Future<Void>)ctx.connect(new SocketAddress(){}));
        DefaultChannelPipelineTest.assertChannelPipelineException((Future<Void>)ctx.connect(new SocketAddress(){}, new SocketAddress(){}));
        DefaultChannelPipelineTest.assertChannelPipelineException((Future<Void>)ctx.deregister());
        DefaultChannelPipelineTest.assertChannelPipelineException((Future<Void>)ctx.disconnect());
        class ChannelPipelineExceptionValidator
        implements ChannelHandler {
            private Promise<Void> validationPromise = ImmediateEventExecutor.INSTANCE.newPromise();

            ChannelPipelineExceptionValidator() {
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                try {
                    MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(ChannelPipelineException.class));
                }
                catch (Throwable error) {
                    this.validationPromise.setFailure(error);
                    return;
                }
                this.validationPromise.setSuccess(null);
            }

            void validate() {
                this.validationPromise.asFuture().syncUninterruptibly();
                this.validationPromise = ImmediateEventExecutor.INSTANCE.newPromise();
            }
        }
        ChannelPipelineExceptionValidator validator = new ChannelPipelineExceptionValidator();
        ctx.pipeline().addLast(new ChannelHandler[]{validator});
        ctx.fireChannelRead((Object)"");
        validator.validate();
        ctx.fireUserEventTriggered((Object)"");
        validator.validate();
        ctx.fireChannelReadComplete();
        validator.validate();
        ctx.fireExceptionCaught((Throwable)new Exception());
        validator.validate();
        ctx.fireChannelActive();
        validator.validate();
        ctx.fireChannelRegistered();
        validator.validate();
        ctx.fireChannelInactive();
        validator.validate();
        ctx.fireChannelUnregistered();
        validator.validate();
        ctx.fireChannelWritabilityChanged();
        validator.validate();
    }

    private static void assertChannelPipelineException(Future<Void> f) {
        try {
            f.syncUninterruptibly();
        }
        catch (CompletionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(ChannelPipelineException.class));
        }
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testAddReplaceHandlerCalled() throws Throwable {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        CallbackCheckHandler handler = new CallbackCheckHandler();
        CallbackCheckHandler handler2 = new CallbackCheckHandler();
        pipeline.addFirst(new ChannelHandler[]{handler});
        pipeline.replace((ChannelHandler)handler, null, (ChannelHandler)handler2);
        Assertions.assertTrue((boolean)((Boolean)handler.addedHandler.get()));
        Assertions.assertTrue((boolean)((Boolean)handler.removedHandler.get()));
        Assertions.assertTrue((boolean)((Boolean)handler2.addedHandler.get()));
        Assertions.assertFalse((boolean)handler2.removedHandler.isDone());
        pipeline.channel().register().syncUninterruptibly();
        Throwable cause = handler.error.get();
        if (cause != null) {
            throw cause;
        }
        Throwable cause2 = handler2.error.get();
        if (cause2 != null) {
            throw cause2;
        }
        Assertions.assertFalse((boolean)handler2.removedHandler.isDone());
        pipeline.remove((ChannelHandler)handler2);
        Assertions.assertTrue((boolean)((Boolean)handler2.removedHandler.get()));
        pipeline.channel().close().syncUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testAddBefore() throws Throwable {
        MultithreadEventLoopGroup defaultGroup = new MultithreadEventLoopGroup(2, LocalHandler.newFactory());
        try {
            EventLoop eventLoop1 = defaultGroup.next();
            EventLoop eventLoop2 = defaultGroup.next();
            ChannelPipeline pipeline1 = new LocalChannel(eventLoop1).pipeline();
            ChannelPipeline pipeline2 = new LocalChannel(eventLoop2).pipeline();
            pipeline1.channel().register().syncUninterruptibly();
            pipeline2.channel().register().syncUninterruptibly();
            CountDownLatch latch = new CountDownLatch(20);
            for (int i = 0; i < 10; ++i) {
                eventLoop1.execute((Runnable)new TestTask(pipeline2, latch));
                eventLoop2.execute((Runnable)new TestTask(pipeline1, latch));
            }
            latch.await();
            pipeline1.channel().close().syncUninterruptibly();
            pipeline2.channel().close().syncUninterruptibly();
        }
        finally {
            defaultGroup.shutdownGracefully();
        }
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testAddInListenerNio() throws Throwable {
        MultithreadEventLoopGroup nioEventLoopGroup = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        try {
            DefaultChannelPipelineTest.testAddInListener((Channel)new NioSocketChannel(nioEventLoopGroup.next()));
        }
        finally {
            nioEventLoopGroup.shutdownGracefully();
        }
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testAddInListenerLocal() throws Throwable {
        DefaultChannelPipelineTest.testAddInListener((Channel)DefaultChannelPipelineTest.newLocalChannel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testAddInListener(Channel channel) throws Throwable {
        ChannelPipeline pipeline1 = channel.pipeline();
        try {
            final Object event = new Object();
            final Promise promise = ImmediateEventExecutor.INSTANCE.newPromise();
            pipeline1.channel().register().addListener((Object)channel, (ch, future) -> {
                ChannelPipeline pipeline = ch.pipeline();
                final AtomicBoolean handlerAddedCalled = new AtomicBoolean();
                pipeline.addLast(new ChannelHandler[]{new ChannelHandler(){

                    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                        handlerAddedCalled.set(true);
                    }

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        promise.setSuccess(event);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        promise.setFailure(cause);
                    }
                }});
                if (!handlerAddedCalled.get()) {
                    promise.setFailure((Throwable)((Object)new AssertionError((Object)"handlerAdded(...) should have been called")));
                    return;
                }
                pipeline.fireUserEventTriggered(event);
            });
            Assertions.assertSame((Object)event, (Object)promise.asFuture().syncUninterruptibly().getNow());
        }
        finally {
            pipeline1.channel().close().syncUninterruptibly();
        }
    }

    @Test
    public void testNullName() {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        pipeline.addLast(new ChannelHandler[]{DefaultChannelPipelineTest.newHandler()});
        pipeline.addLast(null, DefaultChannelPipelineTest.newHandler());
        pipeline.addFirst(new ChannelHandler[]{DefaultChannelPipelineTest.newHandler()});
        pipeline.addFirst(null, DefaultChannelPipelineTest.newHandler());
        pipeline.addLast("test", DefaultChannelPipelineTest.newHandler());
        pipeline.addAfter("test", null, DefaultChannelPipelineTest.newHandler());
        pipeline.addBefore("test", null, DefaultChannelPipelineTest.newHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandlerRemovedOnlyCalledWhenHandlerAddedCalled() throws Exception {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        try {
            final AtomicReference errorRef = new AtomicReference();
            for (int i = 0; i < 500; ++i) {
                ChannelPipeline pipeline = new LocalChannel(group.next()).pipeline();
                pipeline.channel().register().sync();
                final CountDownLatch latch = new CountDownLatch(1);
                pipeline.addLast(new ChannelHandler[]{new ChannelHandler(){

                    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
                        latch.await(50L, TimeUnit.MILLISECONDS);
                    }
                }});
                pipeline.close();
                pipeline.addLast(new ChannelHandler[]{new ChannelHandler(){
                    private boolean handerAddedCalled;

                    public void handlerAdded(ChannelHandlerContext ctx) {
                        this.handerAddedCalled = true;
                    }

                    public void handlerRemoved(ChannelHandlerContext ctx) {
                        if (!this.handerAddedCalled) {
                            errorRef.set(new AssertionError((Object)"handlerRemoved(...) called without handlerAdded(...) before"));
                        }
                    }
                }});
                latch.countDown();
                pipeline.channel().closeFuture().syncUninterruptibly();
                pipeline.channel().executor().submit(() -> {}).syncUninterruptibly();
                Error error = (Error)errorRef.get();
                if (error == null) continue;
                throw error;
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testSkipHandlerMethodsIfAnnotated() {
        EmbeddedChannel channel = new EmbeddedChannel(true, new ChannelHandler[0]);
        ChannelPipeline pipeline = channel.pipeline();
        final class OutboundCalledHandler
        implements ChannelHandler {
            private static final int MASK_BIND = 1;
            private static final int MASK_CONNECT = 2;
            private static final int MASK_DISCONNECT = 4;
            private static final int MASK_CLOSE = 8;
            private static final int MASK_REGISTER = 16;
            private static final int MASK_DEREGISTER = 32;
            private static final int MASK_READ = 64;
            private static final int MASK_WRITE = 128;
            private static final int MASK_FLUSH = 256;
            private static final int MASK_ADDED = 512;
            private static final int MASK_REMOVED = 1024;
            private int executionMask;

            OutboundCalledHandler() {
            }

            public void handlerAdded(ChannelHandlerContext ctx) {
                this.executionMask |= 0x200;
            }

            public void handlerRemoved(ChannelHandlerContext ctx) {
                this.executionMask |= 0x400;
            }

            public Future<Void> bind(ChannelHandlerContext ctx, SocketAddress localAddress) {
                this.executionMask |= 1;
                return ctx.newSucceededFuture();
            }

            public Future<Void> connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress) {
                this.executionMask |= 2;
                return ctx.newSucceededFuture();
            }

            public Future<Void> disconnect(ChannelHandlerContext ctx) {
                this.executionMask |= 4;
                return ctx.newSucceededFuture();
            }

            public Future<Void> close(ChannelHandlerContext ctx) {
                this.executionMask |= 8;
                return ctx.newSucceededFuture();
            }

            public Future<Void> register(ChannelHandlerContext ctx) {
                this.executionMask |= 0x10;
                return ctx.newSucceededFuture();
            }

            public Future<Void> deregister(ChannelHandlerContext ctx) {
                this.executionMask |= 0x20;
                return ctx.newSucceededFuture();
            }

            public void read(ChannelHandlerContext ctx) {
                this.executionMask |= 0x40;
            }

            public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
                this.executionMask |= 0x80;
                ReferenceCountUtil.release((Object)msg);
                return ctx.newSucceededFuture();
            }

            public void flush(ChannelHandlerContext ctx) {
                this.executionMask |= 0x100;
            }

            void assertCalled() {
                this.assertCalled("handlerAdded", 512);
                this.assertCalled("handlerRemoved", 1024);
                this.assertCalled("bind", 1);
                this.assertCalled("connect", 2);
                this.assertCalled("disconnect", 4);
                this.assertCalled("close", 8);
                this.assertCalled("register", 16);
                this.assertCalled("deregister", 32);
                this.assertCalled("read", 64);
                this.assertCalled("write", 128);
                this.assertCalled("flush", 256);
            }

            private void assertCalled(String methodName, int mask) {
                Assertions.assertTrue(((this.executionMask & mask) != 0 ? 1 : 0) != 0, (String)(methodName + " was not called"));
            }
        }
        OutboundCalledHandler outboundCalledHandler = new OutboundCalledHandler();
        final class SkipHandler
        implements ChannelHandler {
            private int state = 2;
            private Error errorRef;

            SkipHandler() {
            }

            private void fail() {
                this.errorRef = new AssertionError((Object)"Method should never been called");
            }

            @ChannelHandlerMask.Skip
            public Future<Void> bind(ChannelHandlerContext ctx, SocketAddress localAddress) {
                this.fail();
                return ctx.bind(localAddress);
            }

            @ChannelHandlerMask.Skip
            public Future<Void> connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress) {
                this.fail();
                return ctx.connect(remoteAddress, localAddress);
            }

            @ChannelHandlerMask.Skip
            public Future<Void> disconnect(ChannelHandlerContext ctx) {
                this.fail();
                return ctx.disconnect();
            }

            @ChannelHandlerMask.Skip
            public Future<Void> close(ChannelHandlerContext ctx) {
                this.fail();
                return ctx.close();
            }

            @ChannelHandlerMask.Skip
            public Future<Void> register(ChannelHandlerContext ctx) {
                this.fail();
                return ctx.register();
            }

            @ChannelHandlerMask.Skip
            public Future<Void> deregister(ChannelHandlerContext ctx) {
                this.fail();
                return ctx.deregister();
            }

            @ChannelHandlerMask.Skip
            public void read(ChannelHandlerContext ctx) {
                this.fail();
                ctx.read();
            }

            @ChannelHandlerMask.Skip
            public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
                this.fail();
                return ctx.write(msg);
            }

            @ChannelHandlerMask.Skip
            public void flush(ChannelHandlerContext ctx) {
                this.fail();
                ctx.flush();
            }

            @ChannelHandlerMask.Skip
            public void channelRegistered(ChannelHandlerContext ctx) {
                this.fail();
                ctx.fireChannelRegistered();
            }

            @ChannelHandlerMask.Skip
            public void channelUnregistered(ChannelHandlerContext ctx) {
                this.fail();
                ctx.fireChannelUnregistered();
            }

            @ChannelHandlerMask.Skip
            public void channelActive(ChannelHandlerContext ctx) {
                this.fail();
                ctx.fireChannelActive();
            }

            @ChannelHandlerMask.Skip
            public void channelInactive(ChannelHandlerContext ctx) {
                this.fail();
                ctx.fireChannelInactive();
            }

            @ChannelHandlerMask.Skip
            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                this.fail();
                ctx.fireChannelRead(msg);
            }

            @ChannelHandlerMask.Skip
            public void channelReadComplete(ChannelHandlerContext ctx) {
                this.fail();
                ctx.fireChannelReadComplete();
            }

            @ChannelHandlerMask.Skip
            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                this.fail();
                ctx.fireUserEventTriggered(evt);
            }

            @ChannelHandlerMask.Skip
            public void channelWritabilityChanged(ChannelHandlerContext ctx) {
                this.fail();
                ctx.fireChannelWritabilityChanged();
            }

            @ChannelHandlerMask.Skip
            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                this.fail();
                ctx.fireExceptionCaught(cause);
            }

            public void handlerAdded(ChannelHandlerContext ctx) {
                --this.state;
            }

            public void handlerRemoved(ChannelHandlerContext ctx) {
                --this.state;
            }

            void assertSkipped() {
                Assertions.assertEquals((int)0, (int)this.state);
                Error error = this.errorRef;
                if (error != null) {
                    throw error;
                }
            }
        }
        SkipHandler skipHandler = new SkipHandler();
        final class InboundCalledHandler
        implements ChannelHandler {
            private static final int MASK_CHANNEL_REGISTER = 1;
            private static final int MASK_CHANNEL_UNREGISTER = 2;
            private static final int MASK_CHANNEL_ACTIVE = 4;
            private static final int MASK_CHANNEL_INACTIVE = 8;
            private static final int MASK_CHANNEL_READ = 16;
            private static final int MASK_CHANNEL_READ_COMPLETE = 32;
            private static final int MASK_USER_EVENT_TRIGGERED = 64;
            private static final int MASK_CHANNEL_WRITABILITY_CHANGED = 128;
            private static final int MASK_EXCEPTION_CAUGHT = 256;
            private static final int MASK_ADDED = 512;
            private static final int MASK_REMOVED = 1024;
            private int executionMask;

            InboundCalledHandler() {
            }

            public void handlerAdded(ChannelHandlerContext ctx) {
                this.executionMask |= 0x200;
            }

            public void handlerRemoved(ChannelHandlerContext ctx) {
                this.executionMask |= 0x400;
            }

            public void channelRegistered(ChannelHandlerContext ctx) {
                this.executionMask |= 1;
            }

            public void channelUnregistered(ChannelHandlerContext ctx) {
                this.executionMask |= 2;
            }

            public void channelActive(ChannelHandlerContext ctx) {
                this.executionMask |= 4;
            }

            public void channelInactive(ChannelHandlerContext ctx) {
                this.executionMask |= 8;
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                this.executionMask |= 0x10;
            }

            public void channelReadComplete(ChannelHandlerContext ctx) {
                this.executionMask |= 0x20;
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                this.executionMask |= 0x40;
            }

            public void channelWritabilityChanged(ChannelHandlerContext ctx) {
                this.executionMask |= 0x80;
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                this.executionMask |= 0x100;
            }

            void assertCalled() {
                this.assertCalled("handlerAdded", 512);
                this.assertCalled("handlerRemoved", 1024);
                this.assertCalled("channelRegistered", 1);
                this.assertCalled("channelUnregistered", 2);
                this.assertCalled("channelActive", 4);
                this.assertCalled("channelInactive", 8);
                this.assertCalled("channelRead", 16);
                this.assertCalled("channelReadComplete", 32);
                this.assertCalled("userEventTriggered", 64);
                this.assertCalled("channelWritabilityChanged", 128);
                this.assertCalled("exceptionCaught", 256);
            }

            private void assertCalled(String methodName, int mask) {
                Assertions.assertTrue(((this.executionMask & mask) != 0 ? 1 : 0) != 0, (String)(methodName + " was not called"));
            }
        }
        InboundCalledHandler inboundCalledHandler = new InboundCalledHandler();
        pipeline.addLast(new ChannelHandler[]{outboundCalledHandler, skipHandler, inboundCalledHandler});
        pipeline.fireChannelRegistered();
        pipeline.fireChannelUnregistered();
        pipeline.fireChannelActive();
        pipeline.fireChannelInactive();
        pipeline.fireChannelRead((Object)"");
        pipeline.fireChannelReadComplete();
        pipeline.fireChannelWritabilityChanged();
        pipeline.fireUserEventTriggered((Object)"");
        pipeline.fireExceptionCaught((Throwable)new Exception());
        pipeline.register().syncUninterruptibly();
        pipeline.deregister().syncUninterruptibly();
        pipeline.bind(new SocketAddress(){}).syncUninterruptibly();
        pipeline.connect(new SocketAddress(){}).syncUninterruptibly();
        pipeline.disconnect().syncUninterruptibly();
        pipeline.close().syncUninterruptibly();
        pipeline.write((Object)"");
        pipeline.flush();
        pipeline.read();
        pipeline.remove((ChannelHandler)outboundCalledHandler);
        pipeline.remove((ChannelHandler)inboundCalledHandler);
        pipeline.remove((ChannelHandler)skipHandler);
        Assertions.assertFalse((boolean)channel.finish());
        outboundCalledHandler.assertCalled();
        inboundCalledHandler.assertCalled();
        skipHandler.assertSkipped();
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void handlerAddedStateUpdatedBeforeHandlerAddedDoneForceEventLoop() throws InterruptedException {
        DefaultChannelPipelineTest.handlerAddedStateUpdatedBeforeHandlerAddedDone(true);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void handlerAddedStateUpdatedBeforeHandlerAddedDoneOnCallingThread() throws InterruptedException {
        DefaultChannelPipelineTest.handlerAddedStateUpdatedBeforeHandlerAddedDone(false);
    }

    private static void handlerAddedStateUpdatedBeforeHandlerAddedDone(boolean executeInEventLoop) throws InterruptedException {
        ChannelPipeline pipeline = DefaultChannelPipelineTest.newLocalChannel().pipeline();
        final Object userEvent = new Object();
        final Object writeObject = new Object();
        final CountDownLatch doneLatch = new CountDownLatch(1);
        Runnable r = () -> {
            pipeline.addLast(new ChannelHandler[]{new ChannelHandler(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                    if (evt == userEvent) {
                        ctx.write(writeObject);
                    }
                    ctx.fireUserEventTriggered(evt);
                }
            }});
            pipeline.addFirst(new ChannelHandler[]{new ChannelHandler(){

                public void handlerAdded(ChannelHandlerContext ctx) {
                    ctx.fireUserEventTriggered(userEvent);
                }

                public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
                    if (msg == writeObject) {
                        doneLatch.countDown();
                    }
                    return ctx.write(msg);
                }
            }});
        };
        if (executeInEventLoop) {
            pipeline.channel().executor().execute(r);
        } else {
            r.run();
        }
        doneLatch.await();
    }

    private static int next(DefaultChannelHandlerContext ctx) {
        DefaultChannelHandlerContext next = ctx.next;
        if (next == null) {
            return Integer.MAX_VALUE;
        }
        return DefaultChannelPipelineTest.toInt(next.name());
    }

    private static int toInt(String name) {
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static void verifyContextNumber(ChannelPipeline pipeline, int expectedNumber) {
        Assertions.assertEquals((int)expectedNumber, (int)pipeline.names().size());
        Assertions.assertEquals((int)expectedNumber, (int)pipeline.toMap().size());
        pipeline.executor().submit(() -> {
            DefaultChannelHandlerContext ctx = (DefaultChannelHandlerContext)pipeline.firstContext();
            int handlerNumber = 0;
            if (ctx != null) {
                while (true) {
                    ++handlerNumber;
                    if (ctx == pipeline.lastContext()) break;
                    ctx = ctx.next;
                }
            }
            Assertions.assertEquals((int)expectedNumber, (int)handlerNumber);
        }).syncUninterruptibly();
    }

    private static ChannelHandler[] newHandlers(int num) {
        assert (num > 0);
        ChannelHandler[] handlers = new ChannelHandler[num];
        for (int i = 0; i < num; ++i) {
            handlers[i] = DefaultChannelPipelineTest.newHandler();
        }
        return handlers;
    }

    private static ChannelHandler newHandler() {
        return new TestHandler(null);
    }

    private static ChannelHandler newHandler(CountDownLatch latch) {
        return new TestHandler(latch);
    }

    private static final class LifeCycleAwareTestHandler
    extends ChannelHandlerAdapter {
        private final String name;
        private boolean afterAdd;
        private boolean afterRemove;

        private LifeCycleAwareTestHandler(String name) {
            this.name = name;
        }

        public void validate(boolean afterAdd, boolean afterRemove) {
            Assertions.assertEquals((Object)afterAdd, (Object)this.afterAdd, (String)this.name);
            Assertions.assertEquals((Object)afterRemove, (Object)this.afterRemove, (String)this.name);
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            this.validate(false, false);
            this.afterAdd = true;
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
            this.validate(true, false);
            this.afterRemove = true;
        }
    }

    private static class BufferedTestHandler
    implements ChannelHandler {
        final Queue<Object> inboundBuffer = new ArrayDeque<Object>();
        final Queue<Object> outboundBuffer = new ArrayDeque<Object>();

        private BufferedTestHandler() {
        }

        public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
            this.outboundBuffer.add(msg);
            return ctx.newSucceededFuture();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.inboundBuffer.add(msg);
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            if (!this.inboundBuffer.isEmpty()) {
                for (Object e : this.inboundBuffer) {
                    ctx.fireChannelRead(e);
                }
                ctx.fireChannelReadComplete();
            }
            if (!this.outboundBuffer.isEmpty()) {
                for (Object e : this.outboundBuffer) {
                    ctx.write(e);
                }
                ctx.flush();
            }
        }
    }

    @ChannelHandler.Sharable
    private static class TestHandler
    implements ChannelHandler {
        private final CountDownLatch latch;

        TestHandler(CountDownLatch latch) {
            this.latch = latch;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }

    private static final class CheckEventExecutorHandler
    extends ChannelHandlerAdapter {
        final EventExecutor executor;
        final Future<Void> addedFuture;
        final Future<Void> removedFuture;
        private final Promise<Void> addedPromise;
        private final Promise<Void> removedPromise;

        CheckEventExecutorHandler(EventExecutor executor) {
            this.executor = executor;
            this.addedPromise = executor.newPromise();
            this.addedFuture = this.addedPromise.asFuture();
            this.removedPromise = executor.newPromise();
            this.removedFuture = this.removedPromise.asFuture();
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.assertExecutor(ctx, this.addedPromise);
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            this.assertExecutor(ctx, this.removedPromise);
        }

        private void assertExecutor(ChannelHandlerContext ctx, Promise<Void> promise) {
            boolean same;
            try {
                same = this.executor == ctx.executor();
            }
            catch (Throwable cause) {
                promise.setFailure(cause);
                return;
            }
            if (same) {
                promise.setSuccess(null);
            } else {
                promise.setFailure((Throwable)((Object)new AssertionError((Object)"EventExecutor not the same")));
            }
        }
    }

    private static final class CallbackCheckHandler
    extends ChannelHandlerAdapter {
        private final Promise<Boolean> addedHandlerPromise = ImmediateEventExecutor.INSTANCE.newPromise();
        private final Promise<Boolean> removedHandlerPromise = ImmediateEventExecutor.INSTANCE.newPromise();
        final Future<Boolean> addedHandler = this.addedHandlerPromise.asFuture();
        final Future<Boolean> removedHandler = this.removedHandlerPromise.asFuture();
        final AtomicReference<Throwable> error = new AtomicReference();

        private CallbackCheckHandler() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            if (!this.addedHandlerPromise.trySuccess((Object)true)) {
                this.error.set((Throwable)((Object)new AssertionError((Object)("handlerAdded(...) called multiple times: " + ctx.name()))));
            } else if (this.removedHandler.isDone() && this.removedHandler.getNow() == Boolean.TRUE) {
                this.error.set((Throwable)((Object)new AssertionError((Object)("handlerRemoved(...) called before handlerAdded(...): " + ctx.name()))));
            }
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            if (!this.removedHandlerPromise.trySuccess((Object)true)) {
                this.error.set((Throwable)((Object)new AssertionError((Object)("handlerRemoved(...) called multiple times: " + ctx.name()))));
            } else if (this.addedHandler.isDone() && this.addedHandler.getNow() == Boolean.FALSE) {
                this.error.set((Throwable)((Object)new AssertionError((Object)("handlerRemoved(...) called before handlerAdded(...): " + ctx.name()))));
            }
        }
    }

    private static final class TestTask
    implements Runnable {
        private final ChannelPipeline pipeline;
        private final CountDownLatch latch;

        TestTask(ChannelPipeline pipeline, CountDownLatch latch) {
            this.pipeline = pipeline;
            this.latch = latch;
        }

        @Override
        public void run() {
            this.pipeline.addLast(new ChannelHandler[]{new ChannelHandler(){}});
            this.latch.countDown();
        }
    }

    private static final class StringInboundHandler
    implements ChannelHandler {
        boolean called;

        private StringInboundHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.called = true;
            if (!(msg instanceof String)) {
                ctx.fireChannelRead(msg);
            }
        }
    }
}

