/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.DefaultMaxMessagesRecvBufferAllocator;
import io.netty5.channel.RecvBufferAllocator;
import io.netty5.channel.embedded.EmbeddedChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultMaxMessagesRecvBufferAllocatorTest {
    private DefaultMaxMessagesRecvBufferAllocator newAllocator(boolean ignoreReadBytes) {
        return new DefaultMaxMessagesRecvBufferAllocator(2, ignoreReadBytes){

            public RecvBufferAllocator.Handle newHandle() {
                return new DefaultMaxMessagesRecvBufferAllocator.MaxMessageHandle(){

                    public int guess() {
                        return 0;
                    }
                };
            }
        };
    }

    @Test
    public void testRespectReadBytes() {
        DefaultMaxMessagesRecvBufferAllocator allocator = this.newAllocator(false);
        RecvBufferAllocator.Handle handle = allocator.newHandle();
        EmbeddedChannel channel = new EmbeddedChannel();
        handle.reset(channel.config());
        handle.incMessagesRead(1);
        Assertions.assertFalse((boolean)handle.continueReading());
        handle.reset(channel.config());
        handle.incMessagesRead(1);
        handle.attemptedBytesRead(1);
        handle.lastBytesRead(1);
        Assertions.assertTrue((boolean)handle.continueReading());
        channel.finish();
    }

    @Test
    public void testIgnoreReadBytes() {
        DefaultMaxMessagesRecvBufferAllocator allocator = this.newAllocator(true);
        RecvBufferAllocator.Handle handle = allocator.newHandle();
        EmbeddedChannel channel = new EmbeddedChannel();
        handle.reset(channel.config());
        handle.incMessagesRead(1);
        Assertions.assertTrue((boolean)handle.continueReading());
        handle.incMessagesRead(1);
        Assertions.assertFalse((boolean)handle.continueReading());
        handle.reset(channel.config());
        handle.attemptedBytesRead(0);
        handle.lastBytesRead(0);
        Assertions.assertTrue((boolean)handle.continueReading());
        channel.finish();
    }
}

