/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.EnumSet;

final class LoggingHandler
implements ChannelHandler {
    private StringBuilder log = new StringBuilder();
    private final EnumSet<Event> interest = EnumSet.allOf(Event.class);

    LoggingHandler() {
    }

    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        this.log(Event.WRITE);
        return ctx.write(msg);
    }

    public void flush(ChannelHandlerContext ctx) {
        this.log(Event.FLUSH);
        ctx.flush();
    }

    public Future<Void> bind(ChannelHandlerContext ctx, SocketAddress localAddress) {
        this.log(Event.BIND, "localAddress=" + localAddress);
        return ctx.bind(localAddress);
    }

    public Future<Void> connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress) {
        this.log(Event.CONNECT, "remoteAddress=" + remoteAddress + " localAddress=" + localAddress);
        return ctx.connect(remoteAddress, localAddress);
    }

    public Future<Void> disconnect(ChannelHandlerContext ctx) {
        this.log(Event.DISCONNECT);
        return ctx.disconnect();
    }

    public Future<Void> close(ChannelHandlerContext ctx) {
        this.log(Event.CLOSE);
        return ctx.close();
    }

    public Future<Void> register(ChannelHandlerContext ctx) {
        this.log(Event.REGISTER);
        return ctx.register();
    }

    public Future<Void> deregister(ChannelHandlerContext ctx) {
        this.log(Event.DEREGISTER);
        return ctx.deregister();
    }

    public void read(ChannelHandlerContext ctx) {
        this.log(Event.READ);
        ctx.read();
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.WRITABILITY, "writable=" + ctx.channel().isWritable());
        ctx.fireChannelWritabilityChanged();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.HANDLER_ADDED);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.HANDLER_REMOVED);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.log(Event.EXCEPTION, cause.toString());
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.REGISTERED);
        ctx.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.UNREGISTERED);
        ctx.fireChannelUnregistered();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.ACTIVE);
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.INACTIVE);
        ctx.fireChannelInactive();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.log(Event.READ);
        ctx.fireChannelRead(msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.READ_COMPLETE);
        ctx.fireChannelReadComplete();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.log(Event.USER, evt.toString());
        ctx.fireUserEventTriggered(evt);
    }

    String getLog() {
        return this.log.toString();
    }

    void clear() {
        this.log = new StringBuilder();
    }

    void setInterest(Event ... events) {
        this.interest.clear();
        Collections.addAll(this.interest, events);
    }

    private void log(Event e) {
        this.log(e, null);
    }

    private void log(Event e, String msg) {
        if (this.interest.contains((Object)e)) {
            this.log.append((Object)e);
            if (msg != null) {
                this.log.append(": ").append(msg);
            }
            this.log.append('\n');
        }
    }

    static enum Event {
        WRITE,
        FLUSH,
        BIND,
        CONNECT,
        DISCONNECT,
        CLOSE,
        REGISTER,
        DEREGISTER,
        READ,
        WRITABILITY,
        HANDLER_ADDED,
        HANDLER_REMOVED,
        EXCEPTION,
        READ_COMPLETE,
        REGISTERED,
        UNREGISTERED,
        ACTIVE,
        INACTIVE,
        USER;

    }
}

