/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.PendingWriteQueue;
import io.netty5.channel.embedded.EmbeddedChannel;
import io.netty5.util.CharsetUtil;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class PendingWriteQueueTest {
    @Test
    public void testRemoveAndWrite() {
        PendingWriteQueueTest.assertWrite(new TestHandler(){

            public void flush(ChannelHandlerContext ctx) {
                Assertions.assertFalse((boolean)ctx.channel().isWritable(), (String)"Should not be writable anymore");
                Future future = this.queue.removeAndWrite();
                future.addListener(future1 -> PendingWriteQueueTest.assertQueueEmpty(this.queue));
                super.flush(ctx);
            }
        }, 1);
    }

    @Test
    public void testRemoveAndWriteAll() {
        PendingWriteQueueTest.assertWrite(new TestHandler(){

            public void flush(ChannelHandlerContext ctx) {
                Assertions.assertFalse((boolean)ctx.channel().isWritable(), (String)"Should not be writable anymore");
                Future future = this.queue.removeAndWriteAll();
                future.addListener(future1 -> PendingWriteQueueTest.assertQueueEmpty(this.queue));
                super.flush(ctx);
            }
        }, 3);
    }

    @Test
    public void testRemoveAndFail() {
        PendingWriteQueueTest.assertWriteFails(new TestHandler(){

            public void flush(ChannelHandlerContext ctx) {
                this.queue.removeAndFail((Throwable)new TestException());
                super.flush(ctx);
            }
        }, 1);
    }

    @Test
    public void testRemoveAndFailAll() {
        PendingWriteQueueTest.assertWriteFails(new TestHandler(){

            public void flush(ChannelHandlerContext ctx) {
                this.queue.removeAndFailAll((Throwable)new TestException());
                super.flush(ctx);
            }
        }, 3);
    }

    @Test
    public void shouldFireChannelWritabilityChangedAfterRemoval() {
        final AtomicReference queueRef = new AtomicReference();
        ByteBuf msg = Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                queueRef.set(new PendingWriteQueue(ctx));
            }

            public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
                PendingWriteQueue queue = (PendingWriteQueue)queueRef.get();
                ByteBuf msg = (ByteBuf)queue.current();
                if (msg == null) {
                    return;
                }
                MatcherAssert.assertThat((Object)msg.refCnt(), (Matcher)Matchers.is((Object)1));
                queue.remove();
                MatcherAssert.assertThat((Object)msg.refCnt(), (Matcher)Matchers.is((Object)0));
            }
        }});
        channel.config().setWriteBufferLowWaterMark(1);
        channel.config().setWriteBufferHighWaterMark(3);
        PendingWriteQueue queue = (PendingWriteQueue)queueRef.get();
        channel.executor().execute(() -> queue.add((Object)msg, channel.newPromise()));
        channel.finish();
        MatcherAssert.assertThat((Object)msg.refCnt(), (Matcher)Matchers.is((Object)0));
    }

    private static void assertWrite(ChannelHandler handler, int count) {
        int i;
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)"Test", (Charset)CharsetUtil.US_ASCII);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{handler});
        channel.config().setWriteBufferLowWaterMark(1);
        channel.config().setWriteBufferHighWaterMark(3);
        Object[] buffers = new ByteBuf[count];
        for (i = 0; i < buffers.length; ++i) {
            buffers[i] = buffer.retainedDuplicate();
        }
        Assertions.assertTrue((boolean)channel.writeOutbound(buffers));
        Assertions.assertTrue((boolean)channel.finish());
        channel.closeFuture().syncUninterruptibly();
        for (i = 0; i < buffers.length; ++i) {
            PendingWriteQueueTest.assertBuffer(channel, buffer);
        }
        buffer.release();
        Assertions.assertNull((Object)channel.readOutbound());
    }

    private static void assertBuffer(EmbeddedChannel channel, ByteBuf buffer) {
        ByteBuf written = (ByteBuf)channel.readOutbound();
        Assertions.assertEquals((Object)buffer, (Object)written);
        written.release();
    }

    private static void assertQueueEmpty(PendingWriteQueue queue) {
        Assertions.assertTrue((boolean)queue.isEmpty());
        Assertions.assertEquals((int)0, (int)queue.size());
        Assertions.assertEquals((long)0L, (long)queue.bytes());
        Assertions.assertNull((Object)queue.current());
        Assertions.assertNull((Object)queue.removeAndWrite());
        Assertions.assertNull((Object)queue.removeAndWriteAll());
    }

    private static void assertWriteFails(ChannelHandler handler, int count) {
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)"Test", (Charset)CharsetUtil.US_ASCII);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{handler});
        Object[] buffers = new ByteBuf[count];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = buffer.retainedDuplicate();
        }
        try {
            Assertions.assertFalse((boolean)channel.writeOutbound(buffers));
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof TestException));
        }
        Assertions.assertFalse((boolean)channel.finish());
        channel.closeFuture().syncUninterruptibly();
        buffer.release();
        Assertions.assertNull((Object)channel.readOutbound());
    }

    private static EmbeddedChannel newChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){}});
    }

    @Test
    public void testRemoveAndFailAllReentrantFailAll() {
        EmbeddedChannel channel = PendingWriteQueueTest.newChannel();
        PendingWriteQueue queue = new PendingWriteQueue(channel.pipeline().firstContext());
        Promise promise = channel.newPromise();
        promise.asFuture().addListener(future -> queue.removeAndFailAll((Throwable)new IllegalStateException()));
        Promise promise2 = channel.newPromise();
        channel.executor().execute(() -> {
            queue.add((Object)1L, promise);
            queue.add((Object)2L, promise2);
            queue.removeAndFailAll((Throwable)new Exception());
        });
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertFalse((boolean)promise.isSuccess());
        Assertions.assertTrue((boolean)promise2.isDone());
        Assertions.assertFalse((boolean)promise2.isSuccess());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testRemoveAndWriteAllReentrantWrite() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
                return ctx.writeAndFlush(msg);
            }
        }, new ChannelHandler(){}});
        PendingWriteQueue queue = new PendingWriteQueue(channel.pipeline().lastContext());
        Promise promise = channel.newPromise();
        Promise promise3 = channel.newPromise();
        promise.asFuture().addListener(future -> queue.add((Object)3L, promise3));
        Promise promise2 = channel.newPromise();
        channel.executor().execute(() -> {
            queue.add((Object)1L, promise);
            queue.add((Object)2L, promise2);
            queue.removeAndWriteAll();
        });
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertTrue((boolean)promise.isSuccess());
        Assertions.assertTrue((boolean)promise2.isDone());
        Assertions.assertTrue((boolean)promise2.isSuccess());
        Assertions.assertFalse((boolean)promise3.isDone());
        Assertions.assertFalse((boolean)promise3.isSuccess());
        channel.executor().execute(() -> ((PendingWriteQueue)queue).removeAndWriteAll());
        Assertions.assertTrue((boolean)promise3.isDone());
        Assertions.assertTrue((boolean)promise3.isSuccess());
        channel.runPendingTasks();
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertEquals((long)1L, (Long)((Long)channel.readOutbound()));
        Assertions.assertEquals((long)2L, (Long)((Long)channel.readOutbound()));
        Assertions.assertEquals((long)3L, (Long)((Long)channel.readOutbound()));
    }

    @Disabled(value="Need to verify and think about if the assumptions made by this test are valid at all.")
    @Test
    public void testRemoveAndFailAllReentrantWrite() {
        List failOrder = Collections.synchronizedList(new ArrayList());
        EmbeddedChannel channel = PendingWriteQueueTest.newChannel();
        PendingWriteQueue queue = new PendingWriteQueue(channel.pipeline().firstContext());
        Promise promise = channel.newPromise();
        Promise promise3 = channel.newPromise();
        promise3.asFuture().addListener(future -> failOrder.add(3));
        promise.asFuture().addListener(future -> {
            failOrder.add(1);
            queue.add((Object)3L, promise3);
        });
        Promise promise2 = channel.newPromise();
        promise2.asFuture().addListener(future -> failOrder.add(2));
        channel.executor().execute(() -> {
            queue.add((Object)1L, promise);
            queue.add((Object)2L, promise2);
            queue.removeAndFailAll((Throwable)new Exception());
        });
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertFalse((boolean)promise.isSuccess());
        Assertions.assertTrue((boolean)promise2.isDone());
        Assertions.assertFalse((boolean)promise2.isSuccess());
        Assertions.assertTrue((boolean)promise3.isDone());
        Assertions.assertFalse((boolean)promise3.isSuccess());
        Assertions.assertFalse((boolean)channel.finish());
        Assertions.assertEquals((int)1, (int)((Integer)failOrder.get(0)));
        Assertions.assertEquals((int)2, (int)((Integer)failOrder.get(1)));
        Assertions.assertEquals((int)3, (int)((Integer)failOrder.get(2)));
    }

    @Test
    public void testRemoveAndWriteAllReentrance() {
        EmbeddedChannel channel = PendingWriteQueueTest.newChannel();
        PendingWriteQueue queue = new PendingWriteQueue(channel.pipeline().firstContext());
        Promise promise = channel.newPromise();
        promise.asFuture().addListener(future -> queue.removeAndWriteAll());
        Promise promise2 = channel.newPromise();
        channel.executor().execute(() -> {
            queue.add((Object)1L, promise);
            queue.add((Object)2L, promise2);
            queue.removeAndWriteAll();
        });
        channel.flush();
        Assertions.assertTrue((boolean)promise.isSuccess());
        Assertions.assertTrue((boolean)promise2.isSuccess());
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertEquals((long)1L, (Long)((Long)channel.readOutbound()));
        Assertions.assertEquals((long)2L, (Long)((Long)channel.readOutbound()));
        Assertions.assertNull((Object)channel.readOutbound());
        Assertions.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testCloseChannelOnCreation() {
        EmbeddedChannel channel = PendingWriteQueueTest.newChannel();
        ChannelHandlerContext context = channel.pipeline().firstContext();
        channel.close().syncUninterruptibly();
        PendingWriteQueue queue = new PendingWriteQueue(context);
        IllegalStateException ex = new IllegalStateException();
        Promise promise = channel.newPromise();
        channel.executor().execute(() -> {
            queue.add((Object)1L, promise);
            queue.removeAndFailAll((Throwable)ex);
        });
        Assertions.assertSame((Object)ex, (Object)promise.cause());
    }

    private static final class TestException
    extends Exception {
        private static final long serialVersionUID = -9018570103039458401L;

        private TestException() {
        }
    }

    private static class TestHandler
    implements ChannelHandler {
        protected PendingWriteQueue queue;
        private int expectedSize;

        private TestHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.fireChannelActive();
            PendingWriteQueueTest.assertQueueEmpty(this.queue);
            Assertions.assertTrue((boolean)ctx.channel().isWritable(), (String)"Should be writable");
        }

        public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
            Promise promise = ctx.newPromise();
            this.queue.add(msg, promise);
            Assertions.assertFalse((boolean)this.queue.isEmpty());
            Assertions.assertEquals((int)(++this.expectedSize), (int)this.queue.size());
            Assertions.assertNotNull((Object)this.queue.current());
            return promise.asFuture();
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.queue = new PendingWriteQueue(ctx);
        }
    }
}

