/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.bootstrap.Bootstrap;
import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.channel.BaseChannelTest;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.LoggingHandler;
import io.netty5.channel.local.LocalAddress;
import io.netty5.util.concurrent.Future;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReentrantChannelTest
extends BaseChannelTest {
    @Test
    public void testWritabilityChangedByteBuf() throws Exception {
        LocalAddress addr = new LocalAddress("testWritabilityChangedByteBuf");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.WRITABILITY);
        Channel clientChannel = (Channel)cb.connect((SocketAddress)addr).get();
        clientChannel.config().setWriteBufferLowWaterMark(512);
        clientChannel.config().setWriteBufferHighWaterMark(1024);
        Future future = clientChannel.write((Object)ReentrantChannelTest.createTestBuf(2000));
        clientChannel.flush();
        future.sync();
        clientChannel.close().sync();
        this.assertLog("WRITABILITY: writable=false\nWRITE\nWRITABILITY: writable=false\nWRITABILITY: writable=false\nFLUSH\nWRITABILITY: writable=true\n", "WRITABILITY: writable=false\nWRITE\nWRITABILITY: writable=false\nFLUSH\nWRITABILITY: writable=true\nWRITABILITY: writable=true\n");
    }

    @Test
    public void testWritabilityChanged() throws Exception {
        LocalAddress addr = new LocalAddress("testWritabilityChanged");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.WRITABILITY);
        Channel clientChannel = (Channel)cb.connect((SocketAddress)addr).get();
        clientChannel.config().setWriteBufferLowWaterMark(512);
        clientChannel.config().setWriteBufferHighWaterMark(1024);
        Future future = clientChannel.write((Object)ReentrantChannelTest.createTestBuffer(2000));
        clientChannel.flush();
        future.sync();
        clientChannel.close().sync();
        this.assertLog("WRITABILITY: writable=false\nWRITE\nWRITABILITY: writable=false\nWRITABILITY: writable=false\nFLUSH\nWRITABILITY: writable=true\n", "WRITABILITY: writable=false\nWRITE\nWRITABILITY: writable=false\nFLUSH\nWRITABILITY: writable=true\nWRITABILITY: writable=true\n");
    }

    @Test
    public void testFlushInWritabilityChangedByteBuf() throws Exception {
        LocalAddress addr = new LocalAddress("testFlushInWritabilityChangedByteBuf");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.WRITABILITY);
        Channel clientChannel = (Channel)cb.connect((SocketAddress)addr).get();
        clientChannel.config().setWriteBufferLowWaterMark(512);
        clientChannel.config().setWriteBufferHighWaterMark(1024);
        clientChannel.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

            public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
                if (!ctx.channel().isWritable()) {
                    ctx.channel().flush();
                }
                ctx.fireChannelWritabilityChanged();
            }
        }});
        Assertions.assertTrue((boolean)clientChannel.isWritable());
        clientChannel.write((Object)ReentrantChannelTest.createTestBuf(2000)).sync();
        clientChannel.close().sync();
        this.assertLog("WRITABILITY: writable=false\nFLUSH\nWRITE\nWRITABILITY: writable=false\nWRITABILITY: writable=false\nFLUSH\nWRITABILITY: writable=true\n", "WRITABILITY: writable=false\nFLUSH\nWRITE\nWRITABILITY: writable=false\nFLUSH\nWRITABILITY: writable=true\nWRITABILITY: writable=true\n");
    }

    @Test
    public void testFlushInWritabilityChanged() throws Exception {
        LocalAddress addr = new LocalAddress("testFlushInWritabilityChanged");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.WRITABILITY);
        Channel clientChannel = (Channel)cb.connect((SocketAddress)addr).get();
        clientChannel.config().setWriteBufferLowWaterMark(512);
        clientChannel.config().setWriteBufferHighWaterMark(1024);
        clientChannel.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

            public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
                if (!ctx.channel().isWritable()) {
                    ctx.channel().flush();
                }
                ctx.fireChannelWritabilityChanged();
            }
        }});
        Assertions.assertTrue((boolean)clientChannel.isWritable());
        clientChannel.write((Object)ReentrantChannelTest.createTestBuffer(2000)).sync();
        clientChannel.close().sync();
        this.assertLog("WRITABILITY: writable=false\nFLUSH\nWRITE\nWRITABILITY: writable=false\nWRITABILITY: writable=false\nFLUSH\nWRITABILITY: writable=true\n", "WRITABILITY: writable=false\nFLUSH\nWRITE\nWRITABILITY: writable=false\nFLUSH\nWRITABILITY: writable=true\nWRITABILITY: writable=true\n");
    }

    @Test
    public void testWriteFlushPingPongByteBuf() throws Exception {
        LocalAddress addr = new LocalAddress("testWriteFlushPingPongByteBuf");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.CLOSE, LoggingHandler.Event.EXCEPTION);
        Channel clientChannel = (Channel)cb.connect((SocketAddress)addr).get();
        clientChannel.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){
            int writeCount;
            int flushCount;

            public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
                if (this.writeCount < 5) {
                    ++this.writeCount;
                    ctx.channel().flush();
                }
                return ctx.write(msg);
            }

            public void flush(ChannelHandlerContext ctx) {
                if (this.flushCount < 5) {
                    ++this.flushCount;
                    ctx.channel().write((Object)BaseChannelTest.createTestBuf(2000));
                }
                ctx.flush();
            }
        }});
        clientChannel.writeAndFlush((Object)ReentrantChannelTest.createTestBuf(2000));
        clientChannel.close().sync();
        this.assertLog("WRITE\nFLUSH\nWRITE\nFLUSH\nWRITE\nFLUSH\nWRITE\nFLUSH\nWRITE\nFLUSH\nWRITE\nFLUSH\nCLOSE\n", new String[0]);
    }

    @Test
    public void testWriteFlushPingPong() throws Exception {
        LocalAddress addr = new LocalAddress("testWriteFlushPingPong");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.CLOSE, LoggingHandler.Event.EXCEPTION);
        Channel clientChannel = (Channel)cb.connect((SocketAddress)addr).get();
        clientChannel.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){
            int writeCount;
            int flushCount;

            public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
                if (this.writeCount < 5) {
                    ++this.writeCount;
                    ctx.channel().flush();
                }
                return ctx.write(msg);
            }

            public void flush(ChannelHandlerContext ctx) {
                if (this.flushCount < 5) {
                    ++this.flushCount;
                    ctx.channel().write((Object)BaseChannelTest.createTestBuffer(2000));
                }
                ctx.flush();
            }
        }});
        clientChannel.writeAndFlush((Object)ReentrantChannelTest.createTestBuffer(2000));
        clientChannel.close().sync();
        this.assertLog("WRITE\nFLUSH\nWRITE\nFLUSH\nWRITE\nFLUSH\nWRITE\nFLUSH\nWRITE\nFLUSH\nWRITE\nFLUSH\nCLOSE\n", new String[0]);
    }

    @Test
    public void testCloseInFlushByteBuf() throws Exception {
        LocalAddress addr = new LocalAddress("testCloseInFlush");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.CLOSE, LoggingHandler.Event.EXCEPTION);
        Channel clientChannel = (Channel)cb.connect((SocketAddress)addr).get();
        clientChannel.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

            public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
                Future f = ctx.write(msg).addListener((Object)ctx, ChannelFutureListeners.CLOSE);
                ctx.channel().flush();
                return f;
            }
        }});
        clientChannel.write((Object)ReentrantChannelTest.createTestBuf(2000)).sync();
        clientChannel.closeFuture().sync();
        this.assertLog("WRITE\nFLUSH\nCLOSE\n", new String[0]);
    }

    @Test
    public void testCloseInFlush() throws Exception {
        LocalAddress addr = new LocalAddress("testCloseInFlushByteBuf");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.CLOSE, LoggingHandler.Event.EXCEPTION);
        Channel clientChannel = (Channel)cb.connect((SocketAddress)addr).get();
        clientChannel.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

            public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
                Future f = ctx.write(msg).addListener((Object)ctx, ChannelFutureListeners.CLOSE);
                ctx.channel().flush();
                return f;
            }
        }});
        clientChannel.write((Object)ReentrantChannelTest.createTestBuffer(2000)).sync();
        clientChannel.closeFuture().sync();
        this.assertLog("WRITE\nFLUSH\nCLOSE\n", new String[0]);
    }

    @Test
    public void testFlushFailureByteBuf() throws Exception {
        LocalAddress addr = new LocalAddress("testFlushFailureByteBuf");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.CLOSE, LoggingHandler.Event.EXCEPTION);
        Channel clientChannel = (Channel)cb.connect((SocketAddress)addr).get();
        clientChannel.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

            public void flush(ChannelHandlerContext ctx) {
                throw new IllegalStateException("intentional failure");
            }
        }, new ChannelHandler(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                ctx.close();
            }
        }});
        try {
            clientChannel.writeAndFlush((Object)ReentrantChannelTest.createTestBuf(2000)).sync();
            Assertions.fail();
        }
        catch (Throwable cce) {
            MatcherAssert.assertThat((Object)cce.getCause(), (Matcher)Matchers.instanceOf(ClosedChannelException.class));
        }
        clientChannel.closeFuture().sync();
        this.assertLog("WRITE\nCLOSE\n", new String[0]);
    }

    @Test
    public void testFlushFailure() throws Exception {
        LocalAddress addr = new LocalAddress("testFlushFailure");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.CLOSE, LoggingHandler.Event.EXCEPTION);
        Channel clientChannel = (Channel)cb.connect((SocketAddress)addr).get();
        clientChannel.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

            public void flush(ChannelHandlerContext ctx) {
                throw new IllegalStateException("intentional failure");
            }
        }, new ChannelHandler(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                ctx.close();
            }
        }});
        try {
            clientChannel.writeAndFlush((Object)ReentrantChannelTest.createTestBuffer(2000)).sync();
            Assertions.fail();
        }
        catch (Throwable cce) {
            MatcherAssert.assertThat((Object)cce.getCause(), (Matcher)Matchers.instanceOf(ClosedChannelException.class));
        }
        clientChannel.closeFuture().sync();
        this.assertLog("WRITE\nCLOSE\n", new String[0]);
    }
}

