/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.Appender;
import io.netty5.channel.Channel;
import io.netty5.channel.EventLoop;
import io.netty5.channel.local.LocalChannel;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.SingleThreadEventExecutor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.LoggerFactory;

public class SingleThreadEventLoopTest {
    private static final Runnable NOOP = () -> {};
    private SingleThreadEventLoopA loopA;
    private SingleThreadEventLoopB loopB;

    @BeforeEach
    public void newEventLoop() {
        this.loopA = new SingleThreadEventLoopA();
        this.loopB = new SingleThreadEventLoopB();
    }

    @AfterEach
    public void stopEventLoop() {
        if (!this.loopA.isShuttingDown()) {
            this.loopA.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        }
        if (!this.loopB.isShuttingDown()) {
            this.loopB.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        }
        while (!this.loopA.isTerminated()) {
            try {
                this.loopA.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {}
        }
        Assertions.assertEquals((int)1, (int)this.loopA.cleanedUp.get());
        while (!this.loopB.isTerminated()) {
            try {
                this.loopB.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Test
    public void shutdownBeforeStart() throws Exception {
        this.loopA.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS).await();
        SingleThreadEventLoopTest.assertRejection((EventExecutor)this.loopA);
    }

    @Test
    public void shutdownAfterStart() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.loopA.execute(latch::countDown);
        latch.await();
        this.loopA.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS).await();
        SingleThreadEventLoopTest.assertRejection((EventExecutor)this.loopA);
        Assertions.assertTrue((boolean)this.loopA.isShutdown());
        while (!this.loopA.isTerminated()) {
            this.loopA.awaitTermination(1L, TimeUnit.DAYS);
        }
    }

    private static void assertRejection(EventExecutor loop) {
        try {
            loop.execute(NOOP);
            Assertions.fail((String)"A task must be rejected after shutdown() is called.");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Test
    public void scheduleTaskA() throws Exception {
        SingleThreadEventLoopTest.testScheduleTask(this.loopA);
    }

    @Test
    public void scheduleTaskB() throws Exception {
        SingleThreadEventLoopTest.testScheduleTask(this.loopB);
    }

    private static void testScheduleTask(EventLoop loopA) throws InterruptedException, ExecutionException {
        long startTime = System.nanoTime();
        AtomicLong endTime = new AtomicLong();
        loopA.schedule(() -> endTime.set(System.nanoTime()), 500L, TimeUnit.MILLISECONDS).get();
        MatcherAssert.assertThat((Object)(endTime.get() - startTime), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toNanos(500L)))));
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void scheduleTaskAtFixedRateA() throws Exception {
        SingleThreadEventLoopTest.testScheduleTaskAtFixedRate(this.loopA);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void scheduleTaskAtFixedRateB() throws Exception {
        SingleThreadEventLoopTest.testScheduleTaskAtFixedRate(this.loopB);
    }

    private static void testScheduleTaskAtFixedRate(EventLoop loopA) throws InterruptedException {
        LinkedBlockingQueue timestamps = new LinkedBlockingQueue();
        int expectedTimeStamps = 5;
        CountDownLatch allTimeStampsLatch = new CountDownLatch(5);
        Future f = loopA.scheduleAtFixedRate(() -> {
            timestamps.add(System.nanoTime());
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            allTimeStampsLatch.countDown();
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        allTimeStampsLatch.await();
        Assertions.assertTrue((boolean)f.cancel());
        Thread.sleep(300L);
        Assertions.assertEquals((int)5, (int)timestamps.size());
        Long firstTimestamp = null;
        long cnt = 0L;
        for (Long t : timestamps) {
            if (firstTimestamp == null) {
                firstTimestamp = t;
                continue;
            }
            long timepoint = t - firstTimestamp;
            MatcherAssert.assertThat((Object)timepoint, (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toNanos(100L * cnt + 80L)))));
            MatcherAssert.assertThat((Object)timepoint, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toNanos(100L * (cnt + 1L) + 20L)))));
            ++cnt;
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void scheduleLaggyTaskAtFixedRateA() throws Exception {
        SingleThreadEventLoopTest.testScheduleLaggyTaskAtFixedRate(this.loopA);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void scheduleLaggyTaskAtFixedRateB() throws Exception {
        SingleThreadEventLoopTest.testScheduleLaggyTaskAtFixedRate(this.loopB);
    }

    private static void testScheduleLaggyTaskAtFixedRate(EventLoop loopA) throws InterruptedException {
        LinkedBlockingQueue timestamps = new LinkedBlockingQueue();
        int expectedTimeStamps = 5;
        CountDownLatch allTimeStampsLatch = new CountDownLatch(5);
        Future f = loopA.scheduleAtFixedRate(() -> {
            boolean empty = timestamps.isEmpty();
            timestamps.add(System.nanoTime());
            if (empty) {
                try {
                    Thread.sleep(401L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            allTimeStampsLatch.countDown();
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        allTimeStampsLatch.await();
        Assertions.assertTrue((boolean)f.cancel());
        Thread.sleep(300L);
        Assertions.assertEquals((int)5, (int)timestamps.size());
        int i = 0;
        Long previousTimestamp = null;
        for (Long t : timestamps) {
            if (previousTimestamp == null) {
                previousTimestamp = t;
                continue;
            }
            long diff = t - previousTimestamp;
            if (i == 0) {
                MatcherAssert.assertThat((Object)diff, (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toNanos(400L)))));
            } else {
                MatcherAssert.assertThat((Object)diff, (Matcher)Matchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toNanos(10L)))));
            }
            previousTimestamp = t;
            ++i;
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void scheduleTaskWithFixedDelayA() throws Exception {
        SingleThreadEventLoopTest.testScheduleTaskWithFixedDelay(this.loopA);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void scheduleTaskWithFixedDelayB() throws Exception {
        SingleThreadEventLoopTest.testScheduleTaskWithFixedDelay(this.loopB);
    }

    private static void testScheduleTaskWithFixedDelay(EventLoop loopA) throws InterruptedException {
        LinkedBlockingQueue timestamps = new LinkedBlockingQueue();
        int expectedTimeStamps = 3;
        CountDownLatch allTimeStampsLatch = new CountDownLatch(3);
        Future f = loopA.scheduleWithFixedDelay(() -> {
            timestamps.add(System.nanoTime());
            try {
                Thread.sleep(51L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            allTimeStampsLatch.countDown();
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        allTimeStampsLatch.await();
        Assertions.assertTrue((boolean)f.cancel());
        Thread.sleep(300L);
        Assertions.assertEquals((int)3, (int)timestamps.size());
        Long previousTimestamp = null;
        for (Long t : timestamps) {
            if (previousTimestamp == null) {
                previousTimestamp = t;
                continue;
            }
            MatcherAssert.assertThat((Object)(t - previousTimestamp), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toNanos(150L)))));
            previousTimestamp = t;
        }
    }

    @Test
    public void shutdownWithPendingTasks() throws Exception {
        int NUM_TASKS = 3;
        AtomicInteger ranTasks = new AtomicInteger();
        CountDownLatch latch = new CountDownLatch(1);
        Runnable task = () -> {
            ranTasks.incrementAndGet();
            while (latch.getCount() > 0L) {
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        for (int i = 0; i < 3; ++i) {
            this.loopA.execute(task);
        }
        while (ranTasks.get() == 0) {
            Thread.yield();
        }
        Assertions.assertEquals((int)1, (int)ranTasks.get());
        this.loopA.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        latch.countDown();
        while (!this.loopA.isTerminated()) {
            this.loopA.awaitTermination(1L, TimeUnit.DAYS);
        }
        Assertions.assertEquals((int)3, (int)ranTasks.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testRegistrationAfterShutdown() throws Exception {
        this.loopA.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS).await();
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        ArrayList<Appender> appenders = new ArrayList<Appender>();
        Iterator i = root.iteratorForAppenders();
        while (i.hasNext()) {
            Appender a = (Appender)i.next();
            appenders.add(a);
            root.detachAppender(a);
        }
        try {
            LocalChannel channel = new LocalChannel((EventLoop)this.loopA);
            Future f = channel.register();
            f.awaitUninterruptibly();
            Assertions.assertFalse((boolean)f.isSuccess());
            MatcherAssert.assertThat((Object)f.cause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(RejectedExecutionException.class)));
        }
        finally {
            for (Appender a : appenders) {
                root.addAppender(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testRegistrationAfterShutdown2() throws Exception {
        this.loopA.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS).await();
        CountDownLatch latch = new CountDownLatch(1);
        LocalChannel ch = new LocalChannel((EventLoop)this.loopA);
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        ArrayList<Appender> appenders = new ArrayList<Appender>();
        Iterator i = root.iteratorForAppenders();
        while (i.hasNext()) {
            Appender a = (Appender)i.next();
            appenders.add(a);
            root.detachAppender(a);
        }
        try {
            Future f = ch.register().addListener(future -> latch.countDown());
            f.awaitUninterruptibly();
            Assertions.assertFalse((boolean)f.isSuccess());
            MatcherAssert.assertThat((Object)f.cause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(RejectedExecutionException.class)));
            Assertions.assertFalse((boolean)latch.await(1L, TimeUnit.SECONDS));
        }
        finally {
            for (Appender a : appenders) {
                root.addAppender(a);
            }
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testGracefulShutdownQuietPeriod() throws Exception {
        this.loopA.shutdownGracefully(1L, Integer.MAX_VALUE, TimeUnit.SECONDS);
        for (int i = 0; i < 20; ++i) {
            Thread.sleep(100L);
            this.loopA.execute(NOOP);
        }
        long startTime = System.nanoTime();
        MatcherAssert.assertThat((Object)this.loopA.isShuttingDown(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.loopA.isShutdown(), (Matcher)Matchers.is((Object)false));
        while (!this.loopA.isTerminated()) {
            this.loopA.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        MatcherAssert.assertThat((Object)(System.nanoTime() - startTime), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.SECONDS.toNanos(1L)))));
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testGracefulShutdownTimeout() throws Exception {
        int i;
        this.loopA.shutdownGracefully(2L, 2L, TimeUnit.SECONDS);
        for (i = 0; i < 10; ++i) {
            Thread.sleep(100L);
            this.loopA.execute(NOOP);
        }
        try {
            for (i = 0; i < 20; ++i) {
                Thread.sleep(100L);
                this.loopA.execute(NOOP);
            }
            Assertions.fail((String)"shutdownGracefully() must reject a task after timeout.");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)this.loopA.isShuttingDown(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.loopA.isShutdown(), (Matcher)Matchers.is((Object)true));
    }

    private static class SingleThreadEventLoopB
    extends SingleThreadEventExecutor
    implements EventLoop {
        SingleThreadEventLoopB() {
            super(Executors.defaultThreadFactory());
        }

        public EventLoop next() {
            return (EventLoop)super.next();
        }

        protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
            return new ConcurrentLinkedQueue<Runnable>();
        }

        protected void run() {
            do {
                try {
                    Thread.sleep(TimeUnit.NANOSECONDS.toMillis(this.delayNanos(System.nanoTime())));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.runAllTasks(Integer.MAX_VALUE);
            } while (!this.confirmShutdown());
        }

        protected void wakeup(boolean inEventLoop) {
            this.interruptThread();
        }

        public EventLoop.Unsafe unsafe() {
            return new EventLoop.Unsafe(){

                public void register(Channel channel) {
                }

                public void deregister(Channel channel) {
                }
            };
        }
    }

    private static class SingleThreadEventLoopA
    extends SingleThreadEventExecutor
    implements EventLoop {
        final AtomicInteger cleanedUp = new AtomicInteger();

        SingleThreadEventLoopA() {
            super(Executors.defaultThreadFactory());
        }

        public EventLoop next() {
            return (EventLoop)super.next();
        }

        protected void run() {
            do {
                Runnable task;
                if ((task = this.takeTask()) == null) continue;
                task.run();
                this.updateLastExecutionTime();
            } while (!this.confirmShutdown());
        }

        protected void cleanup() {
            this.cleanedUp.incrementAndGet();
        }

        public EventLoop.Unsafe unsafe() {
            return null;
        }
    }
}

