/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.embedded;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty5.buffer.BufferInputStream;
import io.netty5.buffer.BufferOutputStream;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.channel.ChannelId;
import io.netty5.channel.embedded.EmbeddedChannelId;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EmbeddedChannelIdTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerializationByteBuf() throws Exception {
        ChannelId deserializedInstance;
        ChannelId normalInstance = EmbeddedChannelId.INSTANCE;
        ByteBuf buf = Unpooled.buffer();
        try (ObjectOutputStream outStream = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(buf));){
            outStream.writeObject(normalInstance);
        }
        try (ObjectInputStream inStream = new ObjectInputStream((InputStream)new ByteBufInputStream(buf, true));){
            deserializedInstance = (ChannelId)inStream.readObject();
        }
        Assertions.assertEquals((Object)normalInstance, (Object)deserializedInstance);
        Assertions.assertEquals((int)normalInstance.hashCode(), (int)deserializedInstance.hashCode());
        Assertions.assertEquals((int)0, (int)normalInstance.compareTo((Object)deserializedInstance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerialization() throws Exception {
        ChannelId deserializedInstance;
        ChannelId normalInstance = EmbeddedChannelId.INSTANCE;
        Buffer buf = BufferAllocator.onHeapUnpooled().allocate(1024);
        try (ObjectOutputStream outStream = new ObjectOutputStream((OutputStream)new BufferOutputStream(buf));){
            outStream.writeObject(normalInstance);
        }
        try (ObjectInputStream inStream = new ObjectInputStream((InputStream)new BufferInputStream(buf.send()));){
            deserializedInstance = (ChannelId)inStream.readObject();
        }
        Assertions.assertEquals((Object)normalInstance, (Object)deserializedInstance);
        Assertions.assertEquals((int)normalInstance.hashCode(), (int)deserializedInstance.hashCode());
        Assertions.assertEquals((int)0, (int)normalInstance.compareTo((Object)deserializedInstance));
    }
}

