/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.embedded;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelId;
import io.netty5.channel.ChannelInitializer;
import io.netty5.channel.ChannelOutboundInvoker;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.embedded.CustomChannelId;
import io.netty5.channel.embedded.EmbeddedChannel;
import io.netty5.channel.embedded.EmbeddedChannelId;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class EmbeddedChannelTest {
    @Test
    public void testParent() {
        EmbeddedChannel parent = new EmbeddedChannel();
        EmbeddedChannel channel = new EmbeddedChannel((Channel)parent, EmbeddedChannelId.INSTANCE, true, false, new ChannelHandler[0]);
        Assertions.assertSame((Object)parent, (Object)channel.parent());
        Assertions.assertNull((Object)parent.parent());
        Assertions.assertFalse((boolean)channel.finish());
        Assertions.assertFalse((boolean)parent.finish());
    }

    @Test
    public void testNotRegistered() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(false, false, new ChannelHandler[0]);
        Assertions.assertFalse((boolean)channel.isRegistered());
        channel.register();
        Assertions.assertTrue((boolean)channel.isRegistered());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testRegistered() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(true, false, new ChannelHandler[0]);
        Assertions.assertTrue((boolean)channel.isRegistered());
        try {
            channel.register();
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void promiseDoesNotInfiniteLoop() throws InterruptedException {
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.closeFuture().addListener((Object)channel, (c, f) -> c.close());
        channel.close().syncUninterruptibly();
    }

    @Test
    public void testConstructWithChannelInitializer() {
        final Integer first = 1;
        final Integer second = 2;
        final ChannelHandler handler = new ChannelHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ctx.fireChannelRead((Object)first);
                ctx.fireChannelRead((Object)second);
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{handler});
            }
        }});
        ChannelPipeline pipeline = channel.pipeline();
        Assertions.assertSame((Object)handler, (Object)pipeline.firstContext().handler());
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{3}));
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertSame((Object)first, (Object)channel.readInbound());
        Assertions.assertSame((Object)second, (Object)channel.readInbound());
        Assertions.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testScheduling() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){}});
        CountDownLatch latch = new CountDownLatch(2);
        Future future = ch.executor().schedule(latch::countDown, 1L, TimeUnit.SECONDS);
        future.addListener(future1 -> latch.countDown());
        long next = ch.runScheduledPendingTasks();
        Assertions.assertTrue((next > 0L ? 1 : 0) != 0);
        Thread.sleep(TimeUnit.NANOSECONDS.toMillis(next) + 50L);
        Assertions.assertEquals((long)-1L, (long)ch.runScheduledPendingTasks());
        latch.await();
    }

    @Test
    public void testScheduledCancelled() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){}});
        Future future = ch.executor().schedule(() -> {}, 1L, TimeUnit.DAYS);
        ch.finish();
        Assertions.assertTrue((boolean)future.isCancelled());
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testHandlerAddedExecutedInEventLoop() throws Throwable {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference error = new AtomicReference();
        ChannelHandler handler = new ChannelHandler(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                try {
                    Assertions.assertTrue((boolean)ctx.executor().inEventLoop());
                }
                catch (Throwable cause) {
                    error.set(cause);
                }
                finally {
                    latch.countDown();
                }
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{handler});
        Assertions.assertFalse((boolean)channel.finish());
        latch.await();
        Throwable cause = (Throwable)error.get();
        if (cause != null) {
            throw cause;
        }
    }

    @Test
    public void testConstructWithOutHandler() {
        EmbeddedChannel channel = new EmbeddedChannel();
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{1}));
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{2}));
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertSame((Object)1, (Object)channel.readInbound());
        Assertions.assertNull((Object)channel.readInbound());
        Assertions.assertSame((Object)2, (Object)channel.readOutbound());
        Assertions.assertNull((Object)channel.readOutbound());
    }

    @Test
    public void testConstructWithChannelId() {
        CustomChannelId channelId = new CustomChannelId(1);
        EmbeddedChannel channel = new EmbeddedChannel((ChannelId)channelId);
        Assertions.assertSame((Object)channelId, (Object)channel.id());
    }

    @Test
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void testFireChannelInactiveAndUnregisteredOnClose() throws InterruptedException {
        EmbeddedChannelTest.testFireChannelInactiveAndUnregistered(ChannelOutboundInvoker::close);
    }

    @Test
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void testFireChannelInactiveAndUnregisteredOnDisconnect() throws InterruptedException {
        EmbeddedChannelTest.testFireChannelInactiveAndUnregistered(ChannelOutboundInvoker::disconnect);
    }

    private static void testFireChannelInactiveAndUnregistered(Action action) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(3);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                latch.countDown();
                ctx.executor().execute(latch::countDown);
            }

            public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
                latch.countDown();
            }
        }});
        action.doRun((Channel)channel).syncUninterruptibly();
        latch.await();
    }

    @Test
    public void testHasDisconnect() {
        EventOutboundHandler handler = new EventOutboundHandler();
        EmbeddedChannel channel = new EmbeddedChannel(true, new ChannelHandler[]{handler});
        Assertions.assertTrue((boolean)channel.disconnect().isSuccess());
        Assertions.assertTrue((boolean)channel.close().isSuccess());
        Assertions.assertEquals((Integer)EventOutboundHandler.DISCONNECT, (Integer)handler.pollEvent());
        Assertions.assertEquals((Integer)EventOutboundHandler.CLOSE, (Integer)handler.pollEvent());
        Assertions.assertNull((Object)handler.pollEvent());
    }

    @Test
    public void testHasNoDisconnect() {
        EventOutboundHandler handler = new EventOutboundHandler();
        EmbeddedChannel channel = new EmbeddedChannel(false, new ChannelHandler[]{handler});
        Assertions.assertTrue((boolean)channel.disconnect().isSuccess());
        Assertions.assertTrue((boolean)channel.close().isSuccess());
        Assertions.assertEquals((Integer)EventOutboundHandler.CLOSE, (Integer)handler.pollEvent());
        Assertions.assertEquals((Integer)EventOutboundHandler.CLOSE, (Integer)handler.pollEvent());
        Assertions.assertNull((Object)handler.pollEvent());
    }

    @Test
    public void testHasNoDisconnectSkipDisconnect() {
        EmbeddedChannel channel = new EmbeddedChannel(false, new ChannelHandler[]{new ChannelHandler(){

            public Future<Void> close(ChannelHandlerContext ctx) {
                return ctx.newFailedFuture(new Throwable());
            }
        }});
        Assertions.assertFalse((boolean)channel.disconnect().isSuccess());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinishAndReleaseAll() {
        ByteBuf in = Unpooled.buffer();
        ByteBuf out = Unpooled.buffer();
        try {
            EmbeddedChannel channel = new EmbeddedChannel();
            Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{in}));
            Assertions.assertEquals((int)1, (int)in.refCnt());
            Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{out}));
            Assertions.assertEquals((int)1, (int)out.refCnt());
            Assertions.assertTrue((boolean)channel.finishAndReleaseAll());
            Assertions.assertEquals((int)0, (int)in.refCnt());
            Assertions.assertEquals((int)0, (int)out.refCnt());
            Assertions.assertNull((Object)channel.readInbound());
            Assertions.assertNull((Object)channel.readOutbound());
        }
        catch (Throwable throwable) {
            EmbeddedChannelTest.release(in, out);
            throw throwable;
        }
        EmbeddedChannelTest.release(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReleaseInbound() {
        ByteBuf in = Unpooled.buffer();
        ByteBuf out = Unpooled.buffer();
        try {
            EmbeddedChannel channel = new EmbeddedChannel();
            Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{in}));
            Assertions.assertEquals((int)1, (int)in.refCnt());
            Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{out}));
            Assertions.assertEquals((int)1, (int)out.refCnt());
            Assertions.assertTrue((boolean)channel.releaseInbound());
            Assertions.assertEquals((int)0, (int)in.refCnt());
            Assertions.assertEquals((int)1, (int)out.refCnt());
            Assertions.assertTrue((boolean)channel.finish());
            Assertions.assertNull((Object)channel.readInbound());
            ByteBuf buffer = (ByteBuf)channel.readOutbound();
            Assertions.assertSame((Object)out, (Object)buffer);
            buffer.release();
            Assertions.assertNull((Object)channel.readOutbound());
        }
        catch (Throwable throwable) {
            EmbeddedChannelTest.release(in, out);
            throw throwable;
        }
        EmbeddedChannelTest.release(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReleaseOutbound() {
        ByteBuf in = Unpooled.buffer();
        ByteBuf out = Unpooled.buffer();
        try {
            EmbeddedChannel channel = new EmbeddedChannel();
            Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{in}));
            Assertions.assertEquals((int)1, (int)in.refCnt());
            Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{out}));
            Assertions.assertEquals((int)1, (int)out.refCnt());
            Assertions.assertTrue((boolean)channel.releaseOutbound());
            Assertions.assertEquals((int)1, (int)in.refCnt());
            Assertions.assertEquals((int)0, (int)out.refCnt());
            Assertions.assertTrue((boolean)channel.finish());
            Assertions.assertNull((Object)channel.readOutbound());
            ByteBuf buffer = (ByteBuf)channel.readInbound();
            Assertions.assertSame((Object)in, (Object)buffer);
            buffer.release();
            Assertions.assertNull((Object)channel.readInbound());
        }
        catch (Throwable throwable) {
            EmbeddedChannelTest.release(in, out);
            throw throwable;
        }
        EmbeddedChannelTest.release(in, out);
    }

    @Test
    public void testWriteLater() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
                Promise promise = ctx.newPromise();
                ctx.executor().execute(() -> ctx.write(msg).cascadeTo(promise));
                return promise.asFuture();
            }
        }});
        Object msg = new Object();
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{msg}));
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertSame((Object)msg, (Object)channel.readOutbound());
        Assertions.assertNull((Object)channel.readOutbound());
    }

    @Test
    public void testWriteScheduled() throws InterruptedException {
        int delay = 500;
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
                Promise promise = ctx.newPromise();
                ctx.executor().schedule(() -> ctx.writeAndFlush(msg).cascadeTo(promise), 500L, TimeUnit.MILLISECONDS);
                return promise.asFuture();
            }
        }});
        Object msg = new Object();
        Assertions.assertFalse((boolean)channel.writeOutbound(new Object[]{msg}));
        Thread.sleep(1000L);
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertSame((Object)msg, (Object)channel.readOutbound());
        Assertions.assertNull((Object)channel.readOutbound());
    }

    @Test
    public void testFlushInbound() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                latch.countDown();
            }
        }});
        channel.flushInbound();
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Nobody called #channelReadComplete() in time.");
        }
    }

    @Test
    public void testWriteOneInbound() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger flushCount = new AtomicInteger(0);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ReferenceCountUtil.release((Object)msg);
                latch.countDown();
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                flushCount.incrementAndGet();
            }
        }});
        channel.writeOneInbound((Object)"Hello, Netty!");
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Nobody called #channelRead() in time.");
        }
        channel.close().syncUninterruptibly();
        Assertions.assertEquals((int)0, (int)flushCount.get());
    }

    @Test
    public void testFlushOutbound() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public void flush(ChannelHandlerContext ctx) {
                latch.countDown();
            }
        }});
        channel.flushOutbound();
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Nobody called #flush() in time.");
        }
    }

    @Test
    public void testWriteOneOutbound() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger flushCount = new AtomicInteger(0);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
                Future future = ctx.write(msg);
                latch.countDown();
                return future;
            }

            public void flush(ChannelHandlerContext ctx) {
                flushCount.incrementAndGet();
            }
        }});
        channel.writeOneOutbound((Object)"Hello, Netty!");
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Nobody called #write() in time.");
        }
        channel.close().syncUninterruptibly();
        Assertions.assertEquals((int)0, (int)flushCount.get());
    }

    @Test
    public void testEnsureOpen() throws InterruptedException {
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.close().syncUninterruptibly();
        try {
            channel.writeOutbound(new Object[]{"Hello, Netty!"});
            Assertions.fail((String)"This should have failed with a ClosedChannelException");
        }
        catch (Exception expected) {
            Assertions.assertTrue((boolean)(expected instanceof ClosedChannelException));
        }
        try {
            channel.writeInbound(new Object[]{"Hello, Netty!"});
            Assertions.fail((String)"This should have failed with a ClosedChannelException");
        }
        catch (Exception expected) {
            Assertions.assertTrue((boolean)(expected instanceof ClosedChannelException));
        }
    }

    @Test
    public void testHandleInboundMessage() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        EmbeddedChannel channel = new EmbeddedChannel(){

            protected void handleInboundMessage(Object msg) {
                latch.countDown();
            }
        };
        channel.writeOneInbound((Object)"Hello, Netty!");
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Nobody called #handleInboundMessage() in time.");
        }
    }

    @Test
    public void testHandleOutboundMessage() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        EmbeddedChannel channel = new EmbeddedChannel(){

            protected void handleOutboundMessage(Object msg) {
                latch.countDown();
            }
        };
        channel.writeOneOutbound((Object)"Hello, Netty!");
        if (latch.await(50L, TimeUnit.MILLISECONDS)) {
            Assertions.fail((String)"Somebody called unexpectedly #flush()");
        }
        channel.flushOutbound();
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Nobody called #handleOutboundMessage() in time.");
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelInactiveFired() throws InterruptedException {
        final AtomicBoolean inactive = new AtomicBoolean();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ctx.close();
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                inactive.set(true);
            }
        }});
        channel.pipeline().fireExceptionCaught((Throwable)new IllegalStateException());
        Assertions.assertTrue((boolean)inactive.get());
    }

    private static void release(ByteBuf ... buffers) {
        for (ByteBuf buffer : buffers) {
            if (buffer.refCnt() <= 0) continue;
            buffer.release();
        }
    }

    private static final class EventOutboundHandler
    implements ChannelHandler {
        static final Integer DISCONNECT = 0;
        static final Integer CLOSE = 1;
        private final Queue<Integer> queue = new ArrayDeque<Integer>();

        private EventOutboundHandler() {
        }

        public Future<Void> disconnect(ChannelHandlerContext ctx) {
            this.queue.add(DISCONNECT);
            return ctx.newSucceededFuture();
        }

        public Future<Void> close(ChannelHandlerContext ctx) {
            this.queue.add(CLOSE);
            return ctx.newSucceededFuture();
        }

        Integer pollEvent() {
            return this.queue.poll();
        }
    }

    private static interface Action {
        public Future<Void> doRun(Channel var1);
    }
}

