/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.group;

import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.group.ChannelGroup;
import io.netty5.channel.group.DefaultChannelGroup;
import io.netty5.channel.nio.NioHandler;
import io.netty5.channel.socket.nio.NioServerSocketChannel;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.GlobalEventExecutor;
import org.junit.jupiter.api.Test;

public class DefaultChannelGroupTest {
    @Test
    public void testNotThrowBlockingOperationException() throws Exception {
        MultithreadEventLoopGroup bossGroup = new MultithreadEventLoopGroup(NioHandler.newFactory());
        MultithreadEventLoopGroup workerGroup = new MultithreadEventLoopGroup(NioHandler.newFactory());
        DefaultChannelGroup allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        ServerBootstrap b = new ServerBootstrap();
        b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup);
        b.childHandler(new ChannelHandler((ChannelGroup)allChannels){
            final /* synthetic */ ChannelGroup val$allChannels;
            {
                this.val$allChannels = channelGroup;
            }

            public void channelActive(ChannelHandlerContext ctx) {
                this.val$allChannels.add((Object)ctx.channel());
            }
        });
        b.channel(NioServerSocketChannel.class);
        Future f = b.bind(0).syncUninterruptibly();
        if (f.isSuccess()) {
            allChannels.add((Object)((Channel)f.getNow()));
            allChannels.close().awaitUninterruptibly();
        }
        bossGroup.shutdownGracefully();
        workerGroup.shutdownGracefully();
        bossGroup.terminationFuture().sync();
        workerGroup.terminationFuture().sync();
    }
}

