/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.local;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty5.bootstrap.Bootstrap;
import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelInitializer;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.IoHandler;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.SimpleChannelInboundHandler;
import io.netty5.channel.SingleThreadEventLoop;
import io.netty5.channel.local.LocalAddress;
import io.netty5.channel.local.LocalChannel;
import io.netty5.channel.local.LocalChannelRegistry;
import io.netty5.channel.local.LocalHandler;
import io.netty5.channel.local.LocalServerChannel;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.concurrent.RejectedExecutionHandler;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class LocalChannelTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(LocalChannelTest.class);
    private static final LocalAddress TEST_ADDRESS = new LocalAddress("test.id");
    private static EventLoopGroup group1;
    private static EventLoopGroup group2;
    private static EventLoopGroup sharedGroup;

    @BeforeAll
    public static void beforeClass() {
        group1 = new MultithreadEventLoopGroup(2, LocalHandler.newFactory());
        group2 = new MultithreadEventLoopGroup(2, LocalHandler.newFactory());
        sharedGroup = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
    }

    @AfterAll
    public static void afterClass() throws InterruptedException {
        Future group1Future = group1.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        Future group2Future = group2.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        Future sharedGroupFuture = sharedGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        group1Future.await();
        group2Future.await();
        sharedGroupFuture.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalAddressReuse() throws Exception {
        for (int i = 0; i < 2; ++i) {
            Bootstrap cb = new Bootstrap();
            ServerBootstrap sb = new ServerBootstrap();
            ((Bootstrap)cb.group(group1)).channel(LocalChannel.class).handler((ChannelHandler)new TestHandler());
            sb.group(group2).channel(LocalServerChannel.class).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

                public void initChannel(LocalChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new TestHandler()});
                }
            });
            Channel sc = null;
            Channel cc = null;
            try {
                sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
                CountDownLatch latch = new CountDownLatch(1);
                Channel ccCpy = cc = (Channel)cb.connect(sc.localAddress()).get();
                cc.executor().execute(() -> {
                    ccCpy.pipeline().fireChannelRead((Object)"Hello, World");
                    latch.countDown();
                });
                Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
                LocalChannelTest.closeChannel(cc);
                LocalChannelTest.closeChannel(sc);
                sc.closeFuture().sync();
                Assertions.assertNull((Object)LocalChannelRegistry.get((SocketAddress)TEST_ADDRESS), (String)String.format("Expected null, got channel '%s' for local address '%s'", LocalChannelRegistry.get((SocketAddress)TEST_ADDRESS), TEST_ADDRESS));
            }
            catch (Throwable throwable) {
                LocalChannelTest.closeChannel(cc);
                LocalChannelTest.closeChannel(sc);
                throw throwable;
            }
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteFailsFastOnClosedChannel() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)cb.group(group1)).channel(LocalChannel.class).handler((ChannelHandler)new TestHandler());
        sb.group(group2).channel(LocalServerChannel.class).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new TestHandler()});
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            cc = (Channel)cb.connect(sc.localAddress()).get();
            cc.close().sync();
            try {
                cc.writeAndFlush(new Object()).sync();
                Assertions.fail((String)"must raise a ClosedChannelException");
            }
            catch (CompletionException cause) {
                Throwable e = cause.getCause();
                MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
                if (e.getStackTrace().length > 0) {
                    MatcherAssert.assertThat((Object)e.getStackTrace()[0].getClassName(), (Matcher)CoreMatchers.is((Object)(AbstractChannel.class.getName() + "$AbstractUnsafe")));
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerCloseChannelSameEventLoop() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ServerBootstrap sb = new ServerBootstrap().group(group2).channel(LocalServerChannel.class).childHandler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            protected void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
                ctx.close();
                latch.countDown();
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            Bootstrap b = (Bootstrap)((Bootstrap)new Bootstrap().group(group2)).channel(LocalChannel.class).handler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

                protected void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
                }
            });
            cc = (Channel)b.connect(sc.localAddress()).get();
            cc.writeAndFlush(new Object());
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void localChannelRaceCondition() throws Exception {
        final CountDownLatch closeLatch = new CountDownLatch(1);
        MultithreadEventLoopGroup clientGroup = new MultithreadEventLoopGroup(1, LocalHandler.newFactory()){

            protected EventLoop newChild(Executor executor, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler, IoHandler ioHandler, int maxTasksPerRun, Object ... args) {
                return new SingleThreadEventLoop(executor, ioHandler, maxPendingTasks, rejectedExecutionHandler){

                    protected void run() {
                        do {
                            this.runIo();
                            Runnable task = this.pollTask();
                            if (task == null) continue;
                            if (task.getClass().getEnclosingClass() == LocalChannel.class) {
                                try {
                                    closeLatch.await(1L, TimeUnit.SECONDS);
                                }
                                catch (InterruptedException e) {
                                    throw new Error(e);
                                }
                            }
                            task.run();
                            this.updateLastExecutionTime();
                        } while (!this.confirmShutdown());
                    }
                };
            }
        };
        Channel sc = null;
        Channel cc = null;
        try {
            ServerBootstrap sb = new ServerBootstrap();
            sc = (Channel)sb.group(group2).channel(LocalServerChannel.class).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.close();
                    closeLatch.countDown();
                }
            }).bind((SocketAddress)TEST_ADDRESS).get();
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)bootstrap.group((EventLoopGroup)clientGroup)).channel(LocalChannel.class).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                }
            });
            Future future = bootstrap.connect(sc.localAddress());
            Assertions.assertTrue((boolean)future.await(2000L), (String)"Connection should finish, not time out");
            cc = future.await().isSuccess() ? (Channel)future.get() : null;
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            clientGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).await();
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
        clientGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReRegister() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)cb.group(group1)).channel(LocalChannel.class).handler((ChannelHandler)new TestHandler());
        sb.group(group2).channel(LocalServerChannel.class).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new TestHandler()});
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            cc = (Channel)cb.connect(sc.localAddress()).get();
            cc.deregister().syncUninterruptibly();
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseInWritePromiseCompletePreservesOrderByteBuf() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(2);
        final ByteBuf data = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        try {
            ((Bootstrap)cb.group(group1)).channel(LocalChannel.class).handler((ChannelHandler)new TestHandler());
            sb.group(group2).channel(LocalServerChannel.class).childHandler(new ChannelHandler(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (msg.equals(data)) {
                        ReferenceCountUtil.safeRelease((Object)msg);
                        messageLatch.countDown();
                    } else {
                        ctx.fireChannelRead(msg);
                    }
                }

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    messageLatch.countDown();
                    ctx.fireChannelInactive();
                }
            });
            Channel sc = null;
            Channel cc = null;
            try {
                sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
                Channel ccCpy = cc = (Channel)cb.connect(sc.localAddress()).get();
                cc.pipeline().lastContext().executor().execute(() -> ccCpy.writeAndFlush((Object)data.retainedDuplicate()).addListener(future -> ccCpy.pipeline().lastContext().close()));
                Assertions.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
                Assertions.assertFalse((boolean)cc.isOpen());
            }
            catch (Throwable throwable) {
                LocalChannelTest.closeChannel(cc);
                LocalChannelTest.closeChannel(sc);
                throw throwable;
            }
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseInWritePromiseCompletePreservesOrder() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(2);
        final Buffer data = BufferAllocator.onHeapUnpooled().allocate(1024);
        ((Bootstrap)cb.group(group1)).channel(LocalChannel.class).handler((ChannelHandler)new TestHandler());
        sb.group(group2).channel(LocalServerChannel.class).childHandler(new ChannelHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg instanceof Buffer && msg.equals(data)) {
                    ((Buffer)msg).close();
                    messageLatch.countDown();
                } else {
                    ctx.fireChannelRead(msg);
                }
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                messageLatch.countDown();
                ctx.fireChannelInactive();
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            Channel ccCpy = cc = (Channel)cb.connect(sc.localAddress()).get();
            cc.pipeline().lastContext().executor().execute(() -> ccCpy.writeAndFlush((Object)data).addListener(future -> ccCpy.pipeline().lastContext().close()));
            Assertions.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)cc.isOpen());
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseAfterWriteInSameEventLoopPreservesOrderByteBuf() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(3);
        final ByteBuf data = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        try {
            ((Bootstrap)cb.group(sharedGroup)).channel(LocalChannel.class).handler(new ChannelHandler(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    ctx.writeAndFlush((Object)data.retainedDuplicate());
                }

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (data.equals(msg)) {
                        ReferenceCountUtil.safeRelease((Object)msg);
                        messageLatch.countDown();
                    } else {
                        ctx.fireChannelRead(msg);
                    }
                }
            });
            sb.group(sharedGroup).channel(LocalServerChannel.class).childHandler(new ChannelHandler(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (data.equals(msg)) {
                        messageLatch.countDown();
                        ctx.writeAndFlush((Object)data);
                        ctx.close();
                    } else {
                        ctx.fireChannelRead(msg);
                    }
                }

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    messageLatch.countDown();
                    ctx.fireChannelInactive();
                }
            });
            Channel sc = null;
            Channel cc = null;
            try {
                sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
                cc = (Channel)cb.connect(sc.localAddress()).get();
                Assertions.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
                Assertions.assertFalse((boolean)cc.isOpen());
            }
            catch (Throwable throwable) {
                LocalChannelTest.closeChannel(cc);
                LocalChannelTest.closeChannel(sc);
                throw throwable;
            }
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseAfterWriteInSameEventLoopPreservesOrder() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(3);
        final Buffer data = BufferAllocator.onHeapUnpooled().allocate(1024);
        ((Bootstrap)cb.group(sharedGroup)).channel(LocalChannel.class).handler(new ChannelHandler(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                ctx.writeAndFlush((Object)data);
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg instanceof Buffer && data.equals(msg)) {
                    ((Buffer)msg).close();
                    messageLatch.countDown();
                } else {
                    ctx.fireChannelRead(msg);
                }
            }
        });
        sb.group(sharedGroup).channel(LocalServerChannel.class).childHandler(new ChannelHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (data.equals(msg)) {
                    messageLatch.countDown();
                    ctx.writeAndFlush((Object)data);
                    ctx.close();
                } else {
                    ctx.fireChannelRead(msg);
                }
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                messageLatch.countDown();
                ctx.fireChannelInactive();
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            cc = (Channel)cb.connect(sc.localAddress()).get();
            Assertions.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)cc.isOpen());
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteInWritePromiseCompletePreservesOrderByteBuf() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(2);
        final ByteBuf data = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        final ByteBuf data2 = Unpooled.wrappedBuffer((byte[])new byte[512]);
        try {
            ((Bootstrap)cb.group(group1)).channel(LocalChannel.class).handler((ChannelHandler)new TestHandler());
            sb.group(group2).channel(LocalServerChannel.class).childHandler(new ChannelHandler(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    long count = messageLatch.getCount();
                    if (data.equals(msg) && count == 2L || data2.equals(msg) && count == 1L) {
                        ReferenceCountUtil.safeRelease((Object)msg);
                        messageLatch.countDown();
                    } else {
                        ctx.fireChannelRead(msg);
                    }
                }
            });
            Channel sc = null;
            Channel cc = null;
            try {
                sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
                Channel ccCpy = cc = (Channel)cb.connect(sc.localAddress()).get();
                cc.pipeline().lastContext().executor().execute(() -> ccCpy.writeAndFlush((Object)data.retainedDuplicate()).addListener(future -> ccCpy.writeAndFlush((Object)data2.retainedDuplicate())));
                Assertions.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
            }
            catch (Throwable throwable) {
                LocalChannelTest.closeChannel(cc);
                LocalChannelTest.closeChannel(sc);
                throw throwable;
            }
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
        }
        finally {
            data.release();
            data2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteInWritePromiseCompletePreservesOrder() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(2);
        final Buffer data = BufferAllocator.onHeapUnpooled().allocate(1024);
        final Buffer data2 = BufferAllocator.onHeapUnpooled().allocate(512);
        ((Bootstrap)cb.group(group1)).channel(LocalChannel.class).handler((ChannelHandler)new TestHandler());
        sb.group(group2).channel(LocalServerChannel.class).childHandler(new ChannelHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                long count = messageLatch.getCount();
                if (msg instanceof Buffer && data.equals(msg) && count == 2L || data2.equals(msg) && count == 1L) {
                    ((Buffer)msg).close();
                    messageLatch.countDown();
                } else {
                    ctx.fireChannelRead(msg);
                }
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            Channel ccCpy = cc = (Channel)cb.connect(sc.localAddress()).get();
            cc.pipeline().lastContext().executor().execute(() -> ccCpy.writeAndFlush((Object)data).addListener(future -> ccCpy.writeAndFlush((Object)data2)));
            Assertions.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerWriteInWritePromiseCompleteDifferentEventLoopPreservesOrderByteBuf() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(2);
        final ByteBuf data = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        final ByteBuf data2 = Unpooled.wrappedBuffer((byte[])new byte[512]);
        final CountDownLatch serverChannelLatch = new CountDownLatch(1);
        final AtomicReference serverChannelRef = new AtomicReference();
        ((Bootstrap)cb.group(group1)).channel(LocalChannel.class).handler(new ChannelHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (data2.equals(msg)) {
                    ReferenceCountUtil.safeRelease((Object)msg);
                    messageLatch.countDown();
                } else {
                    ctx.fireChannelRead(msg);
                }
            }
        });
        sb.group(group2).channel(LocalServerChannel.class).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        if (data.equals(msg)) {
                            ReferenceCountUtil.safeRelease((Object)msg);
                            messageLatch.countDown();
                        } else {
                            ctx.fireChannelRead(msg);
                        }
                    }
                }});
                serverChannelRef.set(ch);
                serverChannelLatch.countDown();
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            cc = (Channel)cb.connect(sc.localAddress()).get();
            Assertions.assertTrue((boolean)serverChannelLatch.await(5L, TimeUnit.SECONDS));
            Channel ccCpy = cc;
            cc.pipeline().lastContext().executor().execute(() -> ccCpy.writeAndFlush((Object)data.retainedDuplicate()).addListener(future -> {
                Channel serverChannelCpy = (Channel)serverChannelRef.get();
                serverChannelCpy.writeAndFlush((Object)data2.retainedDuplicate());
            }));
            Assertions.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            data.release();
            data2.release();
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
        data.release();
        data2.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerWriteInWritePromiseCompleteDifferentEventLoopPreservesOrder() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(2);
        final Buffer data = BufferAllocator.onHeapUnpooled().allocate(1024);
        final Buffer data2 = BufferAllocator.onHeapUnpooled().allocate(512);
        final CountDownLatch serverChannelLatch = new CountDownLatch(1);
        final AtomicReference serverChannelRef = new AtomicReference();
        ((Bootstrap)cb.group(group1)).channel(LocalChannel.class).handler(new ChannelHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg instanceof Buffer && data2.equals(msg)) {
                    ((Buffer)msg).close();
                    messageLatch.countDown();
                } else {
                    ctx.fireChannelRead(msg);
                }
            }
        });
        sb.group(group2).channel(LocalServerChannel.class).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        if (msg instanceof Buffer && data.equals(msg)) {
                            ((Buffer)msg).close();
                            messageLatch.countDown();
                        } else {
                            ctx.fireChannelRead(msg);
                        }
                    }
                }});
                serverChannelRef.set(ch);
                serverChannelLatch.countDown();
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            cc = (Channel)cb.connect(sc.localAddress()).get();
            Assertions.assertTrue((boolean)serverChannelLatch.await(5L, TimeUnit.SECONDS));
            Channel ccCpy = cc;
            cc.pipeline().lastContext().executor().execute(() -> ccCpy.writeAndFlush((Object)data).addListener(future -> {
                Channel serverChannelCpy = (Channel)serverChannelRef.get();
                serverChannelCpy.writeAndFlush((Object)data2);
            }));
            Assertions.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerWriteInWritePromiseCompleteSameEventLoopPreservesOrderByteBuf() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(2);
        final ByteBuf data = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        final ByteBuf data2 = Unpooled.wrappedBuffer((byte[])new byte[512]);
        final CountDownLatch serverChannelLatch = new CountDownLatch(1);
        final AtomicReference serverChannelRef = new AtomicReference();
        try {
            ((Bootstrap)cb.group(sharedGroup)).channel(LocalChannel.class).handler(new ChannelHandler(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (data2.equals(msg) && messageLatch.getCount() == 1L) {
                        ReferenceCountUtil.safeRelease((Object)msg);
                        messageLatch.countDown();
                    } else {
                        ctx.fireChannelRead(msg);
                    }
                }
            });
            sb.group(sharedGroup).channel(LocalServerChannel.class).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

                public void initChannel(LocalChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            if (data.equals(msg) && messageLatch.getCount() == 2L) {
                                ReferenceCountUtil.safeRelease((Object)msg);
                                messageLatch.countDown();
                            } else {
                                ctx.fireChannelRead(msg);
                            }
                        }
                    }});
                    serverChannelRef.set(ch);
                    serverChannelLatch.countDown();
                }
            });
            Channel sc = null;
            Channel cc = null;
            try {
                sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
                cc = (Channel)cb.connect(sc.localAddress()).get();
                Assertions.assertTrue((boolean)serverChannelLatch.await(5L, TimeUnit.SECONDS));
                Channel ccCpy = cc;
                cc.pipeline().lastContext().executor().execute(() -> ccCpy.writeAndFlush((Object)data.retainedDuplicate()).addListener(future -> {
                    Channel serverChannelCpy = (Channel)serverChannelRef.get();
                    serverChannelCpy.writeAndFlush((Object)data2.retainedDuplicate());
                }));
                Assertions.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
            }
            catch (Throwable throwable) {
                LocalChannelTest.closeChannel(cc);
                LocalChannelTest.closeChannel(sc);
                throw throwable;
            }
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
        }
        finally {
            data.release();
            data2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerWriteInWritePromiseCompleteSameEventLoopPreservesOrder() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(2);
        final Buffer data = BufferAllocator.onHeapUnpooled().allocate(1024);
        final Buffer data2 = BufferAllocator.onHeapUnpooled().allocate(512);
        final CountDownLatch serverChannelLatch = new CountDownLatch(1);
        final AtomicReference serverChannelRef = new AtomicReference();
        ((Bootstrap)cb.group(sharedGroup)).channel(LocalChannel.class).handler(new ChannelHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg instanceof Buffer && data2.equals(msg) && messageLatch.getCount() == 1L) {
                    ((Buffer)msg).close();
                    messageLatch.countDown();
                } else {
                    ctx.fireChannelRead(msg);
                }
            }
        });
        sb.group(sharedGroup).channel(LocalServerChannel.class).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        if (msg instanceof Buffer && data.equals(msg) && messageLatch.getCount() == 2L) {
                            ((Buffer)msg).close();
                            messageLatch.countDown();
                        } else {
                            ctx.fireChannelRead(msg);
                        }
                    }
                }});
                serverChannelRef.set(ch);
                serverChannelLatch.countDown();
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            cc = (Channel)cb.connect(sc.localAddress()).get();
            Assertions.assertTrue((boolean)serverChannelLatch.await(5L, TimeUnit.SECONDS));
            Channel ccCpy = cc;
            cc.pipeline().lastContext().executor().execute(() -> ccCpy.writeAndFlush((Object)data).addListener(future -> {
                Channel serverChannelCpy = (Channel)serverChannelRef.get();
                serverChannelCpy.writeAndFlush((Object)data2);
            }));
            Assertions.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteWhilePeerIsClosedReleaseObjectAndFailPromiseByteBuf() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch serverMessageLatch = new CountDownLatch(1);
        LatchChannelFutureListener serverChannelCloseLatch = new LatchChannelFutureListener(1);
        LatchChannelFutureListener clientChannelCloseLatch = new LatchChannelFutureListener(1);
        CountDownLatch writeFailLatch = new CountDownLatch(1);
        final ByteBuf data = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        ByteBuf data2 = Unpooled.wrappedBuffer((byte[])new byte[512]);
        final CountDownLatch serverChannelLatch = new CountDownLatch(1);
        final AtomicReference serverChannelRef = new AtomicReference();
        try {
            ((Bootstrap)cb.group(group1)).channel(LocalChannel.class).handler((ChannelHandler)new TestHandler());
            sb.group(group2).channel(LocalServerChannel.class).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

                public void initChannel(LocalChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            if (data.equals(msg)) {
                                ReferenceCountUtil.safeRelease((Object)msg);
                                serverMessageLatch.countDown();
                            } else {
                                ctx.fireChannelRead(msg);
                            }
                        }
                    }});
                    serverChannelRef.set(ch);
                    serverChannelLatch.countDown();
                }
            });
            Channel sc = null;
            Channel cc = null;
            try {
                sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
                cc = (Channel)cb.connect(sc.localAddress()).get();
                Assertions.assertTrue((boolean)serverChannelLatch.await(5L, TimeUnit.SECONDS));
                Channel ccCpy = cc;
                Channel serverChannelCpy = (Channel)serverChannelRef.get();
                serverChannelCpy.closeFuture().addListener((FutureListener)serverChannelCloseLatch);
                ccCpy.closeFuture().addListener((FutureListener)clientChannelCloseLatch);
                cc.pipeline().lastContext().executor().execute(() -> ccCpy.writeAndFlush((Object)data.retainedDuplicate()).addListener(future -> {
                    serverChannelCpy.executor().execute(() -> {
                        int waitCount = 0;
                        while (ccCpy.isOpen()) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (++waitCount <= 5) continue;
                            Assertions.fail();
                        }
                        serverChannelCpy.writeAndFlush((Object)data2.retainedDuplicate()).addListener(future1 -> {
                            if (!future1.isSuccess() && future1.cause() instanceof ClosedChannelException) {
                                writeFailLatch.countDown();
                            }
                        });
                    });
                    ccCpy.close();
                }));
                Assertions.assertTrue((boolean)serverMessageLatch.await(5L, TimeUnit.SECONDS));
                Assertions.assertTrue((boolean)writeFailLatch.await(5L, TimeUnit.SECONDS));
                Assertions.assertTrue((boolean)serverChannelCloseLatch.await(5L, TimeUnit.SECONDS));
                Assertions.assertTrue((boolean)clientChannelCloseLatch.await(5L, TimeUnit.SECONDS));
                Assertions.assertFalse((boolean)ccCpy.isOpen());
                Assertions.assertFalse((boolean)serverChannelCpy.isOpen());
            }
            catch (Throwable throwable) {
                LocalChannelTest.closeChannel(cc);
                LocalChannelTest.closeChannel(sc);
                throw throwable;
            }
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
        }
        finally {
            data.release();
            data2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteWhilePeerIsClosedReleaseObjectAndFailPromise() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch serverMessageLatch = new CountDownLatch(1);
        LatchChannelFutureListener serverChannelCloseLatch = new LatchChannelFutureListener(1);
        LatchChannelFutureListener clientChannelCloseLatch = new LatchChannelFutureListener(1);
        CountDownLatch writeFailLatch = new CountDownLatch(1);
        final Buffer data = BufferAllocator.onHeapUnpooled().allocate(1024);
        Buffer data2 = BufferAllocator.onHeapUnpooled().allocate(512);
        final CountDownLatch serverChannelLatch = new CountDownLatch(1);
        final AtomicReference serverChannelRef = new AtomicReference();
        ((Bootstrap)cb.group(group1)).channel(LocalChannel.class).handler((ChannelHandler)new TestHandler());
        sb.group(group2).channel(LocalServerChannel.class).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelHandler(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        if (msg instanceof Buffer && data.equals(msg)) {
                            ((Buffer)msg).close();
                            serverMessageLatch.countDown();
                        } else {
                            ctx.fireChannelRead(msg);
                        }
                    }
                }});
                serverChannelRef.set(ch);
                serverChannelLatch.countDown();
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            cc = (Channel)cb.connect(sc.localAddress()).get();
            Assertions.assertTrue((boolean)serverChannelLatch.await(5L, TimeUnit.SECONDS));
            Channel ccCpy = cc;
            Channel serverChannelCpy = (Channel)serverChannelRef.get();
            serverChannelCpy.closeFuture().addListener((FutureListener)serverChannelCloseLatch);
            ccCpy.closeFuture().addListener((FutureListener)clientChannelCloseLatch);
            cc.pipeline().lastContext().executor().execute(() -> ccCpy.writeAndFlush((Object)data).addListener(future -> {
                serverChannelCpy.executor().execute(() -> {
                    int waitCount = 0;
                    while (ccCpy.isOpen()) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (++waitCount <= 5) continue;
                        Assertions.fail();
                    }
                    serverChannelCpy.writeAndFlush((Object)data2).addListener(future1 -> {
                        if (!future1.isSuccess() && future1.cause() instanceof ClosedChannelException) {
                            writeFailLatch.countDown();
                        }
                    });
                });
                ccCpy.close();
            }));
            Assertions.assertTrue((boolean)serverMessageLatch.await(5L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)writeFailLatch.await(5L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)serverChannelCloseLatch.await(5L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)clientChannelCloseLatch.await(5L, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)ccCpy.isOpen());
            Assertions.assertFalse((boolean)serverChannelCpy.isOpen());
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testConnectFutureBeforeChannelActive() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)cb.group(group1)).channel(LocalChannel.class).handler(new ChannelHandler(){});
        sb.group(group2).channel(LocalServerChannel.class).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new TestHandler()});
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            cc = (Channel)cb.register().get();
            final AtomicReference ref = new AtomicReference();
            final Promise assertPromise = cc.executor().newPromise();
            cc.pipeline().addLast(new ChannelHandler[]{new TestHandler(){

                public Future<Void> connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress) {
                    Future future = super.connect(ctx, remoteAddress, localAddress);
                    ref.set(future);
                    return future;
                }

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    if (((Future)ref.get()).isDone()) {
                        assertPromise.setSuccess(null);
                    } else {
                        assertPromise.setFailure((Throwable)((Object)new AssertionError((Object)"connect promise should be done")));
                    }
                }
            }});
            cc.connect(sc.localAddress()).sync();
            Future f = ((Future)ref.get()).sync();
            assertPromise.asFuture().syncUninterruptibly();
            Assertions.assertTrue((boolean)f.isSuccess());
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    @Test
    public void testConnectionRefused() throws Throwable {
        try {
            Bootstrap sb = new Bootstrap();
            Assertions.assertTrue((boolean)(((CompletionException)Assertions.assertThrows(CompletionException.class, () -> ((Bootstrap)((Bootstrap)sb.group(group1)).channel(LocalChannel.class).handler((ChannelHandler)new TestHandler())).connect((SocketAddress)LocalAddress.ANY).syncUninterruptibly())).getCause() instanceof ConnectException));
        }
        catch (CompletionException e) {
            throw e.getCause();
        }
    }

    private static void closeChannel(Channel cc) {
        if (cc != null) {
            cc.close().syncUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotLeakBuffersWhenCloseByRemotePeerByteBuf() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)cb.group(sharedGroup)).channel(LocalChannel.class).handler((ChannelHandler)new SimpleChannelInboundHandler<ByteBuf>(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                ctx.writeAndFlush((Object)ctx.alloc().buffer().writeZero(100));
            }

            public void messageReceived(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
            }
        });
        sb.group(sharedGroup).channel(LocalServerChannel.class).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                    public void messageReceived(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
                        while (buffer.isReadable()) {
                            ctx.write((Object)buffer.readRetainedSlice(1));
                        }
                        ctx.flush();
                        ctx.close();
                    }
                }});
            }
        });
        Channel sc = null;
        LocalChannel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            cc = (LocalChannel)cb.connect(sc.localAddress()).get();
            LocalChannelTest.closeChannel((Channel)cc);
            Assertions.assertTrue((boolean)cc.inboundBuffer.isEmpty());
            LocalChannelTest.closeChannel(sc);
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel((Channel)cc);
        LocalChannelTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotLeakBuffersWhenCloseByRemotePeer() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)cb.group(sharedGroup)).channel(LocalChannel.class).handler((ChannelHandler)new SimpleChannelInboundHandler<Buffer>(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                ctx.writeAndFlush((Object)ctx.bufferAllocator().copyOf(new byte[100]));
            }

            public void messageReceived(ChannelHandlerContext ctx, Buffer buffer) throws Exception {
            }
        });
        sb.group(sharedGroup).channel(LocalServerChannel.class).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<Buffer>(){

                    public void messageReceived(ChannelHandlerContext ctx, Buffer buffer) throws Exception {
                        while (buffer.readableBytes() > 0) {
                            ctx.write((Object)buffer.readSplit(1));
                        }
                        ctx.flush();
                        ctx.close();
                    }
                }});
            }
        });
        Channel sc = null;
        LocalChannel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            cc = (LocalChannel)cb.connect(sc.localAddress()).get();
            LocalChannelTest.closeChannel((Channel)cc);
            Assertions.assertTrue((boolean)cc.inboundBuffer.isEmpty());
            LocalChannelTest.closeChannel(sc);
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel((Channel)cc);
        LocalChannelTest.closeChannel(sc);
    }

    private static void writeAndFlushReadOnSuccess(ChannelHandlerContext ctx, Object msg) {
        ctx.writeAndFlush(msg).addListener(future -> {
            if (future.isSuccess()) {
                ctx.read();
            }
        });
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testAutoReadDisabledSharedGroup() throws Exception {
        LocalChannelTest.testAutoReadDisabled(sharedGroup, sharedGroup);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testAutoReadDisabledDifferentGroup() throws Exception {
        LocalChannelTest.testAutoReadDisabled(group1, group2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testAutoReadDisabled(EventLoopGroup serverGroup, EventLoopGroup clientGroup) throws Exception {
        final CountDownLatch latch = new CountDownLatch(100);
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)((Bootstrap)cb.group(serverGroup)).channel(LocalChannel.class).option(ChannelOption.AUTO_READ, (Object)false)).handler(new ChannelHandler(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                LocalChannelTest.writeAndFlushReadOnSuccess(ctx, "test");
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                LocalChannelTest.writeAndFlushReadOnSuccess(ctx, msg);
            }
        });
        sb.group(clientGroup).channel(LocalServerChannel.class).childOption(ChannelOption.AUTO_READ, (Object)false).childHandler(new ChannelHandler(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                ctx.read();
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                latch.countDown();
                if (latch.getCount() > 0L) {
                    LocalChannelTest.writeAndFlushReadOnSuccess(ctx, msg);
                }
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            cc = (Channel)cb.connect((SocketAddress)TEST_ADDRESS).get();
            latch.await();
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxMessagesPerReadRespectedWithAutoReadSharedGroup() throws Exception {
        LocalChannelTest.testMaxMessagesPerReadRespected(sharedGroup, sharedGroup, true);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxMessagesPerReadRespectedWithoutAutoReadSharedGroup() throws Exception {
        LocalChannelTest.testMaxMessagesPerReadRespected(sharedGroup, sharedGroup, false);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxMessagesPerReadRespectedWithAutoReadDifferentGroup() throws Exception {
        LocalChannelTest.testMaxMessagesPerReadRespected(group1, group2, true);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxMessagesPerReadRespectedWithoutAutoReadDifferentGroup() throws Exception {
        LocalChannelTest.testMaxMessagesPerReadRespected(group1, group2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testMaxMessagesPerReadRespected(EventLoopGroup serverGroup, EventLoopGroup clientGroup, boolean autoRead) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(5);
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)cb.group(serverGroup)).channel(LocalChannel.class).option(ChannelOption.AUTO_READ, (Object)autoRead)).option(ChannelOption.MAX_MESSAGES_PER_READ, (Object)1)).handler((ChannelHandler)new ChannelReadHandler(countDownLatch, autoRead));
        sb.group(clientGroup).channel(LocalServerChannel.class).childHandler(new ChannelHandler(){

            public void channelActive(ChannelHandlerContext ctx) {
                for (int i = 0; i < 10; ++i) {
                    ctx.write((Object)i);
                }
                ctx.flush();
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            cc = (Channel)cb.connect((SocketAddress)TEST_ADDRESS).get();
            countDownLatch.await();
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testServerMaxMessagesPerReadRespectedWithAutoReadSharedGroup() throws Exception {
        LocalChannelTest.testServerMaxMessagesPerReadRespected(sharedGroup, sharedGroup, true);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testServerMaxMessagesPerReadRespectedWithoutAutoReadSharedGroup() throws Exception {
        LocalChannelTest.testServerMaxMessagesPerReadRespected(sharedGroup, sharedGroup, false);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testServerMaxMessagesPerReadRespectedWithAutoReadDifferentGroup() throws Exception {
        LocalChannelTest.testServerMaxMessagesPerReadRespected(group1, group2, true);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testServerMaxMessagesPerReadRespectedWithoutAutoReadDifferentGroup() throws Exception {
        LocalChannelTest.testServerMaxMessagesPerReadRespected(group1, group2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testServerMaxMessagesPerReadRespected(EventLoopGroup serverGroup, EventLoopGroup clientGroup, boolean autoRead) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(5);
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)cb.group(serverGroup)).channel(LocalChannel.class).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
            }
        });
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)sb.group(clientGroup).channel(LocalServerChannel.class).option(ChannelOption.AUTO_READ, (Object)autoRead)).option(ChannelOption.MAX_MESSAGES_PER_READ, (Object)1)).handler((ChannelHandler)new ChannelReadHandler(countDownLatch, autoRead))).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = (Channel)sb.bind((SocketAddress)TEST_ADDRESS).get();
            for (int i = 0; i < 5; ++i) {
                try {
                    cc = (Channel)cb.connect((SocketAddress)TEST_ADDRESS).get();
                }
                catch (Throwable throwable) {
                    LocalChannelTest.closeChannel(cc);
                    throw throwable;
                }
                LocalChannelTest.closeChannel(cc);
            }
            countDownLatch.await();
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(sc);
    }

    private static final class ChannelReadHandler
    implements ChannelHandler {
        private final CountDownLatch latch;
        private final boolean autoRead;
        private int read;

        ChannelReadHandler(CountDownLatch latch, boolean autoRead) {
            this.latch = latch;
            this.autoRead = autoRead;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            if (!this.autoRead) {
                ctx.read();
            }
            ctx.fireChannelActive();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            Assertions.assertEquals((int)0, (int)this.read);
            ++this.read;
            ctx.fireChannelRead(msg);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            Assertions.assertEquals((int)1, (int)this.read);
            this.latch.countDown();
            if (this.latch.getCount() > 0L) {
                if (!this.autoRead) {
                    ctx.executor().schedule(() -> {
                        this.read = 0;
                        ctx.read();
                    }, 100L, TimeUnit.MILLISECONDS);
                } else {
                    this.read = 0;
                }
            } else {
                this.read = 0;
            }
            ctx.fireChannelReadComplete();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.fireExceptionCaught(cause);
            ctx.close();
        }
    }

    static class TestHandler
    implements ChannelHandler {
        TestHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            logger.info(String.format("Received message: %s", msg));
            ReferenceCountUtil.safeRelease((Object)msg);
        }
    }

    private static final class LatchChannelFutureListener
    extends CountDownLatch
    implements FutureListener<Object> {
        private LatchChannelFutureListener(int count) {
            super(count);
        }

        public void operationComplete(Future<?> future) throws Exception {
            this.countDown();
        }
    }
}

