/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.local;

import io.netty5.bootstrap.Bootstrap;
import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.local.LocalAddress;
import io.netty5.channel.local.LocalChannel;
import io.netty5.channel.local.LocalServerChannel;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class LocalTransportThreadModelTest2 {
    private static final String LOCAL_CHANNEL = LocalTransportThreadModelTest2.class.getName();
    static final int messageCountPerRun = 4;

    @Test
    @Timeout(value=15000L, unit=TimeUnit.MILLISECONDS)
    public void testSocketReuse() throws Exception {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        LocalHandler serverHandler = new LocalHandler("SERVER");
        serverBootstrap.group((EventLoopGroup)new MultithreadEventLoopGroup(io.netty5.channel.local.LocalHandler.newFactory()), (EventLoopGroup)new MultithreadEventLoopGroup(io.netty5.channel.local.LocalHandler.newFactory())).channel(LocalServerChannel.class).childHandler((ChannelHandler)serverHandler);
        Bootstrap clientBootstrap = new Bootstrap();
        LocalHandler clientHandler = new LocalHandler("CLIENT");
        ((Bootstrap)clientBootstrap.group((EventLoopGroup)new MultithreadEventLoopGroup(io.netty5.channel.local.LocalHandler.newFactory()))).channel(LocalChannel.class).remoteAddress((SocketAddress)new LocalAddress(LOCAL_CHANNEL)).handler((ChannelHandler)clientHandler);
        serverBootstrap.bind((SocketAddress)new LocalAddress(LOCAL_CHANNEL)).sync();
        int count = 100;
        for (int i = 1; i < count + 1; ++i) {
            Channel ch = (Channel)clientBootstrap.connect().get();
            int target = i * 4;
            while (serverHandler.count.get() != target || clientHandler.count.get() != target) {
                Thread.sleep(50L);
            }
            this.close(ch, clientHandler);
        }
        Assertions.assertEquals((int)(count * 2 * 4), (int)(serverHandler.count.get() + clientHandler.count.get()));
    }

    public void close(Channel localChannel, LocalHandler localRegistrationHandler) {
        if (localChannel.executor().inEventLoop()) {
            if (localRegistrationHandler.lastWriteFuture != null) {
                localRegistrationHandler.lastWriteFuture.awaitUninterruptibly();
            }
            localChannel.close();
            return;
        }
        localChannel.executor().execute(() -> this.close(localChannel, localRegistrationHandler));
        localChannel.closeFuture().awaitUninterruptibly();
    }

    @ChannelHandler.Sharable
    static class LocalHandler
    implements ChannelHandler {
        private final String name;
        public volatile Future<Void> lastWriteFuture;
        public final AtomicInteger count = new AtomicInteger(0);

        LocalHandler(String name) {
            this.name = name;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            for (int i = 0; i < 4; ++i) {
                this.lastWriteFuture = ctx.channel().write((Object)(this.name + " " + i));
            }
            ctx.channel().flush();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.count.incrementAndGet();
            ReferenceCountUtil.release((Object)msg);
        }
    }
}

