/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.nio;

import io.netty5.channel.AbstractEventLoopTest;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.IoHandler;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.SelectStrategy;
import io.netty5.channel.SelectStrategyFactory;
import io.netty5.channel.SingleThreadEventLoop;
import io.netty5.channel.nio.NioHandler;
import io.netty5.channel.nio.NioTask;
import io.netty5.channel.socket.ServerSocketChannel;
import io.netty5.channel.socket.nio.NioServerSocketChannel;
import io.netty5.util.IntSupplier;
import io.netty5.util.concurrent.DefaultThreadFactory;
import io.netty5.util.concurrent.Future;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class NioEventLoopTest
extends AbstractEventLoopTest {
    @Override
    protected EventLoopGroup newEventLoopGroup() {
        return new MultithreadEventLoopGroup(NioHandler.newFactory());
    }

    @Override
    protected Class<? extends ServerSocketChannel> newChannel() {
        return NioServerSocketChannel.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRebuildSelector() {
        NioHandler nioHandler = (NioHandler)NioHandler.newFactory().newHandler();
        SingleThreadEventLoop loop = new SingleThreadEventLoop((ThreadFactory)new DefaultThreadFactory("ioPool"), (IoHandler)nioHandler);
        try {
            NioServerSocketChannel channel = new NioServerSocketChannel((EventLoop)loop, (EventLoopGroup)loop);
            channel.register().syncUninterruptibly();
            Selector selector = (Selector)loop.submit(() -> ((NioHandler)nioHandler).unwrappedSelector()).syncUninterruptibly().getNow();
            Assertions.assertSame((Object)selector, (Object)loop.submit(() -> ((NioHandler)nioHandler).unwrappedSelector()).syncUninterruptibly().getNow());
            Assertions.assertTrue((boolean)selector.isOpen());
            loop.submit(() -> ((NioHandler)nioHandler).rebuildSelector()).syncUninterruptibly();
            Selector newSelector = (Selector)loop.submit(() -> ((NioHandler)nioHandler).unwrappedSelector()).syncUninterruptibly().getNow();
            Assertions.assertTrue((boolean)newSelector.isOpen());
            Assertions.assertNotSame((Object)selector, (Object)newSelector);
            Assertions.assertFalse((boolean)selector.isOpen());
            channel.close().syncUninterruptibly();
        }
        finally {
            loop.shutdownGracefully();
        }
    }

    @Test
    public void testScheduleBigDelayNotOverflow() {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        EventLoop el = group.next();
        Future future = el.schedule(() -> {}, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assertions.assertFalse((boolean)future.awaitUninterruptibly(1000L));
        Assertions.assertTrue((boolean)future.cancel());
        group.shutdownGracefully();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterruptEventLoopThread() throws Exception {
        NioHandler nioHandler = (NioHandler)NioHandler.newFactory().newHandler();
        SingleThreadEventLoop loop = new SingleThreadEventLoop((ThreadFactory)new DefaultThreadFactory("ioPool"), (IoHandler)nioHandler);
        try {
            Selector selector = (Selector)loop.submit(() -> ((NioHandler)nioHandler).unwrappedSelector()).syncUninterruptibly().getNow();
            Assertions.assertTrue((boolean)selector.isOpen());
            loop.submit(() -> Thread.currentThread().interrupt()).syncUninterruptibly();
            Assertions.assertTrue((boolean)selector.isOpen());
            CountDownLatch latch = new CountDownLatch(2);
            loop.submit(latch::countDown).syncUninterruptibly();
            loop.schedule(latch::countDown, 2L, TimeUnit.SECONDS).syncUninterruptibly();
            latch.await();
            Assertions.assertSame((Object)selector, (Object)loop.submit(() -> ((NioHandler)nioHandler).unwrappedSelector()).syncUninterruptibly().getNow());
            Assertions.assertTrue((boolean)selector.isOpen());
        }
        finally {
            loop.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testSelectableChannel() throws Exception {
        NioHandler nioHandler = (NioHandler)NioHandler.newFactory().newHandler();
        SingleThreadEventLoop loop = new SingleThreadEventLoop((ThreadFactory)new DefaultThreadFactory("ioPool"), (IoHandler)nioHandler);
        try {
            NioServerSocketChannel channel = new NioServerSocketChannel((EventLoop)loop, (EventLoopGroup)loop);
            channel.register().syncUninterruptibly();
            channel.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly();
            SocketChannel selectableChannel = SocketChannel.open();
            selectableChannel.configureBlocking(false);
            selectableChannel.connect(channel.localAddress());
            final CountDownLatch latch = new CountDownLatch(1);
            loop.execute(() -> nioHandler.register((SelectableChannel)selectableChannel, 8, (NioTask)new NioTask<SocketChannel>(){

                public void channelReady(SocketChannel ch, SelectionKey key) {
                    latch.countDown();
                }

                public void channelUnregistered(SocketChannel ch, Throwable cause) {
                }
            }));
            latch.await();
            selectableChannel.close();
            channel.close().syncUninterruptibly();
        }
        finally {
            loop.shutdownGracefully();
        }
    }

    @Test
    public void testTaskRemovalOnShutdownThrowsNoUnsupportedOperationException() throws Exception {
        AtomicReference error = new AtomicReference();
        Runnable task = () -> {};
        for (int i = 0; i < 1000; ++i) {
            MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
            EventLoop loop = group.next();
            Thread t = new Thread(() -> {
                try {
                    while (true) {
                        loop.execute(task);
                    }
                }
                catch (Throwable cause) {
                    error.set(cause);
                    return;
                }
            });
            t.start();
            Future termination = group.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            t.join();
            termination.syncUninterruptibly();
            MatcherAssert.assertThat((Object)((Throwable)error.get()), (Matcher)Matchers.instanceOf(RejectedExecutionException.class));
            error.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRebuildSelectorOnIOException() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch strategyLatch = new CountDownLatch(1);
        SelectStrategyFactory selectStrategyFactory = () -> new SelectStrategy(){
            private boolean thrown;

            public int calculateStrategy(IntSupplier selectSupplier, boolean hasTasks) throws Exception {
                strategyLatch.await();
                if (!this.thrown) {
                    this.thrown = true;
                    throw new IOException("expected exception!");
                }
                latch.countDown();
                return -1;
            }
        };
        NioHandler nioHandler = (NioHandler)NioHandler.newFactory((SelectorProvider)SelectorProvider.provider(), (SelectStrategyFactory)selectStrategyFactory).newHandler();
        SingleThreadEventLoop loop = new SingleThreadEventLoop((ThreadFactory)new DefaultThreadFactory("ioPool"), (IoHandler)nioHandler);
        try {
            NioServerSocketChannel channel = new NioServerSocketChannel((EventLoop)loop, (EventLoopGroup)loop);
            Selector selector = nioHandler.unwrappedSelector();
            strategyLatch.countDown();
            channel.register().syncUninterruptibly();
            latch.await();
            Selector newSelector = (Selector)loop.submit(() -> ((NioHandler)nioHandler).unwrappedSelector()).syncUninterruptibly().getNow();
            Assertions.assertTrue((boolean)newSelector.isOpen());
            Assertions.assertNotSame((Object)selector, (Object)newSelector);
            Assertions.assertFalse((boolean)selector.isOpen());
            channel.close().syncUninterruptibly();
        }
        finally {
            loop.shutdownGracefully();
        }
    }
}

