/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.socket.nio;

import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.nio.AbstractNioChannel;
import io.netty5.channel.nio.NioHandler;
import io.netty5.channel.socket.nio.NioChannelOption;
import io.netty5.util.concurrent.AbstractEventExecutor;
import io.netty5.util.concurrent.Future;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractNioChannelTest<T extends AbstractNioChannel> {
    protected abstract T newNioChannel(EventLoopGroup var1);

    protected abstract NetworkChannel jdkChannel(T var1);

    protected abstract SocketOption<?> newInvalidOption();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNioChannelOption() throws IOException {
        MultithreadEventLoopGroup eventLoopGroup = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        T channel = this.newNioChannel((EventLoopGroup)eventLoopGroup);
        try {
            NetworkChannel jdkChannel = this.jdkChannel(channel);
            ChannelOption option = NioChannelOption.of(StandardSocketOptions.SO_REUSEADDR);
            boolean value1 = jdkChannel.getOption(StandardSocketOptions.SO_REUSEADDR);
            boolean value2 = (Boolean)channel.config().getOption(option);
            Assertions.assertEquals((Object)value1, (Object)value2);
            channel.config().setOption(option, (Object)(!value2 ? 1 : 0));
            boolean value3 = jdkChannel.getOption(StandardSocketOptions.SO_REUSEADDR);
            boolean value4 = (Boolean)channel.config().getOption(option);
            Assertions.assertEquals((Object)value3, (Object)value4);
            Assertions.assertNotEquals((Object)value1, (Object)value4);
        }
        finally {
            channel.close().syncUninterruptibly();
            eventLoopGroup.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidNioChannelOption() {
        MultithreadEventLoopGroup eventLoopGroup = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        T channel = this.newNioChannel((EventLoopGroup)eventLoopGroup);
        try {
            ChannelOption option = NioChannelOption.of(this.newInvalidOption());
            Assertions.assertFalse((boolean)channel.config().setOption(option, null));
            Assertions.assertNull((Object)channel.config().getOption(option));
        }
        finally {
            channel.close().syncUninterruptibly();
            eventLoopGroup.shutdownGracefully();
        }
    }

    @Test
    public void testGetOptions() {
        MultithreadEventLoopGroup eventLoopGroup = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        T channel = this.newNioChannel((EventLoopGroup)eventLoopGroup);
        try {
            channel.config().getOptions();
        }
        finally {
            channel.close().syncUninterruptibly();
            eventLoopGroup.shutdownGracefully();
        }
    }

    @Test
    public void testWrapping() {
        MultithreadEventLoopGroup eventLoopGroup = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        EventLoop eventLoop = eventLoopGroup.next();
        class WrappedEventLoop
        extends AbstractEventExecutor
        implements EventLoop {
            private final EventLoop eventLoop;

            WrappedEventLoop(EventLoop eventLoop) {
                this.eventLoop = eventLoop;
            }

            @Test
            public EventLoop next() {
                return this;
            }

            public EventLoop.Unsafe unsafe() {
                return this.eventLoop.unsafe();
            }

            public boolean inEventLoop(Thread thread) {
                return this.eventLoop.inEventLoop(thread);
            }

            public boolean isShuttingDown() {
                return this.eventLoop.isShuttingDown();
            }

            public Future<Void> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
                return this.eventLoop.shutdownGracefully(quietPeriod, timeout, unit);
            }

            public Future<Void> terminationFuture() {
                return this.eventLoop.terminationFuture();
            }

            public boolean isShutdown() {
                return this.eventLoop.isShutdown();
            }

            public boolean isTerminated() {
                return this.eventLoop.isTerminated();
            }

            public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                return this.eventLoop.awaitTermination(timeout, unit);
            }

            public void execute(Runnable task) {
                this.eventLoop.execute(task);
            }

            public Future<Void> schedule(Runnable task, long delay, TimeUnit unit) {
                return this.eventLoop.schedule(task, delay, unit);
            }

            public <V> Future<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
                return this.eventLoop.schedule(task, delay, unit);
            }

            public Future<Void> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
                return this.eventLoop.scheduleAtFixedRate(task, initialDelay, period, unit);
            }

            public Future<Void> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
                return this.eventLoop.scheduleWithFixedDelay(task, initialDelay, delay, unit);
            }
        }
        WrappedEventLoop wrapped = new WrappedEventLoop(eventLoop);
        T channel = this.newNioChannel((EventLoopGroup)wrapped);
        channel.register().syncUninterruptibly();
        Assertions.assertSame((Object)((Object)wrapped), (Object)channel.executor());
        channel.close().syncUninterruptibly();
        eventLoopGroup.shutdownGracefully();
    }
}

