/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.socket.nio;

import io.netty5.bootstrap.Bootstrap;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.group.DefaultChannelGroup;
import io.netty5.channel.nio.NioHandler;
import io.netty5.channel.socket.DatagramChannel;
import io.netty5.channel.socket.nio.AbstractNioChannelTest;
import io.netty5.channel.socket.nio.NioDatagramChannel;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NioDatagramChannelTest
extends AbstractNioChannelTest<NioDatagramChannel> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindMultiple() throws Exception {
        DefaultChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(NioHandler.newFactory());
        try {
            for (int i = 0; i < 100; ++i) {
                Bootstrap udpBootstrap = new Bootstrap();
                ((Bootstrap)((Bootstrap)udpBootstrap.group((EventLoopGroup)group)).channel(NioDatagramChannel.class).option(ChannelOption.SO_BROADCAST, (Object)true)).handler(new ChannelHandler(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        ReferenceCountUtil.release((Object)msg);
                    }
                });
                DatagramChannel datagramChannel = (DatagramChannel)udpBootstrap.bind((SocketAddress)new InetSocketAddress(0)).get();
                channelGroup.add((Channel)datagramChannel);
            }
            Assertions.assertEquals((int)100, (int)channelGroup.size());
        }
        finally {
            channelGroup.close().sync();
            group.shutdownGracefully().sync();
        }
    }

    @Override
    protected NioDatagramChannel newNioChannel(EventLoopGroup group) {
        return new NioDatagramChannel(group.next());
    }

    @Override
    protected NetworkChannel jdkChannel(NioDatagramChannel channel) {
        return channel.javaChannel();
    }

    @Override
    protected SocketOption<?> newInvalidOption() {
        return StandardSocketOptions.TCP_NODELAY;
    }
}

