/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.socket.nio;

import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.nio.NioHandler;
import io.netty5.channel.socket.nio.AbstractNioChannelTest;
import io.netty5.channel.socket.nio.NioServerSocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NioServerSocketChannelTest
extends AbstractNioChannelTest<NioServerSocketChannel> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseOnError() throws Exception {
        ServerSocketChannel jdkChannel = ServerSocketChannel.open();
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        NioServerSocketChannel serverSocketChannel = new NioServerSocketChannel(group.next(), (EventLoopGroup)group, jdkChannel);
        try {
            serverSocketChannel.register().syncUninterruptibly();
            serverSocketChannel.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly();
            Assertions.assertFalse((boolean)serverSocketChannel.closeOnReadError((Throwable)new IOException()));
            Assertions.assertTrue((boolean)serverSocketChannel.closeOnReadError((Throwable)new IllegalArgumentException()));
            serverSocketChannel.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testIsActiveFalseAfterClose() {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        NioServerSocketChannel channel = new NioServerSocketChannel(group.next(), (EventLoopGroup)group);
        try {
            channel.register().syncUninterruptibly();
            channel.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly();
            Assertions.assertTrue((boolean)channel.isActive());
            Assertions.assertTrue((boolean)channel.isOpen());
            channel.close().syncUninterruptibly();
            Assertions.assertFalse((boolean)channel.isOpen());
            Assertions.assertFalse((boolean)channel.isActive());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Override
    protected NioServerSocketChannel newNioChannel(EventLoopGroup group) {
        return new NioServerSocketChannel(group.next(), group);
    }

    @Override
    protected NetworkChannel jdkChannel(NioServerSocketChannel channel) {
        return channel.javaChannel();
    }

    @Override
    protected SocketOption<?> newInvalidOption() {
        return StandardSocketOptions.IP_MULTICAST_IF;
    }
}

