/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.socket.nio;

import io.netty5.bootstrap.Bootstrap;
import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.DefaultBufferAllocators;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelInitializer;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.SimpleChannelInboundHandler;
import io.netty5.channel.nio.NioHandler;
import io.netty5.channel.socket.SocketChannel;
import io.netty5.channel.socket.nio.AbstractNioChannelTest;
import io.netty5.channel.socket.nio.NioServerSocketChannel;
import io.netty5.channel.socket.nio.NioSocketChannel;
import io.netty5.util.CharsetUtil;
import io.netty5.util.NetUtil;
import io.netty5.util.concurrent.Future;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NetworkChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class NioSocketChannelTest
extends AbstractNioChannelTest<NioSocketChannel> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushCloseReentrance() throws Exception {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        try {
            final LinkedBlockingQueue futures = new LinkedBlockingQueue();
            ServerBootstrap sb = new ServerBootstrap();
            sb.group((EventLoopGroup)group).channel(NioServerSocketChannel.class);
            sb.childOption(ChannelOption.SO_SNDBUF, (Object)1024);
            sb.childHandler(new ChannelHandler(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    int firstSize = 1024;
                    int secondSize = 0x100000;
                    int thirdSize = 1024;
                    try (Buffer buf = ctx.bufferAllocator().allocate(firstSize + secondSize + thirdSize);){
                        buf.fill((byte)0);
                        buf.writerOffset(buf.capacity());
                        futures.add(ctx.write((Object)buf.readSplit(firstSize)).addListener((Object)ctx, ChannelFutureListeners.CLOSE));
                        futures.add(ctx.write((Object)buf.readSplit(secondSize)));
                        ctx.flush();
                        futures.add(ctx.write((Object)buf.readSplit(thirdSize)));
                    }
                    ctx.flush();
                }
            });
            SocketAddress address = ((Channel)sb.bind(0).get()).localAddress();
            Socket s = new Socket(NetUtil.LOCALHOST, ((InetSocketAddress)address).getPort());
            InputStream in = s.getInputStream();
            byte[] buf = new byte[8192];
            while (in.read(buf) != -1) {
                Thread.sleep(10L);
            }
            s.close();
            MatcherAssert.assertThat((Object)futures.size(), (Matcher)CoreMatchers.is((Object)3));
            Future f1 = (Future)futures.poll();
            Future f2 = (Future)futures.poll();
            Future f3 = (Future)futures.poll();
            MatcherAssert.assertThat((Object)f1.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)f2.isDone(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)f2.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)f2.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
            MatcherAssert.assertThat((Object)f3.isDone(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)f3.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)f3.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
        }
        finally {
            group.shutdownGracefully().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushAfterGatheredFlush() throws Exception {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        try {
            ServerBootstrap sb = new ServerBootstrap();
            sb.group((EventLoopGroup)group).channel(NioServerSocketChannel.class);
            sb.childHandler(new ChannelHandler(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    ctx.write((Object)DefaultBufferAllocators.onHeapAllocator().copyOf(new byte[]{97}));
                    Future f = ctx.write((Object)DefaultBufferAllocators.onHeapAllocator().copyOf(new byte[]{98}));
                    f.addListener(future -> ctx.writeAndFlush((Object)DefaultBufferAllocators.onHeapAllocator().copyOf(new byte[]{99})));
                    ctx.flush();
                }
            });
            SocketAddress address = ((Channel)sb.bind(0).get()).localAddress();
            Socket s = new Socket(NetUtil.LOCALHOST, ((InetSocketAddress)address).getPort());
            DataInputStream in = new DataInputStream(s.getInputStream());
            byte[] buf = new byte[3];
            in.readFully(buf);
            MatcherAssert.assertThat((Object)new String(buf, CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"abc"));
            s.close();
        }
        finally {
            group.shutdownGracefully().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelReRegisterReadSameEventLoop() throws Exception {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(2, NioHandler.newFactory());
        final CountDownLatch latch = new CountDownLatch(1);
        byte[] bytes = new byte[1024];
        ThreadLocalRandom.current().nextBytes(bytes);
        Channel sc = null;
        Channel cc = null;
        ServerBootstrap b = new ServerBootstrap();
        try {
            b.group((EventLoopGroup)group).channel(NioServerSocketChannel.class).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<Channel>((EventLoopGroup)group){
                final /* synthetic */ EventLoopGroup val$group;
                {
                    this.val$group = eventLoopGroup;
                }

                protected void initChannel(Channel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<Buffer>(){

                        protected void messageReceived(ChannelHandlerContext ctx, Buffer byteBuf) {
                            latch.countDown();
                        }

                        public void channelActive(ChannelHandlerContext ctx) throws Exception {
                            EventLoop loop = val$group.next();
                            this.deregister(ctx, loop);
                        }

                        private void deregister(ChannelHandlerContext ctx, EventLoop loop) {
                            ctx.deregister().addListener((Object)ctx.channel(), (c, f) -> c.register());
                        }
                    }});
                }
            });
            sc = (Channel)b.bind(0).get();
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class);
            bootstrap.handler(new ChannelHandler(){});
            cc = (Channel)bootstrap.connect(sc.localAddress()).get();
            cc.writeAndFlush((Object)DefaultBufferAllocators.onHeapAllocator().copyOf(bytes)).syncUninterruptibly();
            latch.await();
        }
        finally {
            if (cc != null) {
                cc.close();
            }
            if (sc != null) {
                sc.close();
            }
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testShutdownOutputAndClose() throws Exception {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        ServerSocket socket = new ServerSocket();
        socket.bind(new InetSocketAddress(0));
        Socket accepted = null;
        try {
            Bootstrap sb = new Bootstrap();
            ((Bootstrap)sb.group((EventLoopGroup)group)).channel(NioSocketChannel.class);
            sb.handler(new ChannelHandler(){});
            SocketChannel channel = (SocketChannel)sb.connect(socket.getLocalSocketAddress()).get();
            accepted = socket.accept();
            channel.shutdownOutput().syncUninterruptibly();
            channel.close().syncUninterruptibly();
        }
        finally {
            if (accepted != null) {
                try {
                    accepted.close();
                }
                catch (IOException iOException) {}
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            group.shutdownGracefully();
        }
    }

    @Override
    protected NioSocketChannel newNioChannel(EventLoopGroup group) {
        return new NioSocketChannel(group.next());
    }

    @Override
    protected NetworkChannel jdkChannel(NioSocketChannel channel) {
        return channel.javaChannel();
    }

    @Override
    protected SocketOption<?> newInvalidOption() {
        return StandardSocketOptions.IP_MULTICAST_IF;
    }
}

