/*
 * Copyright (C) 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * CborTree: A Java API for decoding, manipulating, and encoding CBOR data items.
 *
 * @see <a href="https://github.com/google/cbortree">CborTree Github Page</a>
 * @see <a href="https://tools.ietf.org/html/rfc7049">RFC7049: Concise Binary Object Representation
 *     (CBOR)</a>
 */
@ParametersAreNonnullByDefault
@CheckReturnValue
package com.google.iot.cbor;

import com.google.errorprone.annotations.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
