/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborArray;
import com.google.iot.cbor.CborObject;
import java.util.LinkedList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

final class CborArrayImpl
extends CborArray {
    private final LinkedList<CborObject> mList = new LinkedList();
    private int mTag = -1;
    private boolean mIsIndefiniteLength;
    private final @Nullable Integer mAdditionalInfo;

    CborArrayImpl(@Nullable Iterable<CborObject> list, int tag, boolean isIndefiniteLength, @Nullable Integer additionalInfo) {
        this.mTag = tag;
        if (list != null) {
            for (CborObject obj : list) {
                this.add(obj.copy());
            }
        }
        this.mIsIndefiniteLength = isIndefiniteLength;
        this.mAdditionalInfo = additionalInfo;
    }

    CborArrayImpl() {
        this.mAdditionalInfo = null;
    }

    @Override
    public int getTag() {
        return this.mTag;
    }

    @Override
    public List<CborObject> listValue() {
        return this.mList;
    }

    @Override
    public boolean isIndefiniteLength() {
        return this.mIsIndefiniteLength;
    }

    @Override
    public int getAdditionalInformation() {
        if (this.mAdditionalInfo == null) {
            return super.getAdditionalInformation();
        }
        return this.mAdditionalInfo;
    }
}

