/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborByteString;
import it.unimi.dsi.fastutil.BigArrays;
import org.checkerframework.checker.nullness.qual.Nullable;

final class CborByteStringImpl
extends CborByteString {
    private final byte[][] mByteValue;
    private final int mTag;
    private final boolean mIsIndefiniteLength;
    private final @Nullable Integer mAdditionalInfo;

    @Override
    public int getTag() {
        return this.mTag;
    }

    CborByteStringImpl(byte[][] array, long offset, long length, int tag, @Nullable Integer additionalInfo) {
        this.mTag = tag;
        this.mByteValue = BigArrays.copy((byte[][])array, (long)offset, (long)length);
        this.mIsIndefiniteLength = false;
        this.mAdditionalInfo = additionalInfo;
    }

    CborByteStringImpl(byte[][] array, int tag, boolean isIndefiniteLength, @Nullable Integer additionalInfo) {
        this.mTag = tag;
        this.mByteValue = array;
        this.mIsIndefiniteLength = isIndefiniteLength;
        this.mAdditionalInfo = additionalInfo;
    }

    @Override
    public byte[][] byteArrayValue() {
        return this.mByteValue;
    }

    @Override
    public boolean isIndefiniteLength() {
        return this.mIsIndefiniteLength;
    }

    @Override
    public int getAdditionalInformation() {
        if (this.mAdditionalInfo == null) {
            return super.getAdditionalInformation();
        }
        return this.mAdditionalInfo;
    }
}

