/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborByteString;
import com.google.iot.cbor.CborInteger;
import com.google.iot.cbor.CborTag;
import java.math.BigInteger;
import javax.annotation.Nullable;

final class CborIntegerImpl
extends CborInteger {
    private final BigInteger mValue;
    private final int mTag;
    private final Integer mMajorType;
    private final Byte mAdditionalInfo;
    private final CborByteString mByteString;

    @Override
    public int getTag() {
        return this.mTag;
    }

    CborIntegerImpl(BigInteger value, int tag, @Nullable Integer majorType, @Nullable Byte additionalInfo) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        if (value.compareTo(CborInteger.BI_MAX_8B) > 0) {
            byte[] bytes = value.toByteArray();
            this.mByteString = CborByteString.create(bytes, 0, bytes.length, 2);
        } else if (value.compareTo(CborInteger.BI_MIN_8B) < 0) {
            byte[] bytes = value.negate().subtract(BigInteger.ONE).toByteArray();
            this.mByteString = CborByteString.create(bytes, 0, bytes.length, 3);
        } else {
            this.mByteString = null;
        }
        this.mTag = tag;
        this.mValue = value;
        this.mMajorType = majorType;
        this.mAdditionalInfo = additionalInfo;
    }

    CborIntegerImpl(CborByteString bigNum) {
        if (bigNum.getTag() != 2 && bigNum.getTag() != 3) {
            throw new IllegalArgumentException("Invalid tag value " + bigNum.getTag());
        }
        this.mTag = -1;
        this.mValue = bigNum.getTag() == 2 ? new BigInteger(bigNum.byteArrayValue()[0]) : BigInteger.valueOf(-1L).subtract(new BigInteger(bigNum.byteArrayValue()[0]));
        this.mMajorType = null;
        this.mAdditionalInfo = null;
        this.mByteString = bigNum;
    }

    @Override
    public int getMajorType() {
        if (this.mMajorType != null) {
            return this.mMajorType;
        }
        return super.getMajorType();
    }

    @Override
    public long longValue() {
        return this.mValue.longValue();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.mValue;
    }

    @Override
    public CborByteString byteString() {
        return this.mByteString;
    }

    @Override
    public int getAdditionalInformation() {
        if (this.mAdditionalInfo != null) {
            return this.mAdditionalInfo.byteValue();
        }
        return super.getAdditionalInformation();
    }
}

