/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.iot.cbor.CborArray;
import com.google.iot.cbor.CborConversionException;
import com.google.iot.cbor.CborInteger;
import com.google.iot.cbor.CborMapImpl;
import com.google.iot.cbor.CborObject;
import com.google.iot.cbor.CborParseException;
import com.google.iot.cbor.CborRuntimeException;
import com.google.iot.cbor.CborSimple;
import com.google.iot.cbor.CborTextString;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class CborMap
extends CborObject {
    CborMap() {
    }

    public static CborMap createFromCborByteArray(byte[] input, int offset, int length) throws CborParseException {
        CborObject obj = CborObject.createFromCborByteArray(input, offset, length);
        if (obj instanceof CborMap) {
            return (CborMap)obj;
        }
        throw new CborParseException("Not a map");
    }

    public static CborMap createFromCborByteArray(byte[] input) throws CborParseException {
        return CborMap.createFromCborByteArray(input, 0, input.length);
    }

    public static CborMap createFromJavaObject(Map<?, ?> obj) throws CborConversionException {
        CborMap map = CborMap.create();
        for (Map.Entry<?, ?> entry : obj.entrySet()) {
            map.mapValue().add(new AbstractMap.SimpleEntry<CborObject, CborObject>(CborObject.createFromJavaObject(entry.getKey()), CborObject.createFromJavaObject(entry.getValue())));
        }
        return map;
    }

    public static CborMap create(int tag) {
        return new CborMapImpl(tag);
    }

    public static CborMap create(Map<CborObject, CborObject> map, int tag) {
        return new CborMapImpl(map, tag);
    }

    public static CborMap create(@Nullable Map<CborObject, CborObject> map, int tag, boolean isIndefiniteLength, @Nullable Integer additionalInfo) {
        return new CborMapImpl(map, tag, isIndefiniteLength, additionalInfo);
    }

    public static CborMap create(Map<CborObject, CborObject> map) {
        return CborMap.create(map, -1);
    }

    public static CborMap createFromJSONObject(JSONObject obj) {
        CborMap map = CborMap.create();
        for (String key : obj.keySet()) {
            CborObject value;
            if (obj.isNull(key)) {
                value = CborSimple.NULL;
            } else {
                Object rawValue = obj.get(key);
                if (rawValue instanceof JSONArray) {
                    value = CborArray.createFromJSONArray((JSONArray)rawValue);
                } else if (rawValue instanceof JSONObject) {
                    value = CborMap.createFromJSONObject((JSONObject)rawValue);
                } else {
                    try {
                        value = CborObject.createFromJavaObject(rawValue);
                    }
                    catch (CborConversionException x) {
                        throw new CborRuntimeException(x);
                    }
                }
            }
            map.put(key, value);
        }
        return map;
    }

    public static CborMap create() {
        return CborMap.create(-1);
    }

    public abstract List<Map.Entry<CborObject, CborObject>> mapValue();

    public abstract void resetAdditionalInfo();

    public int size() {
        return this.mapValue().size();
    }

    public boolean isEmpty() {
        return this.mapValue().isEmpty();
    }

    @CanIgnoreReturnValue
    public @Nullable CborObject remove(CborObject key) {
        ArrayList<Map.Entry<CborObject, CborObject>> toRemove = new ArrayList<Map.Entry<CborObject, CborObject>>();
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue()) {
            if (!entry.getKey().equals(key)) continue;
            toRemove.add(entry);
        }
        if (this.mapValue().removeAll(toRemove)) {
            this.resetAdditionalInfo();
            return key;
        }
        return null;
    }

    public void clear() {
        this.mapValue().clear();
        this.resetAdditionalInfo();
    }

    public Set<Map.Entry<CborObject, CborObject>> entrySet() {
        return new HashSet<Map.Entry<CborObject, CborObject>>(this.mapValue());
    }

    public Set<CborObject> keySet() {
        HashSet<CborObject> keySet = new HashSet<CborObject>();
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue()) {
            keySet.add(entry.getKey());
        }
        return keySet;
    }

    public @Nullable CborObject get(CborObject key) {
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue()) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public final @Nullable CborObject get(String key) {
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue()) {
            if (!(entry.getKey() instanceof CborTextString) || !((CborTextString)entry.getKey()).stringValue().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public final boolean containsKey(String key) {
        return this.get(key) != null;
    }

    @CanIgnoreReturnValue
    public final @Nullable CborObject put(String key, CborObject value) {
        CborObject previousValue = this.get(key);
        if (previousValue != null) {
            this.remove(key);
        }
        this.mapValue().add(new AbstractMap.SimpleEntry<CborTextString, CborObject>(CborTextString.create(key), value));
        this.resetAdditionalInfo();
        return previousValue;
    }

    @CanIgnoreReturnValue
    public final @Nullable CborObject put(CborObject key, CborObject value) {
        CborObject previousValue = this.get(key);
        if (previousValue != null) {
            this.remove(key);
        }
        this.mapValue().add(new AbstractMap.SimpleEntry<CborObject, CborObject>(key, value));
        this.resetAdditionalInfo();
        return previousValue;
    }

    @CanIgnoreReturnValue
    public final @Nullable CborObject remove(String key) {
        ArrayList<Map.Entry<CborObject, CborObject>> toRemove = new ArrayList<Map.Entry<CborObject, CborObject>>();
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue()) {
            if (!(entry.getKey() instanceof CborTextString) || !((CborTextString)entry.getKey()).stringValue().equals(key)) continue;
            toRemove.add(entry);
        }
        if (this.mapValue().removeAll(toRemove)) {
            this.resetAdditionalInfo();
            return (CborObject)((Map.Entry)toRemove.getFirst()).getValue();
        }
        return null;
    }

    public final Set<String> keySetAsStrings() throws CborConversionException {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue()) {
            if (entry.getKey() instanceof CborTextString) {
                ret.add(((CborTextString)entry.getKey()).stringValue());
                continue;
            }
            throw new CborConversionException("Key is not a string");
        }
        return ret;
    }

    public final boolean areAllKeysStrings() {
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue()) {
            if (entry.getKey() instanceof CborTextString) continue;
            return false;
        }
        return true;
    }

    public final Map<String, Object> toNormalMap() throws CborConversionException {
        if (!this.areAllKeysStrings()) {
            throw new CborConversionException("Not all keys are strings");
        }
        return this.toJavaObject();
    }

    @Override
    public final int getMajorType() {
        return 5;
    }

    @Override
    public int getAdditionalInformation() {
        return CborInteger.calcAdditionalInformation(BigInteger.valueOf(this.mapValue().size()));
    }

    public abstract boolean isIndefiniteLength();

    @Override
    public final Map<Object, Object> toJavaObject() {
        LinkedHashMap<Object, Object> ret = new LinkedHashMap<Object, Object>();
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue()) {
            ret.put(entry.getKey().toJavaObject(), entry.getValue().toJavaObject());
        }
        return ret;
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) throws CborConversionException {
        if (clazz.isAssignableFrom(Map.class)) {
            LinkedHashMap<Object, Object> ret = new LinkedHashMap<Object, Object>();
            for (Map.Entry<CborObject, CborObject> entry : this.mapValue()) {
                ret.put(entry.getKey().toJavaObject(Object.class), entry.getValue().toJavaObject(Object.class));
            }
            return clazz.cast(ret);
        }
        throw new CborConversionException(String.valueOf(clazz) + " is not assignable from map");
    }

    @Override
    public final CborMap copy() {
        CborMap ret = CborMap.create(this.getTag());
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue()) {
            ret.mapValue().add(new AbstractMap.SimpleEntry<CborObject, CborObject>(entry.getKey().copy(), entry.getValue().copy()));
        }
        return ret;
    }

    @Override
    public final boolean isValidJson() {
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue()) {
            if (!(entry.getKey() instanceof CborTextString)) {
                return false;
            }
            if (entry.getValue().isValidJson()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final String toJsonString() {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (entry.getKey() instanceof CborTextString) {
                sb.append(entry.getKey().toJsonString());
            } else {
                sb.append(JSONObject.quote((String)entry.getKey().toJsonString()));
            }
            sb.append(":");
            sb.append(entry.getValue().toJsonString());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        return Integer.hashCode(this.getTag()) * 1337 + this.mapValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CborMap)) {
            return false;
        }
        CborMap rhs = (CborMap)obj;
        return rhs.getTag() == this.getTag() && this.mapValue().equals(rhs.mapValue());
    }

    @Override
    public String toString(int indentLevel) {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        if (indentLevel >= 0) {
            ++indentLevel;
        }
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (indentLevel >= 0) {
                sb.append("\n");
                for (int i = 0; i < indentLevel; ++i) {
                    sb.append("\t");
                }
            }
            sb.append(entry.getKey().toString(indentLevel));
            sb.append(":");
            sb.append(entry.getValue().toString(indentLevel));
        }
        if (!this.isEmpty() && indentLevel > 0) {
            --indentLevel;
            sb.append("\n");
            for (int i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
        }
        sb.append("}");
        int tag = this.getTag();
        return tag == -1 ? sb.toString() : tag + "(" + sb.toString() + ")";
    }
}

