/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborMap;
import com.google.iot.cbor.CborObject;
import com.google.iot.cbor.CborTag;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

final class CborMapImpl
extends CborMap {
    private final List<Map.Entry<CborObject, CborObject>> mMap;
    private int mTag;
    private boolean mIsIndefiniteLength;
    private @Nullable Integer mAdditionalInfo;

    CborMapImpl(int tag) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        this.mMap = new LinkedList<Map.Entry<CborObject, CborObject>>();
        this.mTag = tag;
        this.mIsIndefiniteLength = false;
        this.mAdditionalInfo = null;
    }

    CborMapImpl(Map<CborObject, CborObject> map, int tag) {
        this(tag);
        this.mMap.addAll(map.entrySet());
        this.mIsIndefiniteLength = false;
        this.mAdditionalInfo = null;
    }

    CborMapImpl(@Nullable Map<CborObject, CborObject> map, int tag, boolean isIndefiniteLength, @Nullable Integer additionalInfo) {
        this(tag);
        if (map != null) {
            this.mMap.addAll(map.entrySet());
        }
        this.mIsIndefiniteLength = isIndefiniteLength;
        this.mAdditionalInfo = additionalInfo;
    }

    @Override
    public int getTag() {
        return this.mTag;
    }

    @Override
    public List<Map.Entry<CborObject, CborObject>> mapValue() {
        return this.mMap;
    }

    @Override
    public boolean isIndefiniteLength() {
        return this.mIsIndefiniteLength;
    }

    @Override
    public int getAdditionalInformation() {
        if (this.mAdditionalInfo == null) {
            return super.getAdditionalInformation();
        }
        return this.mAdditionalInfo;
    }

    @Override
    public void resetAdditionalInfo() {
        this.mAdditionalInfo = null;
    }
}

