/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborConversionException;
import com.google.iot.cbor.CborInteger;
import com.google.iot.cbor.CborObject;
import com.google.iot.cbor.CborTextStringImpl;
import it.unimi.dsi.fastutil.BigArrays;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.json.JSONObject;

public abstract class CborTextString
extends CborObject {
    CborTextString() {
    }

    public static CborTextString create(byte[][] arrays, int[] offsets, int[] lengths, int tag, boolean isIndefiniteLength, @Nullable Integer additionalInfo) {
        return new CborTextStringImpl(arrays, offsets, lengths, tag, isIndefiniteLength, additionalInfo);
    }

    public static CborTextString create(byte[] array, int offset, int length, int tag, boolean isIndefiniteLength, @Nullable Integer additionalInfo) {
        byte[][] arrays = new byte[][]{array};
        int[] offsets = new int[]{offset};
        int[] lengths = new int[]{length};
        return new CborTextStringImpl(arrays, offsets, lengths, tag, isIndefiniteLength, additionalInfo);
    }

    public static CborTextString create(byte[] array, int offset, int length) {
        byte[][] arrays = new byte[][]{array};
        int[] offsets = new int[]{offset};
        int[] lengths = new int[]{length};
        return new CborTextStringImpl(arrays, offsets, lengths, -1, false, null);
    }

    public static CborTextString create(byte[] array) {
        return CborTextString.create(array, 0, array.length);
    }

    public static CborTextString create(String string, int tag) {
        return new CborTextStringImpl(string, tag);
    }

    public static CborTextString create(String string) {
        return new CborTextStringImpl(string, -1);
    }

    public abstract String stringValue();

    public abstract byte[][] byteArrayValue();

    @Override
    public final int getMajorType() {
        return 3;
    }

    @Override
    public int getAdditionalInformation() {
        return CborInteger.calcAdditionalInformation(BigInteger.valueOf(BigArrays.length((byte[][])this.byteArrayValue())));
    }

    public abstract boolean isIndefiniteLength();

    @Override
    public final boolean isValidJson() {
        return true;
    }

    @Override
    public CborTextString copy() {
        return this;
    }

    @Override
    public final String toJsonString() {
        return JSONObject.quote((String)this.stringValue()).replaceAll("\\\\/", "/");
    }

    @Override
    public String toJavaObject() {
        return this.stringValue();
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) throws CborConversionException {
        CborConversionException lastException = null;
        switch (this.getTag()) {
            case 32: {
                if (!clazz.isAssignableFrom(URI.class)) break;
                try {
                    return clazz.cast(new URI(this.stringValue()));
                }
                catch (URISyntaxException e) {
                    lastException = new CborConversionException(e);
                    break;
                }
            }
        }
        if (clazz.isAssignableFrom(String.class)) {
            return clazz.cast(this.stringValue());
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new CborConversionException(String.valueOf(clazz) + " is not assignable from a text string");
    }

    public int hashCode() {
        return (this.getTag() - -1) * 1337 + this.stringValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CborTextString)) {
            return false;
        }
        CborTextString rhs = (CborTextString)obj;
        return this.getTag() == rhs.getTag() && this.stringValue().equals(rhs.stringValue());
    }

    @Override
    public String toString(int ignore) {
        return this.toString();
    }

    @Override
    public String toString() {
        String ret = this.toJsonString();
        int tag = this.getTag();
        return tag == -1 ? ret : tag + "(" + ret + ")";
    }
}

