/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborTag;
import com.google.iot.cbor.CborTextString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

final class CborTextStringImpl
extends CborTextString {
    private final String mValue;
    private final byte[][] mByteValue;
    private final int mTag;
    private final boolean mIsIndefiniteLength;
    private final @Nullable Integer mAdditionalInfo;

    @Override
    public int getTag() {
        return this.mTag;
    }

    CborTextStringImpl(String value, int tag) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        this.mTag = tag;
        this.mValue = value;
        this.mByteValue = new byte[1][];
        this.mByteValue[0] = this.mValue.getBytes(StandardCharsets.UTF_8);
        this.mIsIndefiniteLength = false;
        this.mAdditionalInfo = null;
    }

    CborTextStringImpl(byte[][] array, int[] offset, int[] length, int tag, boolean isIndefiniteLength, @Nullable Integer additionalInfo) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        this.mTag = tag;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.mByteValue = new byte[array.length][];
        for (int i = 0; i < array.length; ++i) {
            this.mByteValue[i] = Arrays.copyOfRange(array[i], offset[i], offset[i] + length[i]);
            try {
                baos.write(this.mByteValue[i]);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.mValue = baos.toString(StandardCharsets.UTF_8);
        this.mIsIndefiniteLength = isIndefiniteLength;
        this.mAdditionalInfo = additionalInfo;
    }

    @Override
    public String stringValue() {
        return this.mValue;
    }

    @Override
    public byte[][] byteArrayValue() {
        return this.mByteValue;
    }

    @Override
    public boolean isIndefiniteLength() {
        return this.mIsIndefiniteLength;
    }

    @Override
    public int getAdditionalInformation() {
        if (this.mAdditionalInfo == null) {
            return super.getAdditionalInformation();
        }
        return this.mAdditionalInfo;
    }
}

