/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.iot.cbor.CborObject;
import com.google.iot.cbor.CborWriterImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public interface CborWriter {
    public static CborWriter createFromOutputStream(OutputStream outputStream) {
        return new CborWriterImpl(outputStream);
    }

    public static CborWriter createFromByteBuffer(ByteBuffer byteBuffer) {
        return new CborWriterImpl(byteBuffer);
    }

    public static int length(CborObject obj) {
        return CborWriterImpl.length(obj);
    }

    @CanIgnoreReturnValue
    public CborWriter writeDataItem(CborObject var1) throws IOException;

    @CanIgnoreReturnValue
    public CborWriter writeTag(int var1) throws IOException;
}

