/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.iot.cbor.CborArray;
import com.google.iot.cbor.CborByteString;
import com.google.iot.cbor.CborFloat;
import com.google.iot.cbor.CborInteger;
import com.google.iot.cbor.CborMap;
import com.google.iot.cbor.CborObject;
import com.google.iot.cbor.CborRuntimeException;
import com.google.iot.cbor.CborSimple;
import com.google.iot.cbor.CborTextString;
import com.google.iot.cbor.CborWriter;
import com.google.iot.cbor.EncoderStream;
import it.unimi.dsi.fastutil.BigArrays;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;

class CborWriterImpl
implements CborWriter {
    private static final byte BREAK = -1;
    private final EncoderStream mEncoderStream;

    CborWriterImpl(OutputStream outputStream) {
        this.mEncoderStream = EncoderStream.create(outputStream);
    }

    CborWriterImpl(ByteBuffer byteBuffer) {
        this.mEncoderStream = EncoderStream.create(byteBuffer);
    }

    private CborWriterImpl() {
        this.mEncoderStream = EncoderStream.create();
    }

    static int length(CborObject obj) {
        int ret = 0;
        try {
            ret = new CborWriterImpl().writeDataItem((CborObject)obj).mEncoderStream.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    private void writeCborHeader(int majorType, int val) throws IOException {
        this.mEncoderStream.put((byte)((majorType << 5) + (val & 0x1F)));
    }

    private void writeCborFullInteger(int majorType, BigInteger val) throws IOException {
        this.writeCborFullInteger(majorType, val, CborInteger.calcAdditionalInformation(val));
    }

    private void writeCborFullInteger(int majorType, BigInteger val, int ai) throws IOException {
        if (val.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("val cannot be negative");
        }
        this.writeCborHeader(majorType, ai);
        switch (ai) {
            case 24: {
                this.mEncoderStream.put(val.byteValue());
                break;
            }
            case 25: {
                this.mEncoderStream.putShort(val.shortValue());
                break;
            }
            case 26: {
                this.mEncoderStream.putInt(val.intValue());
                break;
            }
            case 27: {
                this.mEncoderStream.putLong(val.longValue());
            }
        }
    }

    @Override
    @CanIgnoreReturnValue
    public CborWriter writeTag(int tag) throws IOException {
        if (tag != -1) {
            this.writeCborFullInteger(6, BigInteger.valueOf(tag));
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public CborWriterImpl writeDataItem(CborObject obj) throws IOException {
        this.writeTag(obj.getTag());
        CborObject cborObject = obj;
        Objects.requireNonNull(cborObject);
        CborObject cborObject2 = cborObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CborArray.class, CborFloat.class, CborInteger.class, CborMap.class, CborTextString.class, CborByteString.class, CborSimple.class}, (Object)cborObject2, n)) {
            case 0 -> {
                CborArray cborObjects = (CborArray)cborObject2;
                yield this.writeDataItem(cborObjects);
            }
            case 1 -> {
                CborFloat cborFloat = (CborFloat)cborObject2;
                yield this.writeDataItem(cborFloat);
            }
            case 2 -> {
                CborInteger cborInteger = (CborInteger)cborObject2;
                yield this.writeDataItem(cborInteger);
            }
            case 3 -> {
                CborMap cborMap = (CborMap)cborObject2;
                yield this.writeDataItem(cborMap);
            }
            case 4 -> {
                CborTextString cborTextString = (CborTextString)cborObject2;
                yield this.writeDataItem(cborTextString);
            }
            case 5 -> {
                CborByteString cborByteString = (CborByteString)cborObject2;
                yield this.writeDataItem(cborByteString);
            }
            case 6 -> {
                CborSimple cborSimple = (CborSimple)cborObject2;
                yield this.writeDataItem(cborSimple);
            }
            default -> throw new CborRuntimeException("Can't encode \"" + String.valueOf(obj) + "\" of type " + String.valueOf(obj.getClass()));
        };
    }

    @CanIgnoreReturnValue
    private CborWriterImpl writeDataItem(CborArray array) throws IOException {
        if (array.isIndefiniteLength()) {
            this.writeCborHeader(array.getMajorType(), 31);
        } else {
            this.writeCborFullInteger(array.getMajorType(), BigInteger.valueOf(array.size()), array.getAdditionalInformation());
        }
        for (CborObject obj : array) {
            this.writeDataItem(obj);
        }
        if (array.isIndefiniteLength()) {
            this.mEncoderStream.put((byte)-1);
        }
        return this;
    }

    @CanIgnoreReturnValue
    private CborWriterImpl writeDataItem(CborFloat obj) throws IOException {
        this.writeCborHeader(obj.getMajorType(), obj.getAdditionalInformation());
        switch (obj.getAdditionalInformation()) {
            case 25: {
                this.mEncoderStream.putHalf(obj.floatValue());
                break;
            }
            case 26: {
                this.mEncoderStream.putFloat(obj.floatValue());
                break;
            }
            case 27: {
                this.mEncoderStream.putDouble(obj.floatValue());
            }
        }
        return this;
    }

    @CanIgnoreReturnValue
    private CborWriterImpl writeDataItem(CborInteger obj) throws IOException {
        CborByteString byteString = obj.byteString();
        if (byteString != null) {
            this.writeDataItem((CborObject)byteString);
        } else {
            BigInteger val = obj.bigIntegerValue();
            if (val.compareTo(CborInteger.BI_MAX_8B) > 0) {
                byte[] bytes = val.toByteArray();
                this.writeDataItem(CborByteString.create(bytes, 0, bytes.length, 2));
            } else if (val.compareTo(CborInteger.BI_MIN_8B) < 0) {
                val = val.negate().subtract(BigInteger.ONE);
                byte[] bytes = val.toByteArray();
                this.writeDataItem(CborByteString.create(bytes, 0, bytes.length, 3));
            } else {
                if (val.compareTo(BigInteger.ZERO) < 0) {
                    val = val.negate().subtract(BigInteger.ONE);
                }
                this.writeCborFullInteger(obj.getMajorType(), val, obj.getAdditionalInformation());
            }
        }
        return this;
    }

    @CanIgnoreReturnValue
    private CborWriterImpl writeDataItem(CborMap map) throws IOException {
        if (map.isIndefiniteLength()) {
            this.writeCborHeader(map.getMajorType(), 31);
        } else {
            this.writeCborFullInteger(map.getMajorType(), BigInteger.valueOf(map.mapValue().size()), map.getAdditionalInformation());
        }
        for (Map.Entry<CborObject, CborObject> entry : map.mapValue()) {
            this.writeDataItem(entry.getKey());
            this.writeDataItem(entry.getValue());
        }
        if (map.isIndefiniteLength()) {
            this.mEncoderStream.put((byte)-1);
        }
        return this;
    }

    @CanIgnoreReturnValue
    private CborWriterImpl writeDataItem(CborSimple obj) throws IOException {
        this.writeCborFullInteger(obj.getMajorType(), BigInteger.valueOf(obj.getValue()));
        return this;
    }

    @CanIgnoreReturnValue
    private CborWriterImpl writeDataItem(CborByteString obj) throws IOException {
        if (obj.isIndefiniteLength()) {
            byte[][] chunks;
            this.writeCborHeader(obj.getMajorType(), 31);
            for (byte[] chunk : chunks = obj.byteArrayValue()) {
                this.writeCborFullInteger(2, BigInteger.valueOf(chunk.length));
                this.mEncoderStream.put(chunk);
            }
            this.mEncoderStream.put((byte)-1);
        } else {
            this.writeCborFullInteger(obj.getMajorType(), BigInteger.valueOf(BigArrays.length((byte[][])obj.byteArrayValue())), obj.getAdditionalInformation());
            this.mEncoderStream.put(obj.byteArrayValue());
        }
        return this;
    }

    @CanIgnoreReturnValue
    private CborWriterImpl writeDataItem(CborTextString obj) throws IOException {
        if (obj.isIndefiniteLength()) {
            byte[][] chunks;
            this.writeCborHeader(obj.getMajorType(), 31);
            for (byte[] chunk : chunks = obj.byteArrayValue()) {
                this.writeCborFullInteger(3, BigInteger.valueOf(chunk.length));
                this.mEncoderStream.put(chunk);
            }
            this.mEncoderStream.put((byte)-1);
        } else {
            this.writeCborFullInteger(obj.getMajorType(), BigInteger.valueOf(obj.byteArrayValue()[0].length), obj.getAdditionalInformation());
            this.mEncoderStream.put(obj.byteArrayValue());
        }
        return this;
    }
}

