/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.iot.cbor.DecoderStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class DecoderStream_InputStream
implements DecoderStream {
    private final InputStream mInputStream;
    private int mPeekedByte = -2;
    private boolean mDidPeek = false;
    private long mBytesParsed = 0L;

    DecoderStream_InputStream(InputStream inputStream) {
        this.mInputStream = inputStream;
    }

    @Override
    public long bytesParsed() {
        return this.mBytesParsed;
    }

    @Override
    @CanIgnoreReturnValue
    public int peek() throws IOException {
        if (this.mDidPeek) {
            return (byte)this.mPeekedByte;
        }
        this.mPeekedByte = this.mInputStream.read();
        this.mDidPeek = true;
        return this.mPeekedByte;
    }

    @Override
    public byte get() throws IOException {
        int readByte;
        if (this.mDidPeek) {
            this.mDidPeek = false;
            readByte = this.mPeekedByte;
        } else {
            readByte = this.mInputStream.read();
        }
        if (readByte < 0) {
            throw new EOFException("No more bytes in input stream");
        }
        ++this.mBytesParsed;
        return (byte)readByte;
    }

    @Override
    public short getShort() throws IOException {
        short ret = (short)((this.get() & 0xFF) << 8);
        ret = (short)(ret | (short)(this.get() & 0xFF));
        return ret;
    }

    @Override
    public int getInt() throws IOException {
        int ret = (this.get() & 0xFF) << 24;
        ret |= (this.get() & 0xFF) << 16;
        ret |= (this.get() & 0xFF) << 8;
        return ret |= this.get() & 0xFF;
    }

    @Override
    public long getLong() throws IOException {
        long ret = (long)(this.get() & 0xFF) << 56;
        ret |= (long)(this.get() & 0xFF) << 48;
        ret |= (long)(this.get() & 0xFF) << 40;
        ret |= (long)(this.get() & 0xFF) << 32;
        ret |= (long)(this.get() & 0xFF) << 24;
        ret |= (long)(this.get() & 0xFF) << 16;
        ret |= (long)(this.get() & 0xFF) << 8;
        return ret |= (long)this.get() & 0xFFL;
    }

    @Override
    public boolean hasRemaining() throws IOException {
        if (!this.mDidPeek) {
            this.peek();
        }
        return this.mPeekedByte >= 0;
    }
}

