/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.iot.cbor.EncoderStream_ByteBuffer;
import com.google.iot.cbor.EncoderStream_Empty;
import com.google.iot.cbor.EncoderStream_OutputStream;
import com.google.iot.cbor.Half;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

interface EncoderStream {
    public int length();

    @CanIgnoreReturnValue
    public EncoderStream put(byte var1) throws IOException;

    @CanIgnoreReturnValue
    public EncoderStream putShort(short var1) throws IOException;

    @CanIgnoreReturnValue
    public EncoderStream putInt(int var1) throws IOException;

    @CanIgnoreReturnValue
    public EncoderStream putLong(long var1) throws IOException;

    @CanIgnoreReturnValue
    default public EncoderStream put(byte[][] x) throws IOException {
        byte[][] byArray = x;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] ba;
            for (byte b : ba = byArray[i]) {
                this.put(b);
            }
        }
        return this;
    }

    @CanIgnoreReturnValue
    default public EncoderStream put(byte[] x) throws IOException {
        for (byte b : x) {
            this.put(b);
        }
        return this;
    }

    @CanIgnoreReturnValue
    default public EncoderStream putHalf(float x) throws IOException {
        return this.putShort(Half.floatToRawShortBits(x));
    }

    @CanIgnoreReturnValue
    default public EncoderStream putFloat(float x) throws IOException {
        return this.putInt(Float.floatToRawIntBits(x));
    }

    @CanIgnoreReturnValue
    default public EncoderStream putDouble(double x) throws IOException {
        return this.putLong(Double.doubleToRawLongBits(x));
    }

    public static EncoderStream create(OutputStream outputStream) {
        return new EncoderStream_OutputStream(outputStream);
    }

    public static EncoderStream create(ByteBuffer byteBuffer) {
        return new EncoderStream_ByteBuffer(byteBuffer);
    }

    public static EncoderStream create() {
        return new EncoderStream_Empty();
    }
}

