/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.EncoderStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

class EncoderStream_ByteBuffer
implements EncoderStream {
    private final ByteBuffer mByteBuffer;
    private int mLength = 0;

    EncoderStream_ByteBuffer(ByteBuffer byteBuffer) {
        this.mByteBuffer = byteBuffer;
    }

    @Override
    public int length() {
        return this.mLength;
    }

    @Override
    public EncoderStream put(byte x) throws IOException {
        try {
            this.mByteBuffer.put(x);
        }
        catch (IndexOutOfBoundsException | ReadOnlyBufferException e) {
            throw new IOException(e);
        }
        ++this.mLength;
        return this;
    }

    @Override
    public EncoderStream putShort(short x) throws IOException {
        try {
            this.mByteBuffer.putShort(x);
        }
        catch (IndexOutOfBoundsException | ReadOnlyBufferException e) {
            throw new IOException(e);
        }
        this.mLength += 2;
        return this;
    }

    @Override
    public EncoderStream putInt(int x) throws IOException {
        try {
            this.mByteBuffer.putInt(x);
        }
        catch (IndexOutOfBoundsException | ReadOnlyBufferException e) {
            throw new IOException(e);
        }
        this.mLength += 4;
        return this;
    }

    @Override
    public EncoderStream putLong(long x) throws IOException {
        try {
            this.mByteBuffer.putLong(x);
        }
        catch (IndexOutOfBoundsException | ReadOnlyBufferException e) {
            throw new IOException(e);
        }
        this.mLength += 8;
        return this;
    }
}

