/*
 * Decompiled with CFR 0.152.
 */
package nextflow.util;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.ToString;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

@ToString(includeNames=true, includeFields=true)
public class CsvParser
implements GroovyObject {
    private static final char COMMA;
    private char quote;
    private char separator;
    private String empty;
    private boolean strip;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public CsvParser() {
        MetaClass metaClass;
        char c;
        this.separator = c = COMMA;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public CsvParser setQuote(char ch) {
        char c;
        this.quote = c = ch;
        return this;
    }

    public CsvParser setQuote(String ch) {
        char c;
        this.quote = c = CsvParser.firstChar(ch);
        return this;
    }

    public CsvParser setSeparator(char ch) {
        char c;
        char c2 = ch;
        this.separator = c = c2 != '\u0000' ? c2 : COMMA;
        return this;
    }

    public CsvParser setSeparator(String ch) {
        char c;
        char c2 = CsvParser.firstChar(ch);
        this.separator = c = c2 != '\u0000' ? c2 : COMMA;
        return this;
    }

    public CsvParser setStrip(boolean value) {
        boolean bl;
        this.strip = bl = value;
        return this;
    }

    private static char firstChar(String str) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)str)) {
            return (char)0;
        }
        if (StringGroovyMethods.size((String)str) > 1) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{str}, new String[]{"Not a valid CVS character: ", ""})));
        }
        return str.charAt(0);
    }

    public List<String> parse(String line) {
        List result = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        while (line != null) {
            String string;
            if (!DefaultTypeTransformation.booleanUnbox((Object)line)) {
                result.add(this.empty);
                break;
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)Character.valueOf(this.quote)) && line.charAt(0) == this.quote) {
                String string2;
                line = string2 = this.readQuotedValue(line, result);
                continue;
            }
            line = string = this.readSimpleValue(line, result);
        }
        return result;
    }

    private String readSimpleValue(String line, List<String> result) {
        int p = line.indexOf(this.separator);
        if (ScriptBytecodeAdapter.compareEqual((Object)p, (Object)-1)) {
            result.add(this.stripBlanks(line));
            return ShortTypeHandling.castToString(null);
        }
        String string = this.stripBlanks(line.substring(0, p));
        result.add(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : this.empty);
        return line.substring(p + 1);
    }

    private String readQuotedValue(String line, List<String> result) {
        String value = line.substring(1);
        int p = value.indexOf(this.quote);
        if (ScriptBytecodeAdapter.compareEqual((Object)p, (Object)-1)) {
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{line}, new String[]{"Missing double-quote termination in CSV value -- offending line: ", ""})));
        }
        result.add(this.stripBlanks(value.substring(0, p)));
        int next = p + 1;
        if (next < StringGroovyMethods.size((String)value)) {
            if (value.charAt(next) != this.separator) {
                throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{line}, new String[]{"Invalid CSV value -- offending line: ", ""})));
            }
            return value.substring(next + 1);
        }
        return ShortTypeHandling.castToString(null);
    }

    String stripBlanks(String str) {
        String value = this.strip ? StringUtils.strip((String)str) : str;
        if (!(this.quote != '\u0000')) {
            return value;
        }
        if (value.length() > 1 && value.charAt(0) == this.quote && value.charAt(StringGroovyMethods.size((String)value) - 1) == this.quote) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CsvParser.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("nextflow.util.CsvParser(");
        Boolean bl = $toStringFirst;
        if (bl == null ? false : bl) {
            Boolean bl2;
            $toStringFirst = bl2 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("quote:");
        _result.append(InvokerHelper.toString((Object)Character.valueOf(this.quote)));
        Boolean bl3 = $toStringFirst;
        if (bl3 == null ? false : bl3) {
            Boolean bl4;
            $toStringFirst = bl4 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("separator:");
        _result.append(InvokerHelper.toString((Object)Character.valueOf(this.separator)));
        Boolean bl5 = $toStringFirst;
        if (bl5 == null ? false : bl5) {
            Boolean bl6;
            $toStringFirst = bl6 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("empty:");
        _result.append(InvokerHelper.toString((Object)this.empty));
        Boolean bl7 = $toStringFirst;
        if (bl7 == null ? false : bl7) {
            Boolean bl8;
            $toStringFirst = bl8 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("strip:");
        _result.append(InvokerHelper.toString((Object)this.strip));
        _result.append(")");
        return _result.toString();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        char c;
        COMMA = c = DefaultTypeTransformation.charUnbox((Object)ScriptBytecodeAdapter.asType((Object)",", Character.TYPE));
    }
}

