/*
 * Decompiled with CFR 0.152.
 */
package nextflow.file;

import com.google.common.hash.HashCode;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nextflow.Global;
import nextflow.ISession;
import nextflow.extension.Bolts;
import nextflow.extension.FilesEx;
import nextflow.file.CopyMoveHelper;
import nextflow.file.FilePatternSplitter;
import nextflow.file.FileSystemPathFactory;
import nextflow.file.Globs;
import nextflow.plugin.Plugins;
import nextflow.util.CacheHelper;
import nextflow.util.Escape;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHelper
implements GroovyObject {
    public static final Pattern URL_PROTOCOL;
    private static final Path localTempBasePath;
    private static Random rndGen;
    public static final char[] ALPHA;
    private static List<String> UNSUPPORTED_GLOB_WILDCARDS;
    private static LinkOption[] NO_FOLLOW_LINKS;
    private static LinkOption[] FOLLOW_LINKS;
    private static Map<String, String> PLUGINS_MAP;
    private static final Map<String, Boolean> SCHEME_CHECKED;
    static final Map<String, FileSystemProvider> providersMap;
    private static Lock _fs_lock;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static final Closure memoizedMethodClosure$getWorkDirFileSystem;
    private static final Closure memoizedMethodClosure$isPathNFSPath;
    private static final Closure memoizedMethodClosure$getPathFsTypePath;
    private static final Closure memoizedMethodClosure$envForString;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public FileHelper() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        Closure closure;
        Closure closure2;
        Closure closure3;
        Closure closure4;
        Logger logger;
        Map map;
        Map map2;
        List list;
        Random random;
        Object object = ScriptBytecodeAdapter.bitwiseNegate((Object)"^([a-zA-Z][a-zA-Z0-9]*)\\:\\/\\/.+");
        URL_PROTOCOL = (Pattern)ScriptBytecodeAdapter.castToType((Object)object, Pattern.class);
        rndGen = random = new Random();
        char[] cArray = (char[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createRange((Object)"a", (Object)"z", (boolean)true), char[].class);
        ALPHA = cArray;
        UNSUPPORTED_GLOB_WILDCARDS = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"http", "https", "ftp", "ftps"});
        LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        NO_FOLLOW_LINKS = linkOptionArray;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        FOLLOW_LINKS = linkOptionArray2;
        PLUGINS_MAP = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"s3", "nf-amazon", "gs", "nf-google", "az", "nf-azure"});
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        SCHEME_CHECKED = hashMap;
        providersMap = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ReentrantLock reentrantLock = new ReentrantLock();
        _fs_lock = reentrantLock;
        log = logger = LoggerFactory.getLogger((String)"nextflow.file.FileHelper");
        public final class __clinit__closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public FileSystem doCall(Object it) {
                return FileHelper.memoizedMethodPriv$getWorkDirFileSystem();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public FileSystem doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        memoizedMethodClosure$getWorkDirFileSystem = closure4 = new __clinit__closure1(FileHelper.class, FileHelper.class).memoize();
        public final class __clinit__closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Path path) {
                return FileHelper.memoizedMethodPriv$isPathNFSPath(path);
            }

            @Generated
            public Boolean call(Path path) {
                return this.doCall(path);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        memoizedMethodClosure$isPathNFSPath = closure3 = new __clinit__closure2(FileHelper.class, FileHelper.class).memoize();
        public final class __clinit__closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Path path) {
                return FileHelper.memoizedMethodPriv$getPathFsTypePath(path);
            }

            @Generated
            public String call(Path path) {
                return this.doCall(path);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        memoizedMethodClosure$getPathFsTypePath = closure2 = new __clinit__closure3(FileHelper.class, FileHelper.class).memoize();
        public final class __clinit__closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Map doCall(String scheme) {
                return FileHelper.memoizedMethodPriv$envForString(scheme);
            }

            @Generated
            public Map call(String scheme) {
                return this.doCall(scheme);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        memoizedMethodClosure$envForString = closure = new __clinit__closure4(FileHelper.class, FileHelper.class).memoize();
        String temp = System.getenv("NXF_TEMP");
        if (DefaultTypeTransformation.booleanUnbox((Object)temp)) {
            Object v0;
            Path path;
            localTempBasePath = path = Paths.get(temp, new String[0]);
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{localTempBasePath}, new String[]{"Using NXF_TEMP=", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
        } else {
            Path path;
            String string;
            temp = string = System.getProperty("java.io.tmpdir");
            if (!DefaultTypeTransformation.booleanUnbox((Object)temp)) {
                throw (Throwable)new IllegalStateException("Missing system temporary directory -- You can specify it using the NXF_TEMP environment variable");
            }
            localTempBasePath = path = Paths.get(temp, new String[0]);
        }
        if (!Files.exists(localTempBasePath, new LinkOption[0])) {
            Files.createDirectories(localTempBasePath, new FileAttribute[0]);
        }
    }

    public static String normalizePath(String path) {
        if (ScriptBytecodeAdapter.compareEqual((Object)path, (Object)Character.valueOf('~'))) {
            Object object = DefaultGroovyMethods.getAt((Map)System.getProperties(), (Object)"user.home");
            path = ShortTypeHandling.castToString((Object)object);
        } else if (path.startsWith("~/")) {
            String string;
            path = string = StringGroovyMethods.plus((String)DefaultGroovyMethods.toString((Object)DefaultGroovyMethods.getAt((Map)System.getProperties(), (Object)"user.home")), (CharSequence)StringGroovyMethods.getAt((String)path, (IntRange)new IntRange(true, 1, Integer.valueOf(-1).intValue())));
        }
        return path;
    }

    public static String randomString(int len, char ... alphabet) {
        Reference alphabet2 = new Reference((Object)alphabet);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            char[] cArray = (char[])alphabet2.get();
            valueRecorder.record((Object)cArray, 8);
            int n = DefaultGroovyMethods.size((char[])cArray);
            valueRecorder.record((Object)n, 17);
            boolean bl = n > 0;
            valueRecorder.record((Object)bl, 24);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert alphabet.size() > 0", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        Reference result = new Reference((Object)new StringBuilder());
        Reference max = new Reference((Object)DefaultGroovyMethods.size((char[])((char[])alphabet2.get())));
        public final class _randomString_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference max;
            private /* synthetic */ Reference result;
            private /* synthetic */ Reference alphabet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _randomString_closure5(Object _outerInstance, Object _thisObject, Reference max, Reference result, Reference alphabet) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.max = reference3 = max;
                this.result = reference2 = result;
                this.alphabet = reference = alphabet;
            }

            public StringBuilder doCall(Object it) {
                int index = FileHelper.pfaccess$0(null).nextInt(DefaultTypeTransformation.intUnbox((Object)this.max.get()));
                return ((StringBuilder)this.result.get()).append(BytecodeInterface8.cArrayGet((char[])((char[])ScriptBytecodeAdapter.castToType((Object)this.alphabet.get(), char[].class)), (int)index));
            }

            @Generated
            public Object getMax() {
                return this.max.get();
            }

            @Generated
            public StringBuilder getResult() {
                return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.result.get(), StringBuilder.class);
            }

            @Generated
            public char[] getAlphabet() {
                return (char[])ScriptBytecodeAdapter.castToType((Object)this.alphabet.get(), char[].class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public StringBuilder doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _randomString_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.times((Number)len, (Closure)new _randomString_closure5(FileHelper.class, FileHelper.class, max, result, alphabet2));
        return ((StringBuilder)result.get()).toString();
    }

    public static String randomString(int len) {
        return FileHelper.randomString(len, ALPHA);
    }

    public static List nameParts(String name) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = name;
            valueRecorder.record((Object)string, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)string)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert name", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        if (StringGroovyMethods.isLong((CharSequence)name)) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[]{"", StringGroovyMethods.toLong((CharSequence)name)});
        }
        Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)name, (Object)"^(\\S*)?(\\D)(\\d+)$"), Matcher.class);
        if (matcher.matches()) {
            Object[] entries = (String[])ScriptBytecodeAdapter.castToType((Object)StringGroovyMethods.getAt((Matcher)matcher, (int)0), String[].class);
            return ScriptBytecodeAdapter.createList((Object[])new Object[]{StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])entries, (int)1)), (CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])entries, (int)2), CharSequence.class))), StringGroovyMethods.toInteger((CharSequence)((String)BytecodeInterface8.objectArrayGet((Object[])entries, (int)3)).toString())});
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{name, 0});
    }

    public static boolean empty(File file) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            File file2 = file;
            valueRecorder.record((Object)file2, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)file2)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert file", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        return FileHelper.empty(file.toPath());
    }

    public static boolean empty(Path path) {
        BasicFileAttributes attrs;
        block9: {
            attrs = null;
            try {
                BasicFileAttributes basicFileAttributes;
                attrs = basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException e) {
                boolean bl = true;
                return bl;
            }
            if (!attrs.isDirectory()) break block9;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                Iterator<Path> itr = stream.iterator();
                boolean bl = !itr.hasNext();
                return bl;
            }
        }
        return attrs.size() == (long)0;
    }

    public static final Path getWorkFolder(Path bashPath, HashCode hash) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Path path = bashPath;
            valueRecorder.record((Object)path, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)path)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert bashPath", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            HashCode hashCode = hash;
            valueRecorder2.record((Object)hashCode, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)hashCode)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert hash", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        String str = hash.toString();
        String bucket = str.substring(0, 2);
        Path folder = bashPath.resolve(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{bucket, str.substring(2)}, new String[]{"", "/", ""})));
        return folder.toAbsolutePath();
    }

    public static final Path createTempFolder(Path basePath) {
        Path result;
        block6: {
            ValueRecorder valueRecorder = new ValueRecorder();
            try {
                Path path = basePath;
                valueRecorder.record((Object)path, 8);
                if (DefaultTypeTransformation.booleanUnbox((Object)path)) {
                    valueRecorder.clear();
                } else {
                    ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert basePath", (ValueRecorder)valueRecorder), null);
                }
            }
            catch (Throwable throwable) {
                valueRecorder.clear();
                throw throwable;
            }
            int count = 0;
            do {
                String hash = CacheHelper.hasher(rndGen.nextLong()).hash().toString();
                String bucket = hash.substring(0, 2);
                result = basePath.resolve(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{bucket, hash.substring(2)}, new String[]{"tmp/", "/", ""})));
                if (!FilesEx.exists(result, new LinkOption[0])) break block6;
            } while (!(++count > 100));
            throw (Throwable)new IOException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{result}, new String[]{"Unable to create a unique temporary path: ", ""})));
        }
        if (!FilesEx.mkdirs(result, new FileAttribute[0])) {
            throw (Throwable)new IOException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{result}, new String[]{"Unable to create temporary part: ", " -- Verify file system access permissions or if a file having the same name exists"})));
        }
        return result.toAbsolutePath();
    }

    public static final Path createLocalDir(String prefix) {
        return Files.createTempDirectory(localTempBasePath, prefix, new FileAttribute[0]);
    }

    public static final Path getLocalTempPath() {
        return localTempBasePath;
    }

    public static boolean isGlobAllowed(Path path) {
        return !(UNSUPPORTED_GLOB_WILDCARDS == null ? path.getFileSystem().provider().getScheme() == null : DefaultGroovyMethods.isCase(UNSUPPORTED_GLOB_WILDCARDS, (Object)path.getFileSystem().provider().getScheme()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path asPath(String str) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)str)) {
            throw (Throwable)new IllegalArgumentException("Path string cannot be empty");
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)str, (Object)Bolts.leftTrim(str))) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Escape.blanks(str)}, new String[]{"Path string cannot start with blank or a special characters -- Offending path: '", "'"})));
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)str, (Object)Bolts.rightTrim(str))) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Escape.blanks(str)}, new String[]{"Path string cannot ends with blank or a special characters -- Offending path: '", "'"})));
        }
        if (!str.contains(":/")) {
            return Paths.get(str, new String[0]);
        }
        Path result = FileSystemPathFactory.parse(str);
        if (DefaultTypeTransformation.booleanUnbox((Object)result)) {
            return result;
        }
        Class<FileHelper> clazz = FileHelper.class;
        synchronized (clazz) {
            Path path2;
            FileHelper.autoStartMissingPlugin(str);
            result = path2 = FileSystemPathFactory.parse(str);
            if (!DefaultTypeTransformation.booleanUnbox((Object)result)) return FileHelper.asPath(FileHelper.toPathURI(str));
            return result;
        }
    }

    protected static boolean autoStartMissingPlugin(String str) {
        String scheme = FileHelper.getUrlProtocol(str);
        if (DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt(SCHEME_CHECKED, (Object)scheme))) {
            return false;
        }
        String pluginId = ShortTypeHandling.castToString((Object)PLUGINS_MAP.get(scheme));
        if (DefaultTypeTransformation.booleanUnbox((Object)pluginId)) {
            block10: {
                Object v0;
                if (!Plugins.startIfMissing(pluginId)) break block10;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginId, str}, new String[]{"Started plugin '", "' required to handle file: ", ""})));
                    v0 = null;
                } else {
                    v0 = null;
                }
                boolean bl = true;
                boolean bl2 = true;
                ScriptBytecodeAdapter.invokeMethodN(FileHelper.class, SCHEME_CHECKED, (String)"putAt", (Object[])new Object[]{scheme, bl2});
                try {
                    try {
                        return bl;
                    }
                    catch (Exception e) {
                        Object v1;
                        if (log.isWarnEnabled()) {
                            log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginId, str}, new String[]{"Unable to start plugin '", "' required by ", ""})), (Throwable)e);
                            v1 = null;
                            break block10;
                        }
                        v1 = null;
                    }
                }
                catch (Throwable throwable) {
                    boolean bl3 = true;
                    ScriptBytecodeAdapter.invokeMethodN(FileHelper.class, SCHEME_CHECKED, (String)"putAt", (Object[])new Object[]{scheme, bl3});
                    throw throwable;
                }
            }
            boolean bl = true;
            ScriptBytecodeAdapter.invokeMethodN(FileHelper.class, SCHEME_CHECKED, (String)"putAt", (Object[])new Object[]{scheme, bl});
        }
        return false;
    }

    public static Path asPath(URI uri) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)uri.getScheme()) || ScriptBytecodeAdapter.compareEqual((Object)uri.getScheme(), (Object)"file")) {
            FileHelper.checkFileURI(uri);
            return FileSystems.getDefault().getPath(uri.getPath(), new String[0]);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)uri.getScheme(), (Object)"http") || ScriptBytecodeAdapter.compareEqual((Object)uri.getScheme(), (Object)"https") || ScriptBytecodeAdapter.compareEqual((Object)uri.getScheme(), (Object)"ftp")) {
            return Paths.get(uri);
        }
        boolean bl = PLUGINS_MAP.keySet() == null ? uri.getScheme() == null : DefaultGroovyMethods.isCase(PLUGINS_MAP.keySet(), (Object)uri.getScheme());
        if (bl) {
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.getAt(PLUGINS_MAP, (Object)uri.getScheme()), uri}, new String[]{"Missing plugin '", "' required to read file: ", ""})));
        }
        return FileHelper.getOrCreateFileSystemFor(uri).provider().getPath(uri);
    }

    private static Object checkFileURI(URI uri) {
        if (DefaultTypeTransformation.booleanUnbox((Object)uri.getScheme())) {
            if (DefaultTypeTransformation.booleanUnbox((Object)uri.getAuthority())) {
                throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{uri}, new String[]{"Malformed file URI: ", " -- It must start either with a `file:/` or `file:///` prefix"})));
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)uri.getPath())) {
                throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{uri}, new String[]{"Malformed file URI: ", " -- Make sure it starts with an absolue path prefix i.e. `file:/`"})));
            }
            return null;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)uri.getPath())) {
            throw (Throwable)new IllegalArgumentException("URI path cannot be empty");
        }
        return null;
    }

    static URI toPathURI(String str) {
        if (str.startsWith("igfs://") && ScriptBytecodeAdapter.compareNotEqual((Object)StringGroovyMethods.getAt((String)str, (int)7), (Object)Character.valueOf('/'))) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{str.substring(7)}, new String[]{"igfs:///", ""});
            str = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        return new URI(null, null, str, null, null);
    }

    @Deprecated
    public static FileSystem getWorkDirFileSystem() {
        return (FileSystem)ScriptBytecodeAdapter.castToType((Object)memoizedMethodClosure$getWorkDirFileSystem.call(), FileSystem.class);
    }

    public static boolean isPathNFS(Path path) {
        return DefaultTypeTransformation.booleanUnbox((Object)memoizedMethodClosure$isPathNFSPath.call((Object)path));
    }

    public static String getPathFsType(Path path) {
        return ShortTypeHandling.castToString((Object)memoizedMethodClosure$getPathFsTypePath.call((Object)path));
    }

    public static boolean getWorkDirIsNFS() {
        return FileHelper.isPathNFS(Global.getSession().getWorkDir());
    }

    static boolean safeExists(Path self, long timeout) {
        if (Files.exists(self, new LinkOption[0])) {
            return true;
        }
        if (!FileHelper.getWorkDirIsNFS()) {
            return false;
        }
        long begin = System.currentTimeMillis();
        Path path = self.getParent();
        String path2 = (DefaultTypeTransformation.booleanUnbox((Object)path) ? path : "/").toString();
        while (true) {
            Object v0;
            Process process = Runtime.getRuntime().exec(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path2}, new String[]{"ls -la ", ""})));
            int status = process.waitFor();
            if (log.isTraceEnabled()) {
                log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{status, path2, Bolts.indent(ProcessGroovyMethods.getText((Process)process), "  ")}, new String[]{"Safe exists listing: ", " -- path: ", "\n", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            if (status == 0) break;
            long delta = System.currentTimeMillis() - begin;
            if (delta > timeout) break;
            DefaultGroovyStaticMethods.sleep(null, (long)2000);
        }
        Files.readAttributes(self, BasicFileAttributes.class, new LinkOption[0]);
        boolean bl = true;
        try {
            return bl;
        }
        catch (IOException e) {
            Object v1;
            if (log.isTraceEnabled()) {
                log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{self, e.getClass().getSimpleName(), e.getMessage()}, new String[]{"Cant read file attributes: ", " -- Cause: [", "] ", ""})));
                v1 = null;
            } else {
                v1 = null;
            }
            boolean bl2 = false;
            return bl2;
        }
    }

    protected static Map envFor(String scheme) {
        return (Map)ScriptBytecodeAdapter.castToType((Object)memoizedMethodClosure$envForString.call((Object)scheme), Map.class);
    }

    static Map envFor0(String scheme, Map env) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(10);
        String string = scheme;
        if (ScriptBytecodeAdapter.compareEqual((Object)(string != null ? string.toLowerCase() : null), (Object)"s3")) {
            Object v0;
            HashMap hashMap;
            List<String> credentials = Global.getAwsCredentials(env);
            if (DefaultTypeTransformation.booleanUnbox(credentials)) {
                Object object = DefaultGroovyMethods.getAt(credentials, (int)0);
                ScriptBytecodeAdapter.setProperty((Object)object, null, result, (String)"access_key");
                Object object2 = DefaultGroovyMethods.getAt(credentials, (int)1);
                ScriptBytecodeAdapter.setProperty((Object)object2, null, result, (String)"secret_key");
                if (credentials.size() == 3) {
                    Object object3 = DefaultGroovyMethods.getAt(credentials, (int)2);
                    ScriptBytecodeAdapter.setProperty((Object)object3, null, result, (String)"session_token");
                    log.debug("Using AWS temporary session token for S3FS.");
                }
            }
            String region = Global.getAwsRegion();
            if (DefaultTypeTransformation.booleanUnbox((Object)region)) {
                String string2 = region;
                ScriptBytecodeAdapter.setProperty((Object)string2, null, result, (String)"region");
            }
            Map config = DefaultTypeTransformation.booleanUnbox(hashMap = Global.getAwsClientConfig()) ? hashMap : new HashMap(10);
            Map map = FileHelper.checkDefaultErrorRetry(config, env);
            config = map;
            if (DefaultTypeTransformation.booleanUnbox(config)) {
                result.putAll(config);
            }
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{FileHelper.dumpAwsConfig(result)}, new String[]{"AWS S3 config details: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
        } else {
            if (!DefaultTypeTransformation.booleanUnbox((Object)Global.getSession())) {
                Object v1;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{scheme}, new String[]{"Session is not available while creating environment for '", "' file system provider"})));
                    v1 = null;
                } else {
                    v1 = null;
                }
            }
            ISession iSession = Global.getSession();
            ScriptBytecodeAdapter.setProperty((Object)iSession, null, result, (String)"session");
        }
        return result;
    }

    static Map checkDefaultErrorRetry(Map result, Map env) {
        if (result == null) {
            HashMap hashMap;
            result = hashMap = new HashMap(10);
        }
        if (result.get("max_error_retry") == null) {
            Object var3_3 = env == null ? null : env.get("AWS_MAX_ATTEMPTS");
            ScriptBytecodeAdapter.setProperty(var3_3, null, result, (String)"max_error_retry");
        }
        if (result.get("max_error_retry") == null) {
            String string = "5";
            ScriptBytecodeAdapter.setProperty((Object)string, null, result, (String)"max_error_retry");
        } else {
            String string = DefaultGroovyMethods.toString(result.get("max_error_retry"));
            ScriptBytecodeAdapter.setProperty((Object)string, null, result, (String)"max_error_retry");
        }
        return result;
    }

    private static String dumpAwsConfig(Map<String, String> config) {
        HashMap<String, String> result = new HashMap<String, String>(config);
        if (DefaultTypeTransformation.booleanUnbox((Object)config.get("access_key")) && StringGroovyMethods.size((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)config.get("access_key"), CharSequence.class))) > 6) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{config.get("access_key").substring(0, 6)}, new String[]{"", ".."});
            ScriptBytecodeAdapter.setProperty((Object)gStringImpl, null, result, (String)"access_key");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)config.get("secret_key")) && StringGroovyMethods.size((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)config.get("secret_key"), CharSequence.class))) > 6) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{config.get("secret_key").substring(0, 6)}, new String[]{"", ".."});
            ScriptBytecodeAdapter.setProperty((Object)gStringImpl, null, result, (String)"secret_key");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)config.get("session_token")) && StringGroovyMethods.size((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)config.get("session_token"), CharSequence.class))) > 6) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{config.get("session_token").substring(0, 6)}, new String[]{"", ".."});
            ScriptBytecodeAdapter.setProperty((Object)gStringImpl, null, result, (String)"session_token");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileSystemProvider getProviderFor(String scheme) {
        if (providersMap.containsKey(scheme)) {
            return (FileSystemProvider)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(providersMap, (Object)scheme), FileSystemProvider.class);
        }
        Map<String, FileSystemProvider> map = providersMap;
        synchronized (map) {
            if (providersMap.containsKey(scheme)) {
                return (FileSystemProvider)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(providersMap, (Object)scheme), FileSystemProvider.class);
            }
            {
                FileSystemProvider provider = null;
                Iterator<FileSystemProvider> iterator = FileSystemProvider.installedProviders().iterator();
                do {
                    if (!iterator.hasNext()) return (FileSystemProvider)ScriptBytecodeAdapter.castToType(null, FileSystemProvider.class);
                } while (!ScriptBytecodeAdapter.compareEqual((Object)scheme, (Object)(provider = (FileSystemProvider)ScriptBytecodeAdapter.castToType((Object)iterator.next(), FileSystemProvider.class)).getScheme()));
                FileSystemProvider fileSystemProvider = provider;
                ScriptBytecodeAdapter.invokeMethodN(FileHelper.class, providersMap, (String)"putAt", (Object[])new Object[]{scheme, fileSystemProvider});
                return fileSystemProvider;
            }
        }
    }

    public static synchronized <T extends FileSystemProvider> T getOrInstallProvider(Class<T> clazz) {
        Object v0;
        FileSystemProvider fileSystemProvider;
        Reference clazz2 = new Reference(clazz);
        public final class _getOrInstallProvider_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference clazz;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getOrInstallProvider_closure6(Object _outerInstance, Object _thisObject, Reference clazz) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.clazz = reference = clazz;
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual(it.getClass(), (Object)this.clazz.get());
            }

            @Generated
            public Class getClazz() {
                return ShortTypeHandling.castToClass((Object)this.clazz.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getOrInstallProvider_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        FileSystemProvider result = (FileSystemProvider)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find(FileSystemProvider.installedProviders(), (Closure)new _getOrInstallProvider_closure6(FileHelper.class, FileHelper.class, clazz2)), FileSystemProvider.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)result)) {
            return (T)result;
        }
        result = fileSystemProvider = (FileSystemProvider)DefaultGroovyMethods.newInstance((Class)((Class)clazz2.get()));
        Field field = FileSystemProvider.class.getDeclaredField("installedProviders");
        field.setAccessible(true);
        ArrayList<FileSystemProvider> installedProviders = new ArrayList<FileSystemProvider>((List)ScriptBytecodeAdapter.castToType((Object)field.get(null), List.class));
        installedProviders.add(result);
        field.set(FileHelper.class, Collections.unmodifiableList(installedProviders));
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((Class)clazz2.get()).getSimpleName(), result.getScheme()}, new String[]{"> Added '", "' to list of installed providers [", "]"})));
            v0 = null;
        } else {
            v0 = null;
        }
        return (T)result;
    }

    /*
     * WARNING - void declaration
     */
    public static FileSystem getOrCreateFileSystemFor(URI uri, Map env) {
        void var1_1;
        Reference uri2 = new Reference((Object)uri);
        Reference env2 = new Reference((Object)var1_1);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            URI uRI = (URI)uri2.get();
            valueRecorder.record((Object)uRI, 8);
            if (uRI != null) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert uri", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        Reference provider = new Reference((Object)FileHelper.getProviderFor(((URI)uri2.get()).getScheme()));
        if (!DefaultTypeTransformation.booleanUnbox((Object)((FileSystemProvider)provider.get()))) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((URI)uri2.get()).getScheme()}, new String[]{"Cannot a find a file system provider for scheme: ", ""})));
        }
        Reference fs = new Reference(null);
        FileSystem cfr_ignored_0 = (FileSystem)fs.get();
        try {
            FileSystem fileSystem = ((FileSystemProvider)provider.get()).getFileSystem((URI)uri2.get());
            fs.set((Object)fileSystem);
        }
        catch (FileSystemNotFoundException e) {
            Object var9_9 = null;
            fs.set((Object)((FileSystem)ScriptBytecodeAdapter.castToType(var9_9, FileSystem.class)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)((FileSystem)fs.get()))) {
            return (FileSystem)fs.get();
        }
        public final class _getOrCreateFileSystemFor_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference fs;
            private /* synthetic */ Reference provider;
            private /* synthetic */ Reference uri;
            private /* synthetic */ Reference env;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getOrCreateFileSystemFor_closure7(Object _outerInstance, Object _thisObject, Reference fs, Reference provider, Reference uri, Reference env) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.fs = reference4 = fs;
                this.provider = reference3 = provider;
                this.uri = reference2 = uri;
                this.env = reference = env;
            }

            public FileSystem doCall(Object it) {
                try {
                    FileSystem fileSystem = ((FileSystemProvider)this.provider.get()).getFileSystem((URI)ScriptBytecodeAdapter.castToType((Object)this.uri.get(), URI.class));
                    this.fs.set((Object)fileSystem);
                }
                catch (FileSystemNotFoundException e) {
                    Object var4_4 = null;
                    this.fs.set((Object)((FileSystem)ScriptBytecodeAdapter.castToType(var4_4, FileSystem.class)));
                }
                if (!DefaultTypeTransformation.booleanUnbox((Object)this.fs.get())) {
                    Object v0;
                    if (FileHelper.pfaccess$1(null).isDebugEnabled()) {
                        FileHelper.pfaccess$1(null).debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.provider.get().getClass().getSimpleName()}, new String[]{"Creating a file system instance for provider: ", ""})));
                        v0 = null;
                    } else {
                        v0 = null;
                    }
                    Object object = this.env.get();
                    Map map = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
                    FileSystem fileSystem = ((FileSystemProvider)this.provider.get()).newFileSystem((URI)ScriptBytecodeAdapter.castToType((Object)this.uri.get(), URI.class), DefaultTypeTransformation.booleanUnbox((Object)object) ? map : (Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeStaticMethod(FileHelper.class, (String)"envFor", (Object)new Object[]{((URI)this.uri.get()).getScheme()}), Map.class));
                    this.fs.set((Object)fileSystem);
                }
                return (FileSystem)ScriptBytecodeAdapter.castToType((Object)this.fs.get(), FileSystem.class);
            }

            @Generated
            public FileSystem getFs() {
                return (FileSystem)ScriptBytecodeAdapter.castToType((Object)this.fs.get(), FileSystem.class);
            }

            @Generated
            public Object getProvider() {
                return this.provider.get();
            }

            @Generated
            public URI getUri() {
                return (URI)ScriptBytecodeAdapter.castToType((Object)this.uri.get(), URI.class);
            }

            @Generated
            public Map getEnv() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.env.get(), Map.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public FileSystem doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getOrCreateFileSystemFor_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Bolts.withLock(_fs_lock, new _getOrCreateFileSystemFor_closure7(FileHelper.class, FileHelper.class, fs, provider, uri2, env2));
        return (FileSystem)fs.get();
    }

    public static FileSystem getOrCreateFileSystemFor(String scheme, Map env) {
        return FileHelper.getOrCreateFileSystemFor(URI.create(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{scheme}, new String[]{"", ":///"}))), env);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path getLocalCachePath(Path sourcePath, Path cacheDir, UUID sessionId) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Path path = sourcePath;
            valueRecorder.record((Object)path, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)path)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert sourcePath", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            Path path = cacheDir;
            valueRecorder2.record((Object)path, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)path)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert cacheDir", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        Path key = sessionId != null ? ScriptBytecodeAdapter.createList((Object[])new Object[]{sessionId, sourcePath}) : sourcePath;
        HashCode hash = CacheHelper.hasher(key).hash();
        Path cached = FileHelper.getWorkFolder(cacheDir, hash).resolve(sourcePath.getFileName().toString());
        if (Files.exists(cached, new LinkOption[0])) {
            return cached;
        }
        Path path = cacheDir;
        synchronized (path) {
            if (!Files.exists(cached, new LinkOption[0])) return FilesEx.copyTo(sourcePath, cached);
            return cached;
        }
    }

    public static PathMatcher getDefaultPathMatcher(String syntaxAndInput) {
        int pos = syntaxAndInput.indexOf(":");
        if (pos <= 0 || pos == syntaxAndInput.length()) {
            throw (Throwable)new IllegalArgumentException();
        }
        String syntax = syntaxAndInput.substring(0, pos);
        String input = syntaxAndInput.substring(pos + 1);
        String expr = null;
        if (ScriptBytecodeAdapter.compareEqual((Object)syntax, (Object)"glob")) {
            String string;
            expr = string = Globs.toUnixRegexPattern(input);
        } else if (ScriptBytecodeAdapter.compareEqual((Object)syntax, (Object)"regex")) {
            String string;
            expr = string = input;
        } else {
            throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{syntax}, new String[]{"Syntax '", "' not recognized"})));
        }
        Reference pattern = new Reference((Object)Pattern.compile(expr));
        return new PathMatcher(pattern){
            public /* synthetic */ Reference pattern;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                this.pattern = reference = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public boolean matches(Path path) {
                return ((Pattern)this.pattern.get()).matcher(path.toString()).matches();
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }
        };
    }

    public static PathMatcher getPathMatcherFor(String syntaxAndPattern, FileSystem fileSystem) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            FileSystem fileSystem2 = fileSystem;
            valueRecorder.record((Object)fileSystem2, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)fileSystem2)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert fileSystem", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            String string = syntaxAndPattern;
            valueRecorder2.record((Object)string, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)string)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert syntaxAndPattern", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        PathMatcher matcher = null;
        try {
            PathMatcher pathMatcher;
            matcher = pathMatcher = fileSystem.getPathMatcher(syntaxAndPattern);
        }
        catch (UnsupportedOperationException e) {
            Object var7_7 = null;
            matcher = (PathMatcher)ScriptBytecodeAdapter.castToType(var7_7, PathMatcher.class);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
            PathMatcher pathMatcher;
            Object v4;
            if (log.isTraceEnabled()) {
                log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{fileSystem.getClass().getSimpleName()}, new String[]{"Path matcher not defined by '", "' file system -- using default default strategy"})));
                v4 = null;
            } else {
                v4 = null;
            }
            matcher = pathMatcher = FileHelper.getDefaultPathMatcher(syntaxAndPattern);
        }
        return matcher;
    }

    /*
     * WARNING - void declaration
     */
    public static void visitFiles(Map options, Path folder, String filePattern, Closure action) {
        void var3_3;
        void var2_2;
        Reference folder2 = new Reference((Object)folder);
        Reference filePattern2 = new Reference((Object)var2_2);
        Reference action2 = new Reference((Object)var3_3);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Path path = (Path)folder2.get();
            valueRecorder.record((Object)path, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)path)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert folder", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            String string = (String)filePattern2.get();
            valueRecorder2.record((Object)string, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)string)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert filePattern", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder3 = new ValueRecorder();
        try {
            Closure closure = (Closure)action2.get();
            valueRecorder3.record((Object)closure, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)closure)) {
                valueRecorder3.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert action", (ValueRecorder)valueRecorder3), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder3.clear();
            throw throwable;
        }
        String string = options == null ? null : (String)options.get("type");
        String type = DefaultTypeTransformation.booleanUnbox(string) ? string : "any";
        EnumSet<FileVisitOption> walkOptions = ScriptBytecodeAdapter.compareEqual(options == null ? null : options.get("followLinks"), (Object)false) ? EnumSet.noneOf(FileVisitOption.class) : EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Reference maxDepth = new Reference((Object)FileHelper.getMaxDepth(options == null ? null : options.get("maxDepth"), (String)filePattern2.get()));
        Boolean bl = (Boolean)ScriptBytecodeAdapter.asType(options == null ? null : options.get("hidden"), Boolean.class);
        Reference includeHidden = new Reference((Object)(DefaultTypeTransformation.booleanUnbox((Object)bl) ? bl : Boolean.valueOf(((String)filePattern2.get()).startsWith("."))));
        Reference includeDir = new Reference((Object)(ScriptBytecodeAdapter.createList((Object[])new Object[]{"dir", "any"}) == null ? type == null : DefaultGroovyMethods.isCase((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{"dir", "any"}), (Object)type)));
        Reference includeFile = new Reference((Object)(ScriptBytecodeAdapter.createList((Object[])new Object[]{"file", "any"}) == null ? type == null : DefaultGroovyMethods.isCase((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{"file", "any"}), (Object)type)));
        String string2 = options == null ? null : (String)options.get("syntax");
        String syntax = DefaultTypeTransformation.booleanUnbox(string2) ? string2 : "glob";
        Reference relative = new Reference((Object)ScriptBytecodeAdapter.compareEqual(options == null ? null : options.get("relative"), (Object)true));
        Reference matcher = new Reference((Object)FileHelper.getPathMatcherFor(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{syntax, (String)filePattern2.get()}, new String[]{"", ":", ""})), ((Path)folder2.get()).getFileSystem()));
        Reference singleParam = new Reference((Object)(((Closure)action2.get()).getMaximumNumberOfParameters() == 1 ? 1 : 0));
        Files.walkFileTree((Path)folder2.get(), walkOptions, Integer.MAX_VALUE, (FileVisitor<? super Path>)new GroovyObject(folder2, includeDir, matcher, includeHidden, relative, singleParam, action2, maxDepth, includeFile, filePattern2){
            public /* synthetic */ Reference filePattern;
            public /* synthetic */ Reference includeFile;
            public /* synthetic */ Reference maxDepth;
            public /* synthetic */ Reference action;
            public /* synthetic */ Reference singleParam;
            public /* synthetic */ Reference relative;
            public /* synthetic */ Reference includeHidden;
            public /* synthetic */ Reference matcher;
            public /* synthetic */ Reference includeDir;
            public /* synthetic */ Reference folder;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                Reference reference8;
                Reference reference9;
                Reference reference10;
                this.folder = reference10 = p0;
                this.includeDir = reference9 = p1;
                this.matcher = reference8 = p2;
                this.includeHidden = reference7 = p3;
                this.relative = reference6 = p4;
                this.singleParam = reference5 = p5;
                this.action = reference4 = p6;
                this.maxDepth = reference3 = p7;
                this.includeFile = reference2 = p8;
                this.filePattern = reference = p9;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public FileVisitResult preVisitDirectory(Path fullPath, BasicFileAttributes attrs) throws IOException {
                int depth = fullPath.getNameCount() - ((Path)this.folder.get()).getNameCount();
                Path path = FileHelper.relativize0((Path)ScriptBytecodeAdapter.castToType((Object)this.folder.get(), Path.class), fullPath);
                FileHelper.pfaccess$1(null).trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path, depth, this.includeDir.get(), ((PathMatcher)this.matcher.get()).matches(path), attrs.isDirectory()}, new String[]{"visitFiles > dir=", "; depth=", "; includeDir=", "; matches=", "; isDir=", ""})));
                if (depth > 0 && DefaultTypeTransformation.booleanUnbox((Object)this.includeDir.get()) && ((PathMatcher)this.matcher.get()).matches(path) && attrs.isDirectory() && (DefaultTypeTransformation.booleanUnbox((Object)this.includeHidden.get()) || !FileHelper.isHidden(fullPath))) {
                    Object object = this.relative.get();
                    Path result = (object == null ? false : (Boolean)object) ? path : fullPath;
                    Object object2 = this.singleParam.get();
                    Object object3 = (object2 == null ? false : (Boolean)object2) ? ((Closure)this.action.get()).call((Object)result) : ((Closure)ScriptBytecodeAdapter.castToType((Object)this.action.get(), Closure.class)).call(new Object[]{result, attrs});
                }
                return ScriptBytecodeAdapter.compareGreaterThan((Object)depth, (Object)this.maxDepth.get()) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path fullPath, BasicFileAttributes attrs) throws IOException {
                Path path = ((Path)this.folder.get()).relativize(fullPath);
                FileHelper.pfaccess$1(null).trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path, this.includeFile.get(), ((PathMatcher)this.matcher.get()).matches(path), attrs.isRegularFile()}, new String[]{"visitFiles > file=", "; includeFile=", "; matches=", "; isRegularFile=", ""})));
                if (DefaultTypeTransformation.booleanUnbox((Object)this.includeFile.get()) && ((PathMatcher)this.matcher.get()).matches(path) && attrs.isRegularFile() && (DefaultTypeTransformation.booleanUnbox((Object)this.includeHidden.get()) || !FileHelper.isHidden(fullPath))) {
                    Object object = this.relative.get();
                    Path result = (object == null ? false : (Boolean)object) ? path : fullPath;
                    Object object2 = this.singleParam.get();
                    Object object3 = (object2 == null ? false : (Boolean)object2) ? ((Closure)this.action.get()).call((Object)result) : ((Closure)ScriptBytecodeAdapter.castToType((Object)this.action.get(), Closure.class)).call(new Object[]{result, attrs});
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path currentPath, IOException e) {
                if (e instanceof FileSystemLoopException) {
                    String path = ((Path)this.folder.get()).relativize(currentPath).toString();
                    String capture = FilePatternSplitter.glob().parse(ShortTypeHandling.castToString((Object)this.filePattern.get())).getParent();
                    GStringImpl message = new GStringImpl(new Object[]{currentPath}, new String[]{"Circular file path detected -- Files in the following directory will be ignored: ", ""});
                    if (ScriptBytecodeAdapter.compareEqual((Object)capture, (Object)"./") || path.startsWith(capture)) {
                        FileHelper.pfaccess$1(null).warn(ShortTypeHandling.castToString((Object)message));
                    } else {
                        FileHelper.pfaccess$1(null).debug(ShortTypeHandling.castToString((Object)message));
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
                throw (Throwable)e;
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(2.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(2.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(2.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(2.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    protected static Path relativize0(Path folder, Path fullPath) {
        result = folder.relativize(fullPath);
        str = null;
        if (folder == FileSystems.getDefault()) ** GOTO lbl-1000
        str = var4_4 = result.toString();
        if (var4_4.endsWith("/") == false) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        if (v0) {
            return result;
        }
        len = str.length();
        return len > 0 != false ? Paths.get(str.substring(0, str.length() - 1), new String[0]) : Paths.get("", new String[0]);
    }

    private static boolean isHidden(Path path) {
        String string;
        Path fileName = path.getFileName();
        return DefaultTypeTransformation.booleanUnbox(DefaultTypeTransformation.booleanUnbox((Object)fileName) ? ((string = fileName.toString()) != null ? Boolean.valueOf(string.startsWith(".")) : null) : null);
    }

    static int getMaxDepth(Object value, String filePattern) {
        if (value != null) {
            return DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)value, Integer.TYPE));
        }
        String string = filePattern;
        Boolean bl = string != null ? Boolean.valueOf(string.contains("**")) : null;
        if (bl == null ? false : bl) {
            return Integer.MAX_VALUE;
        }
        String string2 = filePattern;
        Boolean bl2 = string2 != null ? Boolean.valueOf(string2.contains("/")) : null;
        if (bl2 == null ? false : bl2) {
            public final class _getMaxDepth_closure8
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getMaxDepth_closure8(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public String doCall(Object it) {
                    return ShortTypeHandling.castToString((Object)it);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public String doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getMaxDepth_closure8.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            return DefaultGroovyMethods.findAll((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)filePattern.split("/"), Object[].class)), (Closure)new _getMaxDepth_closure8(FileHelper.class, FileHelper.class)).size() - 1;
        }
        return 0;
    }

    public static FileSystem fileSystemForScheme(String scheme) {
        return !DefaultTypeTransformation.booleanUnbox((Object)scheme) ? FileSystems.getDefault() : FileHelper.getOrCreateFileSystemFor(scheme);
    }

    public static Path movePath(Path source, Path target, CopyOption ... options) throws IOException {
        FileSystemProvider provider = source.getFileSystem().provider();
        if (target.getFileSystem().provider() == provider) {
            provider.move(source, target, options);
        } else {
            CopyMoveHelper.moveToForeignTarget(source, target, options);
        }
        return target;
    }

    public static Path copyPath(Path source, Path target, CopyOption ... options) throws IOException {
        FileSystemProvider provider = source.getFileSystem().provider();
        if (target.getFileSystem().provider() == provider) {
            LinkOption[] linkOpts = DefaultGroovyMethods.contains((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)options, Object[].class)), (Object)LinkOption.NOFOLLOW_LINKS) ? NO_FOLLOW_LINKS : FOLLOW_LINKS;
            if (Files.isDirectory(source, linkOpts)) {
                CopyMoveHelper.copyDirectory(source, target, options);
            } else {
                provider.copy(source, target, options);
            }
        } else {
            CopyMoveHelper.copyToForeignTarget(source, target, options);
        }
        return target;
    }

    public static void deletePath(Path path) {
        BasicFileAttributes attr = FileHelper.readAttributes(path, LinkOption.NOFOLLOW_LINKS);
        if (!DefaultTypeTransformation.booleanUnbox((Object)attr)) {
            return;
        }
        if (attr.isDirectory()) {
            FileHelper.deleteDir0(path);
        } else {
            Files.delete(path);
        }
    }

    private static Object deleteDir0(Path path) {
        return Files.walkFileTree(path, (FileVisitor<? super Path>)new GroovyObject(){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(3.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(3.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(3.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(3.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }
        });
    }

    public static String listDirectory(Path path) {
        String result;
        block12: {
            result = null;
            Process process = null;
            String target = Escape.path(path);
            try {
                Object v2;
                try {
                    Process process2;
                    process = process2 = Runtime.getRuntime().exec(new String[]{"sh", "-c", ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{target}, new String[]{"ls -la ", " | head -n 50"}))});
                    ProcessGroovyMethods.waitForOrKill((Process)process, (long)1000);
                    int listStatus = process.exitValue();
                    if (listStatus > 0) {
                        Object v0;
                        if (log.isDebugEnabled()) {
                            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{target, listStatus}, new String[]{"Can't list folder: ", " -- Exit status: ", ""})));
                            v0 = null;
                        } else {
                            v0 = null;
                        }
                    } else {
                        String string;
                        result = string = ProcessGroovyMethods.getText((Process)process);
                    }
                }
                catch (IOException e) {
                    Object v1;
                    if (log.isDebugEnabled()) {
                        String string = e.getMessage();
                        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{target, DefaultTypeTransformation.booleanUnbox((Object)string) ? string : e.toString()}, new String[]{"Can't list folder: ", " -- Cause: ", ""})));
                        v1 = null;
                    }
                    v1 = null;
                }
                Process process3 = process;
                if (process3 != null) {
                    process3.destroy();
                    v2 = null;
                    break block12;
                }
                v2 = null;
            }
            catch (Throwable throwable) {
                Object v3;
                Process process4 = process;
                if (process4 != null) {
                    process4.destroy();
                    v3 = null;
                } else {
                    v3 = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    public static BasicFileAttributes readAttributes(Path path, LinkOption ... options) {
        BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, options);
        try {
            return basicFileAttributes;
        }
        catch (IOException e) {
            Object v0;
            if (log.isTraceEnabled()) {
                log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path}, new String[]{"Unable to read attributes for file: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            BasicFileAttributes basicFileAttributes2 = (BasicFileAttributes)ScriptBytecodeAdapter.castToType(null, BasicFileAttributes.class);
            return basicFileAttributes2;
        }
    }

    public static Path checkIfExists(Path path, Map opts) throws NoSuchFileException {
        Path result = FilesEx.complete(path);
        boolean checkIfExists = DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType(opts == null ? null : opts.get("checkIfExists"), Boolean.TYPE));
        List followLinks = ScriptBytecodeAdapter.compareEqual(opts == null ? null : opts.get("followLinks"), (Object)false) ? ScriptBytecodeAdapter.createList((Object[])new Object[]{LinkOption.NOFOLLOW_LINKS}) : Collections.emptyList();
        if (!checkIfExists || FilesEx.exists(result, (LinkOption[])ScriptBytecodeAdapter.asType((Object)followLinks, LinkOption[].class))) {
            return result;
        }
        throw (Throwable)new NoSuchFileException(FilesEx.toUriString(result));
    }

    public static String getIdentifier(Path script, String prefix) {
        char UNDERSCORE = '_';
        String str = FilesEx.getSimpleName(script);
        StringBuilder normalised = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            boolean valid = i == 0 ? Character.isJavaIdentifierStart(ch) : Character.isJavaIdentifierPart(ch);
            normalised.append(valid ? ch : UNDERSCORE);
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        String result = DefaultTypeTransformation.booleanUnbox((Object)prefix) ? StringGroovyMethods.plus((String)prefix, (CharSequence)normalised) : normalised.toString();
        while (result.contains("__")) {
            String string;
            result = string = result.replace("__", "_");
        }
        return result;
    }

    public static String getUrlProtocol(String str) {
        Matcher m = URL_PROTOCOL.matcher(str);
        return ShortTypeHandling.castToString(m.matches() ? m.group(1) : null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileHelper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Deprecated
    @Generated
    private static FileSystem memoizedMethodPriv$getWorkDirFileSystem() {
        ISession iSession = Global.getSession();
        Path path = iSession != null ? iSession.getWorkDir() : null;
        FileSystem result = path != null ? path.getFileSystem() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)result)) {
            FileSystem fileSystem;
            log.warn("Session working file system not defined -- fallback on JVM default file system");
            result = fileSystem = FileSystems.getDefault();
        }
        return result;
    }

    @Generated
    private static boolean memoizedMethodPriv$isPathNFSPath(Path path) {
        Object v2;
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Path path2 = path;
            valueRecorder.record((Object)path2, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)path2)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert path", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)path.getFileSystem(), (Object)FileSystems.getDefault())) {
            return false;
        }
        String type = FileHelper.getPathFsType(path);
        boolean result = ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"nfs");
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{result, path}, new String[]{"NFS path (", "): ", ""})));
            v2 = null;
        } else {
            v2 = null;
        }
        return result;
    }

    @Generated
    private static String memoizedMethodPriv$getPathFsTypePath(Path path) {
        String os = System.getProperty("os.name");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)os, (Object)"Linux")) {
            return os;
        }
        Process process = Runtime.getRuntime().exec(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path}, new String[]{"stat -f -c %T ", ""})));
        int status = process.waitFor();
        String string = ProcessGroovyMethods.getText((Process)process);
        String text = string != null ? string.trim() : null;
        process.destroy();
        if (status != 0) {
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{status, FilesEx.toUriString(path), Bolts.indent(text, "  ")}, new String[]{"Can't check if specified path is NFS (", "): ", "\n", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            return ShortTypeHandling.castToString(null);
        }
        return text;
    }

    @Generated
    private static Map memoizedMethodPriv$envForString(String scheme) {
        return FileHelper.envFor0(scheme, System.getenv());
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(FileHelper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, FileHelper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(FileHelper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ Random pfaccess$0(FileHelper $that) {
        return (Random)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(FileHelper.class, FileHelper.class, (String)"rndGen"), Random.class);
    }

    public static /* synthetic */ Logger pfaccess$1(FileHelper $that) {
        return (Logger)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(FileHelper.class, FileHelper.class, (String)"log"), Logger.class);
    }

    @Generated
    public static final Path createLocalDir() {
        CallSite[] callSiteArray = FileHelper.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return FileHelper.createLocalDir("nxf-");
        }
        return FileHelper.createLocalDir("nxf-");
    }

    @Generated
    static boolean safeExists(Path self) {
        CallSite[] callSiteArray = FileHelper.$getCallSiteArray();
        return FileHelper.safeExists(self, 120000);
    }

    @Generated
    public static FileSystem getOrCreateFileSystemFor(URI uri) {
        Reference uri2 = new Reference((Object)uri);
        CallSite[] callSiteArray = FileHelper.$getCallSiteArray();
        return FileHelper.getOrCreateFileSystemFor((URI)uri2.get(), null);
    }

    @Generated
    public static FileSystem getOrCreateFileSystemFor(String scheme) {
        CallSite[] callSiteArray = FileHelper.$getCallSiteArray();
        return FileHelper.getOrCreateFileSystemFor(scheme, null);
    }

    @Generated
    public static Path getLocalCachePath(Path sourcePath, Path cacheDir) {
        CallSite[] callSiteArray = FileHelper.$getCallSiteArray();
        return FileHelper.getLocalCachePath(sourcePath, cacheDir, null);
    }

    /*
     * WARNING - void declaration
     */
    @Generated
    public static void visitFiles(Path folder, String filePattern, Closure action) {
        void var2_2;
        void var1_1;
        Reference folder2 = new Reference((Object)folder);
        Reference filePattern2 = new Reference((Object)var1_1);
        Reference action2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = FileHelper.$getCallSiteArray();
        FileHelper.visitFiles(null, (Path)folder2.get(), (String)filePattern2.get(), (Closure)action2.get());
    }

    @Generated
    public static String getIdentifier(Path script) {
        CallSite[] callSiteArray = FileHelper.$getCallSiteArray();
        return FileHelper.getIdentifier(script, null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(FileHelper.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = FileHelper.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

