/*
 * Decompiled with CFR 0.152.
 */
package nextflow.util;

import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class StringUtils
implements GroovyObject {
    public static final Pattern URL_PROTOCOL;
    private static final Pattern URL_PASSWORD;
    private static final Pattern BASE_URL;
    private static Pattern multilinePattern;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public StringUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String getUrlProtocol(String str) {
        Matcher m = URL_PROTOCOL.matcher(str);
        return ShortTypeHandling.castToString(m.matches() ? m.group(1) : null);
    }

    public static String baseUrl(String url) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)url)) {
            return ShortTypeHandling.castToString(null);
        }
        Matcher m = BASE_URL.matcher(url);
        return ShortTypeHandling.castToString(m.matches() ? m.group(1).toLowerCase() : null);
    }

    public static String stripSecrets(String message) {
        if (message == null) {
            return message;
        }
        StringBuilder sb = new StringBuilder(message);
        Matcher matcher = multilinePattern.matcher(sb);
        while (matcher.find()) {
            int idx = 0;
            while (idx < matcher.groupCount()) {
                int ini = matcher.start(idx + 2);
                int end = matcher.end(idx + 2);
                sb.delete(ini, end);
                sb.insert(ini, "********");
                int cfr_ignored_0 = idx + 2;
            }
            matcher.reset();
        }
        return sb.toString();
    }

    private static boolean isSensitive(Object key) {
        String str = DefaultGroovyMethods.toString((Object)key).toLowerCase();
        return str.contains("password") || str.contains("token") || str.contains("secret") || str.contains("license");
    }

    public static Map stripSecrets(Map map) {
        HashMap copy = new HashMap(map.size());
        Map.Entry entry = null;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
            if (entry.getValue() instanceof Map) {
                copy.put(entry.getKey(), StringUtils.stripSecrets((Map)ScriptBytecodeAdapter.castToType(entry.getValue(), Map.class)));
                continue;
            }
            if (StringUtils.isSensitive(entry.getKey())) {
                copy.put(entry.getKey(), StringUtils.redact(entry.getValue()));
                continue;
            }
            copy.put(entry.getKey(), StringUtils.redactUrlPassword(entry.getValue()));
        }
        return copy;
    }

    public static String redact(Object value) {
        if (value == null) {
            return "(null)";
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return "(empty)";
        }
        String str = DefaultGroovyMethods.toString((Object)value);
        return str.length() >= 5 ? StringGroovyMethods.plus((String)StringGroovyMethods.getAt((String)str, (IntRange)new IntRange(true, 0, 2)), (CharSequence)"****") : "****";
    }

    public static String redactUrlPassword(Object value) {
        String str = DefaultGroovyMethods.toString((Object)value);
        Matcher m = URL_PASSWORD.matcher(str);
        if (m.matches()) {
            return StringUtils.replaceGroup(m, str, 1, StringUtils.redact(m.group(1)));
        }
        return str;
    }

    public static String replaceGroup(Matcher matcher, String source, int groupToReplace, String replacement) {
        return new StringBuilder(source).replace(matcher.start(groupToReplace), matcher.end(groupToReplace), replacement).toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StringUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = ScriptBytecodeAdapter.bitwiseNegate((Object)"^([a-zA-Z0-9]*):\\/\\/(.+)");
        URL_PROTOCOL = (Pattern)ScriptBytecodeAdapter.castToType((Object)object, Pattern.class);
        Object object2 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^[a-zA-Z][a-zA-Z0-9]*:\\/\\/(.+)@.+");
        URL_PASSWORD = (Pattern)ScriptBytecodeAdapter.castToType((Object)object2, Pattern.class);
        Object object3 = ScriptBytecodeAdapter.bitwiseNegate((Object)"(?i)((?:[a-z][a-zA-Z0-9]*)?://[^:|/]+(?::\\d*)?)(?:$|/.*)");
        BASE_URL = (Pattern)ScriptBytecodeAdapter.castToType((Object)object3, Pattern.class);
        Object object4 = ScriptBytecodeAdapter.bitwiseNegate((Object)"\"?(password|token|secret|license)\"?\\s?[:=]\\s?\"?(\\w+)\"?");
        multilinePattern = (Pattern)ScriptBytecodeAdapter.castToType((Object)object4, Pattern.class);
    }
}

