package io.norberg.automatter.example;

import com.google.common.base.Optional;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
final class ComplexGenericFoobarBuilder<FOO, BAR extends Number, BAZ extends Collection<? extends BAR>, QUUX extends Iterable<? extends BAR> & Comparable<QUUX>> {
  private FOO foo;

  private BAR bar;

  private BAZ baz;

  private QUUX quux;

  private Optional<FOO> maybeFoo;

  private List<BAR> someBars;

  private Map<FOO, BAR> foobars;

  private String name;

  public ComplexGenericFoobarBuilder() {
    this.maybeFoo = Optional.absent();
  }

  private ComplexGenericFoobarBuilder(ComplexGenericFoobar<? extends FOO, ? extends BAR, ? extends BAZ, ? extends QUUX> v) {
    this.foo = v.foo();
    this.bar = v.bar();
    this.baz = v.baz();
    this.quux = v.quux();
    this.maybeFoo = (Optional<FOO>) v.maybeFoo();
    List<? extends BAR> _someBars = v.someBars();
    this.someBars = (_someBars == null) ? null : new ArrayList<BAR>(_someBars);
    Map<? extends FOO, ? extends BAR> _foobars = v.foobars();
    this.foobars = (_foobars == null) ? null : new HashMap<FOO, BAR>(_foobars);
    this.name = v.name();
  }

  private ComplexGenericFoobarBuilder(ComplexGenericFoobarBuilder<? extends FOO, ? extends BAR, ? extends BAZ, ? extends QUUX> v) {
    this.foo = v.foo;
    this.bar = v.bar;
    this.baz = v.baz;
    this.quux = v.quux;
    this.maybeFoo = (Optional<FOO>) v.maybeFoo;
    this.someBars = (v.someBars == null) ? null : new ArrayList<BAR>(v.someBars);
    this.foobars = (v.foobars == null) ? null : new HashMap<FOO, BAR>(v.foobars);
    this.name = v.name;
  }

  public FOO foo() {
    return foo;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> foo(FOO foo) {
    if (foo == null) {
      throw new NullPointerException("foo");
    }
    this.foo = foo;
    return this;
  }

  public BAR bar() {
    return bar;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> bar(BAR bar) {
    if (bar == null) {
      throw new NullPointerException("bar");
    }
    this.bar = bar;
    return this;
  }

  public BAZ baz() {
    return baz;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> baz(BAZ baz) {
    if (baz == null) {
      throw new NullPointerException("baz");
    }
    this.baz = baz;
    return this;
  }

  public QUUX quux() {
    return quux;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> quux(QUUX quux) {
    if (quux == null) {
      throw new NullPointerException("quux");
    }
    this.quux = quux;
    return this;
  }

  public Optional<FOO> maybeFoo() {
    return maybeFoo;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> maybeFoo(FOO maybeFoo) {
    return maybeFoo(Optional.fromNullable(maybeFoo));
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> maybeFoo(Optional<? extends FOO> maybeFoo) {
    if (maybeFoo == null) {
      throw new NullPointerException("maybeFoo");
    }
    this.maybeFoo = (Optional<FOO>)maybeFoo;
    return this;
  }

  public List<BAR> someBars() {
    if (this.someBars == null) {
      this.someBars = new ArrayList<BAR>();
    }
    return someBars;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> someBars(List<? extends BAR> someBars) {
    return someBars((Collection<? extends BAR>) someBars);
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> someBars(Collection<? extends BAR> someBars) {
    if (someBars == null) {
      throw new NullPointerException("someBars");
    }
    for (BAR item : someBars) {
      if (item == null) {
        throw new NullPointerException("someBars: null item");
      }
    }
    this.someBars = new ArrayList<BAR>(someBars);
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> someBars(Iterable<? extends BAR> someBars) {
    if (someBars == null) {
      throw new NullPointerException("someBars");
    }
    if (someBars instanceof Collection) {
      return someBars((Collection<? extends BAR>) someBars);
    }
    return someBars(someBars.iterator());
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> someBars(Iterator<? extends BAR> someBars) {
    if (someBars == null) {
      throw new NullPointerException("someBars");
    }
    this.someBars = new ArrayList<BAR>();
    while (someBars.hasNext()) {
      BAR item = someBars.next();
      if (item == null) {
        throw new NullPointerException("someBars: null item");
      }
      this.someBars.add(item);
    }
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> someBars(BAR... someBars) {
    if (someBars == null) {
      throw new NullPointerException("someBars");
    }
    return someBars(Arrays.asList(someBars));
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> addSomeBar(BAR someBar) {
    if (someBar == null) {
      throw new NullPointerException("someBar");
    }
    if (this.someBars == null) {
      this.someBars = new ArrayList<BAR>();
    }
    someBars.add(someBar);
    return this;
  }

  public Map<FOO, BAR> foobars() {
    if (this.foobars == null) {
      this.foobars = new HashMap<FOO, BAR>();
    }
    return foobars;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> foobars(Map<? extends FOO, ? extends BAR> foobars) {
    if (foobars == null) {
      throw new NullPointerException("foobars");
    }
    for (Map.Entry<? extends FOO, ? extends BAR> entry : foobars.entrySet()) {
      if (entry.getKey() == null) {
        throw new NullPointerException("foobars: null key");
      }
      if (entry.getValue() == null) {
        throw new NullPointerException("foobars: null value");
      }
    }
    this.foobars = new HashMap<FOO, BAR>(foobars);
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> foobars(FOO k1, BAR v1) {
    if (k1 == null) {
      throw new NullPointerException("foobars: k1");
    }
    if (v1 == null) {
      throw new NullPointerException("foobars: v1");
    }
    foobars = new HashMap<FOO, BAR>();
    foobars.put(k1, v1);
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> foobars(FOO k1, BAR v1, FOO k2, BAR v2) {
    foobars(k1, v1);
    if (k2 == null) {
      throw new NullPointerException("foobars: k2");
    }
    if (v2 == null) {
      throw new NullPointerException("foobars: v2");
    }
    foobars.put(k2, v2);
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> foobars(FOO k1, BAR v1, FOO k2, BAR v2, FOO k3, BAR v3) {
    foobars(k1, v1, k2, v2);
    if (k3 == null) {
      throw new NullPointerException("foobars: k3");
    }
    if (v3 == null) {
      throw new NullPointerException("foobars: v3");
    }
    foobars.put(k3, v3);
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> foobars(FOO k1, BAR v1, FOO k2, BAR v2, FOO k3, BAR v3, FOO k4, BAR v4) {
    foobars(k1, v1, k2, v2, k3, v3);
    if (k4 == null) {
      throw new NullPointerException("foobars: k4");
    }
    if (v4 == null) {
      throw new NullPointerException("foobars: v4");
    }
    foobars.put(k4, v4);
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> foobars(FOO k1, BAR v1, FOO k2, BAR v2, FOO k3, BAR v3, FOO k4, BAR v4, FOO k5, BAR v5) {
    foobars(k1, v1, k2, v2, k3, v3, k4, v4);
    if (k5 == null) {
      throw new NullPointerException("foobars: k5");
    }
    if (v5 == null) {
      throw new NullPointerException("foobars: v5");
    }
    foobars.put(k5, v5);
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> putFoobar(FOO key, BAR value) {
    if (key == null) {
      throw new NullPointerException("foobar: key");
    }
    if (value == null) {
      throw new NullPointerException("foobar: value");
    }
    if (this.foobars == null) {
      this.foobars = new HashMap<FOO, BAR>();
    }
    foobars.put(key, value);
    return this;
  }

  public String name() {
    return name;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> name(String name) {
    if (name == null) {
      throw new NullPointerException("name");
    }
    this.name = name;
    return this;
  }

  public ComplexGenericFoobar<FOO, BAR, BAZ, QUUX> build() {
    List<BAR> _someBars = (someBars != null) ? Collections.unmodifiableList(new ArrayList<BAR>(someBars)) : Collections.<BAR>emptyList();
    Map<FOO, BAR> _foobars = (foobars != null) ? Collections.unmodifiableMap(new HashMap<FOO, BAR>(foobars)) : Collections.<FOO, BAR>emptyMap();
    return new Value<FOO, BAR, BAZ, QUUX>(foo, bar, baz, quux, maybeFoo, _someBars, _foobars, name);
  }

  public static <FOO, BAR extends Number, BAZ extends Collection<? extends BAR>, QUUX extends Iterable<? extends BAR> & Comparable<QUUX>> ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> from(ComplexGenericFoobar<? extends FOO, ? extends BAR, ? extends BAZ, ? extends QUUX> v) {
    return new ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX>(v);
  }

  public static <FOO, BAR extends Number, BAZ extends Collection<? extends BAR>, QUUX extends Iterable<? extends BAR> & Comparable<QUUX>> ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> from(ComplexGenericFoobarBuilder<? extends FOO, ? extends BAR, ? extends BAZ, ? extends QUUX> v) {
    return new ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX>(v);
  }

  private static final class Value<FOO, BAR extends Number, BAZ extends Collection<? extends BAR>, QUUX extends Iterable<? extends BAR> & Comparable<QUUX>> implements ComplexGenericFoobar<FOO, BAR, BAZ, QUUX> {
    private final FOO foo;

    private final BAR bar;

    private final BAZ baz;

    private final QUUX quux;

    private final Optional<FOO> maybeFoo;

    private final List<BAR> someBars;

    private final Map<FOO, BAR> foobars;

    private final String name;

    private Value(@AutoMatter.Field("foo") FOO foo, @AutoMatter.Field("bar") BAR bar, @AutoMatter.Field("baz") BAZ baz, @AutoMatter.Field("quux") QUUX quux, @AutoMatter.Field("maybeFoo") Optional<FOO> maybeFoo, @AutoMatter.Field("someBars") List<BAR> someBars, @AutoMatter.Field("foobars") Map<FOO, BAR> foobars, @AutoMatter.Field("name") String name) {
      if (foo == null) {
        throw new NullPointerException("foo");
      }
      if (bar == null) {
        throw new NullPointerException("bar");
      }
      if (baz == null) {
        throw new NullPointerException("baz");
      }
      if (quux == null) {
        throw new NullPointerException("quux");
      }
      if (maybeFoo == null) {
        throw new NullPointerException("maybeFoo");
      }
      if (name == null) {
        throw new NullPointerException("name");
      }
      this.foo = foo;
      this.bar = bar;
      this.baz = baz;
      this.quux = quux;
      this.maybeFoo = maybeFoo;
      this.someBars = (someBars != null) ? someBars : Collections.<BAR>emptyList();
      this.foobars = (foobars != null) ? foobars : Collections.<FOO, BAR>emptyMap();
      this.name = name;
    }

    @AutoMatter.Field
    @Override
    public FOO foo() {
      return foo;
    }

    @AutoMatter.Field
    @Override
    public BAR bar() {
      return bar;
    }

    @AutoMatter.Field
    @Override
    public BAZ baz() {
      return baz;
    }

    @AutoMatter.Field
    @Override
    public QUUX quux() {
      return quux;
    }

    @AutoMatter.Field
    @Override
    public Optional<FOO> maybeFoo() {
      return maybeFoo;
    }

    @AutoMatter.Field
    @Override
    public List<BAR> someBars() {
      return someBars;
    }

    @AutoMatter.Field
    @Override
    public Map<FOO, BAR> foobars() {
      return foobars;
    }

    @AutoMatter.Field
    @Override
    public String name() {
      return name;
    }

    public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> builder() {
      return new ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX>(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof ComplexGenericFoobar)) {
        return false;
      }
      final ComplexGenericFoobar<?, ?, ?, ?> that = (ComplexGenericFoobar<?, ?, ?, ?>) o;
      if (foo != null ? !foo.equals(that.foo()) : that.foo() != null) {
        return false;
      }
      if (bar != null ? !bar.equals(that.bar()) : that.bar() != null) {
        return false;
      }
      if (baz != null ? !baz.equals(that.baz()) : that.baz() != null) {
        return false;
      }
      if (quux != null ? !quux.equals(that.quux()) : that.quux() != null) {
        return false;
      }
      if (maybeFoo != null ? !maybeFoo.equals(that.maybeFoo()) : that.maybeFoo() != null) {
        return false;
      }
      if (someBars != null ? !someBars.equals(that.someBars()) : that.someBars() != null) {
        return false;
      }
      if (foobars != null ? !foobars.equals(that.foobars()) : that.foobars() != null) {
        return false;
      }
      if (name != null ? !name.equals(that.name()) : that.name() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (foo != null ? foo.hashCode() : 0);
      result = 31 * result + (bar != null ? bar.hashCode() : 0);
      result = 31 * result + (baz != null ? baz.hashCode() : 0);
      result = 31 * result + (quux != null ? quux.hashCode() : 0);
      result = 31 * result + (maybeFoo != null ? maybeFoo.hashCode() : 0);
      result = 31 * result + (someBars != null ? someBars.hashCode() : 0);
      result = 31 * result + (foobars != null ? foobars.hashCode() : 0);
      result = 31 * result + (name != null ? name.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "ComplexGenericFoobar{" +
      "foo=" + foo +
      ", bar=" + bar +
      ", baz=" + baz +
      ", quux=" + quux +
      ", maybeFoo=" + maybeFoo +
      ", someBars=" + someBars +
      ", foobars=" + foobars +
      ", name=" + name +
      '}';
    }
  }
}
