package io.norberg.automatter.example;

import com.google.common.base.Optional;
import io.norberg.automatter.AutoMatter;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
final class OptionalFoobarBuilder {
  private Optional<String> foo;

  private Optional<String> bar;

  public OptionalFoobarBuilder() {
    this.foo = Optional.absent();
    this.bar = Optional.absent();
  }

  private OptionalFoobarBuilder(OptionalExample.OptionalFoobar v) {
    this.foo = v.foo();
    this.bar = v.bar();
  }

  private OptionalFoobarBuilder(OptionalFoobarBuilder v) {
    this.foo = v.foo;
    this.bar = v.bar;
  }

  public Optional<String> foo() {
    return foo;
  }

  public OptionalFoobarBuilder foo(String foo) {
    return foo(Optional.fromNullable(foo));
  }

  public OptionalFoobarBuilder foo(Optional<? extends String> foo) {
    if (foo == null) {
      throw new NullPointerException("foo");
    }
    this.foo = (Optional<String>)foo;
    return this;
  }

  public Optional<String> bar() {
    return bar;
  }

  public OptionalFoobarBuilder bar(String bar) {
    return bar(Optional.fromNullable(bar));
  }

  public OptionalFoobarBuilder bar(Optional<? extends String> bar) {
    if (bar == null) {
      throw new NullPointerException("bar");
    }
    this.bar = (Optional<String>)bar;
    return this;
  }

  public OptionalExample.OptionalFoobar build() {
    return new Value(foo, bar);
  }

  public static OptionalFoobarBuilder from(OptionalExample.OptionalFoobar v) {
    return new OptionalFoobarBuilder(v);
  }

  public static OptionalFoobarBuilder from(OptionalFoobarBuilder v) {
    return new OptionalFoobarBuilder(v);
  }

  private static final class Value implements OptionalExample.OptionalFoobar {
    private final Optional<String> foo;

    private final Optional<String> bar;

    private Value(@AutoMatter.Field("foo") Optional<String> foo, @AutoMatter.Field("bar") Optional<String> bar) {
      if (foo == null) {
        throw new NullPointerException("foo");
      }
      if (bar == null) {
        throw new NullPointerException("bar");
      }
      this.foo = foo;
      this.bar = bar;
    }

    @AutoMatter.Field
    @Override
    public Optional<String> foo() {
      return foo;
    }

    @AutoMatter.Field
    @Override
    public Optional<String> bar() {
      return bar;
    }

    public OptionalFoobarBuilder builder() {
      return new OptionalFoobarBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof OptionalExample.OptionalFoobar)) {
        return false;
      }
      final OptionalExample.OptionalFoobar that = (OptionalExample.OptionalFoobar) o;
      if (foo != null ? !foo.equals(that.foo()) : that.foo() != null) {
        return false;
      }
      if (bar != null ? !bar.equals(that.bar()) : that.bar() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (foo != null ? foo.hashCode() : 0);
      result = 31 * result + (bar != null ? bar.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "OptionalExample.OptionalFoobar{" +
      "foo=" + foo +
      ", bar=" + bar +
      '}';
    }
  }
}
