package io.norberg.automatter.example;

import com.google.common.base.Optional;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
@AutoMatter.Generated
final class ComplexGenericFoobarBuilder<FOO, BAR extends Number, BAZ extends Collection<? extends BAR>, QUUX extends Iterable<? extends BAR> & Comparable<QUUX>> {
  private FOO foo;

  private BAR bar;

  private BAZ baz;

  private QUUX quux;

  private Optional<List<FOO>> maybeFoos;

  private List<BAR> someBars;

  private Map<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>> foobars;

  private String name;

  public ComplexGenericFoobarBuilder() {
    this.maybeFoos = Optional.absent();
  }

  private ComplexGenericFoobarBuilder(
      ComplexGenericFoobar<? extends FOO, ? extends BAR, ? extends BAZ, ? extends QUUX> v) {
    this.foo = v.foo();
    this.bar = v.bar();
    this.baz = v.baz();
    this.quux = v.quux();
    @SuppressWarnings("unchecked") Optional<List<FOO>> _maybeFoos = (Optional<List<FOO>>) (Optional<? extends List<? extends FOO>>) v.maybeFoos();
    this.maybeFoos = _maybeFoos;
    List<? extends BAR> _someBars = v.someBars();
    this.someBars = (_someBars == null) ? null : new ArrayList<BAR>(_someBars);
    @SuppressWarnings("unchecked") Map<? extends FOO, ? extends ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>> _foobars = (Map<? extends FOO, ? extends ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>>) (Map<? extends FOO, ? extends ComplexGenericFoobar.Fizz<? extends BAR, ? extends BAZ, ? extends FOO>>) v.foobars();
    this.foobars = (_foobars == null) ? null : new HashMap<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>>(_foobars);
    this.name = v.name();
  }

  private ComplexGenericFoobarBuilder(
      ComplexGenericFoobarBuilder<? extends FOO, ? extends BAR, ? extends BAZ, ? extends QUUX> v) {
    this.foo = v.foo();
    this.bar = v.bar();
    this.baz = v.baz();
    this.quux = v.quux();
    @SuppressWarnings("unchecked") Optional<List<FOO>> _maybeFoos = (Optional<List<FOO>>) (Optional<? extends List<? extends FOO>>) v.maybeFoos();
    this.maybeFoos = _maybeFoos;
    this.someBars = new ArrayList<BAR>(v.someBars());
    @SuppressWarnings("unchecked") Map<? extends FOO, ? extends ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>> _foobars = (Map<? extends FOO, ? extends ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>>) (Map<? extends FOO, ? extends ComplexGenericFoobar.Fizz<? extends BAR, ? extends BAZ, ? extends FOO>>) v.foobars();
    this.foobars = new HashMap<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>>(_foobars);
    this.name = v.name();
  }

  public FOO foo() {
    return foo;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> foo(FOO foo) {
    if (foo == null) {
      throw new NullPointerException("foo");
    }
    this.foo = foo;
    return this;
  }

  public BAR bar() {
    return bar;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> bar(BAR bar) {
    if (bar == null) {
      throw new NullPointerException("bar");
    }
    this.bar = bar;
    return this;
  }

  public BAZ baz() {
    return baz;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> baz(BAZ baz) {
    if (baz == null) {
      throw new NullPointerException("baz");
    }
    this.baz = baz;
    return this;
  }

  public QUUX quux() {
    return quux;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> quux(QUUX quux) {
    if (quux == null) {
      throw new NullPointerException("quux");
    }
    this.quux = quux;
    return this;
  }

  public Optional<List<FOO>> maybeFoos() {
    return maybeFoos;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> maybeFoos(List<FOO> maybeFoos) {
    return maybeFoos(Optional.fromNullable(maybeFoos));
  }

  @SuppressWarnings("unchecked")
  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> maybeFoos(
      Optional<? extends List<FOO>> maybeFoos) {
    if (maybeFoos == null) {
      throw new NullPointerException("maybeFoos");
    }
    this.maybeFoos = (Optional<List<FOO>>)maybeFoos;
    return this;
  }

  public List<BAR> someBars() {
    if (this.someBars == null) {
      this.someBars = new ArrayList<BAR>();
    }
    return someBars;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> someBars(List<? extends BAR> someBars) {
    return someBars((Collection<? extends BAR>) someBars);
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> someBars(
      Collection<? extends BAR> someBars) {
    if (someBars == null) {
      throw new NullPointerException("someBars");
    }
    for (BAR item : someBars) {
      if (item == null) {
        throw new NullPointerException("someBars: null item");
      }
    }
    this.someBars = new ArrayList<BAR>(someBars);
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> someBars(
      Iterable<? extends BAR> someBars) {
    if (someBars == null) {
      throw new NullPointerException("someBars");
    }
    if (someBars instanceof Collection) {
      return someBars((Collection<? extends BAR>) someBars);
    }
    return someBars(someBars.iterator());
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> someBars(
      Iterator<? extends BAR> someBars) {
    if (someBars == null) {
      throw new NullPointerException("someBars");
    }
    this.someBars = new ArrayList<BAR>();
    while (someBars.hasNext()) {
      BAR item = someBars.next();
      if (item == null) {
        throw new NullPointerException("someBars: null item");
      }
      this.someBars.add(item);
    }
    return this;
  }

  @SafeVarargs
  @SuppressWarnings("varargs")
  public final ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> someBars(BAR... someBars) {
    if (someBars == null) {
      throw new NullPointerException("someBars");
    }
    return someBars(Arrays.asList(someBars));
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> addSomeBar(BAR someBar) {
    if (someBar == null) {
      throw new NullPointerException("someBar");
    }
    if (this.someBars == null) {
      this.someBars = new ArrayList<BAR>();
    }
    someBars.add(someBar);
    return this;
  }

  public Map<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>> foobars() {
    if (this.foobars == null) {
      this.foobars = new HashMap<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>>();
    }
    return foobars;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> foobars(
      Map<? extends FOO, ? extends ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>> foobars) {
    if (foobars == null) {
      throw new NullPointerException("foobars");
    }
    for (Map.Entry<? extends FOO, ? extends ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>> entry : foobars.entrySet()) {
      if (entry.getKey() == null) {
        throw new NullPointerException("foobars: null key");
      }
      if (entry.getValue() == null) {
        throw new NullPointerException("foobars: null value");
      }
    }
    this.foobars = new HashMap<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>>(foobars);
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> foobars(FOO k1,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v1) {
    if (k1 == null) {
      throw new NullPointerException("foobars: k1");
    }
    if (v1 == null) {
      throw new NullPointerException("foobars: v1");
    }
    foobars = new HashMap<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>>();
    foobars.put(k1, v1);
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> foobars(FOO k1,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v1, FOO k2,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v2) {
    foobars(k1, v1);
    if (k2 == null) {
      throw new NullPointerException("foobars: k2");
    }
    if (v2 == null) {
      throw new NullPointerException("foobars: v2");
    }
    foobars.put(k2, v2);
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> foobars(FOO k1,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v1, FOO k2,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v2, FOO k3,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v3) {
    foobars(k1, v1, k2, v2);
    if (k3 == null) {
      throw new NullPointerException("foobars: k3");
    }
    if (v3 == null) {
      throw new NullPointerException("foobars: v3");
    }
    foobars.put(k3, v3);
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> foobars(FOO k1,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v1, FOO k2,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v2, FOO k3,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v3, FOO k4,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v4) {
    foobars(k1, v1, k2, v2, k3, v3);
    if (k4 == null) {
      throw new NullPointerException("foobars: k4");
    }
    if (v4 == null) {
      throw new NullPointerException("foobars: v4");
    }
    foobars.put(k4, v4);
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> foobars(FOO k1,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v1, FOO k2,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v2, FOO k3,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v3, FOO k4,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v4, FOO k5,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> v5) {
    foobars(k1, v1, k2, v2, k3, v3, k4, v4);
    if (k5 == null) {
      throw new NullPointerException("foobars: k5");
    }
    if (v5 == null) {
      throw new NullPointerException("foobars: v5");
    }
    foobars.put(k5, v5);
    return this;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> putFoobar(FOO key,
      ComplexGenericFoobar.Fizz<BAR, BAZ, FOO> value) {
    if (key == null) {
      throw new NullPointerException("foobar: key");
    }
    if (value == null) {
      throw new NullPointerException("foobar: value");
    }
    if (this.foobars == null) {
      this.foobars = new HashMap<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>>();
    }
    foobars.put(key, value);
    return this;
  }

  public String name() {
    return name;
  }

  public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> name(String name) {
    if (name == null) {
      throw new NullPointerException("name");
    }
    this.name = name;
    return this;
  }

  public ComplexGenericFoobar<FOO, BAR, BAZ, QUUX> build() {
    List<BAR> _someBars = (someBars != null) ? Collections.unmodifiableList(new ArrayList<BAR>(someBars)) : Collections.<BAR>emptyList();
    Map<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>> _foobars = (foobars != null) ? Collections.unmodifiableMap(new HashMap<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>>(foobars)) : Collections.<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>>emptyMap();
    return new Value<FOO, BAR, BAZ, QUUX>(foo, bar, baz, quux, maybeFoos, _someBars, _foobars, name);
  }

  public static <FOO, BAR extends Number, BAZ extends Collection<? extends BAR>, QUUX extends Iterable<? extends BAR> & Comparable<QUUX>> ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> from(
      ComplexGenericFoobar<? extends FOO, ? extends BAR, ? extends BAZ, ? extends QUUX> v) {
    return new ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX>(v);
  }

  public static <FOO, BAR extends Number, BAZ extends Collection<? extends BAR>, QUUX extends Iterable<? extends BAR> & Comparable<QUUX>> ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> from(
      ComplexGenericFoobarBuilder<? extends FOO, ? extends BAR, ? extends BAZ, ? extends QUUX> v) {
    return new ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX>(v);
  }

  @AutoMatter.Generated
  private static final class Value<FOO, BAR extends Number, BAZ extends Collection<? extends BAR>, QUUX extends Iterable<? extends BAR> & Comparable<QUUX>> implements ComplexGenericFoobar<FOO, BAR, BAZ, QUUX> {
    private final FOO foo;

    private final BAR bar;

    private final BAZ baz;

    private final QUUX quux;

    private final Optional<List<FOO>> maybeFoos;

    private final List<BAR> someBars;

    private final Map<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>> foobars;

    private final String name;

    private Value(@AutoMatter.Field("foo") FOO foo, @AutoMatter.Field("bar") BAR bar,
        @AutoMatter.Field("baz") BAZ baz, @AutoMatter.Field("quux") QUUX quux,
        @AutoMatter.Field("maybeFoos") Optional<List<FOO>> maybeFoos,
        @AutoMatter.Field("someBars") List<BAR> someBars,
        @AutoMatter.Field("foobars") Map<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>> foobars,
        @AutoMatter.Field("name") String name) {
      if (foo == null) {
        throw new NullPointerException("foo");
      }
      if (bar == null) {
        throw new NullPointerException("bar");
      }
      if (baz == null) {
        throw new NullPointerException("baz");
      }
      if (quux == null) {
        throw new NullPointerException("quux");
      }
      if (maybeFoos == null) {
        throw new NullPointerException("maybeFoos");
      }
      if (name == null) {
        throw new NullPointerException("name");
      }
      this.foo = foo;
      this.bar = bar;
      this.baz = baz;
      this.quux = quux;
      this.maybeFoos = maybeFoos;
      this.someBars = (someBars != null) ? someBars : Collections.<BAR>emptyList();
      this.foobars = (foobars != null) ? foobars : Collections.<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>>emptyMap();
      this.name = name;
    }

    @AutoMatter.Field
    @Override
    public FOO foo() {
      return foo;
    }

    @AutoMatter.Field
    @Override
    public BAR bar() {
      return bar;
    }

    @AutoMatter.Field
    @Override
    public BAZ baz() {
      return baz;
    }

    @AutoMatter.Field
    @Override
    public QUUX quux() {
      return quux;
    }

    @AutoMatter.Field
    @Override
    public Optional<List<FOO>> maybeFoos() {
      return maybeFoos;
    }

    @AutoMatter.Field
    @Override
    public List<BAR> someBars() {
      return someBars;
    }

    @AutoMatter.Field
    @Override
    public Map<FOO, ComplexGenericFoobar.Fizz<BAR, BAZ, FOO>> foobars() {
      return foobars;
    }

    @AutoMatter.Field
    @Override
    public String name() {
      return name;
    }

    public ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX> builder() {
      return new ComplexGenericFoobarBuilder<FOO, BAR, BAZ, QUUX>(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof ComplexGenericFoobar)) {
        return false;
      }
      final ComplexGenericFoobar<?, ?, ?, ?> that = (ComplexGenericFoobar<?, ?, ?, ?>) o;
      if (foo != null ? !foo.equals(that.foo()) : that.foo() != null) {
        return false;
      }
      if (bar != null ? !bar.equals(that.bar()) : that.bar() != null) {
        return false;
      }
      if (baz != null ? !baz.equals(that.baz()) : that.baz() != null) {
        return false;
      }
      if (quux != null ? !quux.equals(that.quux()) : that.quux() != null) {
        return false;
      }
      if (maybeFoos != null ? !maybeFoos.equals(that.maybeFoos()) : that.maybeFoos() != null) {
        return false;
      }
      if (someBars != null ? !someBars.equals(that.someBars()) : that.someBars() != null) {
        return false;
      }
      if (foobars != null ? !foobars.equals(that.foobars()) : that.foobars() != null) {
        return false;
      }
      if (name != null ? !name.equals(that.name()) : that.name() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (this.foo != null ? this.foo.hashCode() : 0);
      result = 31 * result + (this.bar != null ? this.bar.hashCode() : 0);
      result = 31 * result + (this.baz != null ? this.baz.hashCode() : 0);
      result = 31 * result + (this.quux != null ? this.quux.hashCode() : 0);
      result = 31 * result + (this.maybeFoos != null ? this.maybeFoos.hashCode() : 0);
      result = 31 * result + (this.someBars != null ? this.someBars.hashCode() : 0);
      result = 31 * result + (this.foobars != null ? this.foobars.hashCode() : 0);
      result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "ComplexGenericFoobar{" +
      "foo=" + foo +
      ", bar=" + bar +
      ", baz=" + baz +
      ", quux=" + quux +
      ", maybeFoos=" + maybeFoos +
      ", someBars=" + someBars +
      ", foobars=" + foobars +
      ", name=" + name +
      '}';
    }
  }
}
