package io.norberg.automatter.example;

import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
@AutoMatter.Generated
final class GenericFoobarBuilder<T> {
  private T foo;

  private List<T> bar;

  private Map<String, T> bazs;

  public GenericFoobarBuilder() {
  }

  private GenericFoobarBuilder(GenericFoobar<? extends T> v) {
    this.foo = v.foo();
    List<? extends T> _bar = v.bar();
    this.bar = (_bar == null) ? null : new ArrayList<T>(_bar);
    Map<? extends String, ? extends T> _bazs = v.bazs();
    this.bazs = (_bazs == null) ? null : new HashMap<String, T>(_bazs);
  }

  private GenericFoobarBuilder(GenericFoobarBuilder<? extends T> v) {
    this.foo = v.foo();
    this.bar = new ArrayList<T>(v.bar());
    this.bazs = new HashMap<String, T>(v.bazs());
  }

  public T foo() {
    return foo;
  }

  public GenericFoobarBuilder<T> foo(T foo) {
    if (foo == null) {
      throw new NullPointerException("foo");
    }
    this.foo = foo;
    return this;
  }

  public List<T> bar() {
    if (this.bar == null) {
      this.bar = new ArrayList<T>();
    }
    return bar;
  }

  public GenericFoobarBuilder<T> bar(List<? extends T> bar) {
    return bar((Collection<? extends T>) bar);
  }

  public GenericFoobarBuilder<T> bar(Collection<? extends T> bar) {
    if (bar == null) {
      throw new NullPointerException("bar");
    }
    for (T item : bar) {
      if (item == null) {
        throw new NullPointerException("bar: null item");
      }
    }
    this.bar = new ArrayList<T>(bar);
    return this;
  }

  public GenericFoobarBuilder<T> bar(Iterable<? extends T> bar) {
    if (bar == null) {
      throw new NullPointerException("bar");
    }
    if (bar instanceof Collection) {
      return bar((Collection<? extends T>) bar);
    }
    return bar(bar.iterator());
  }

  public GenericFoobarBuilder<T> bar(Iterator<? extends T> bar) {
    if (bar == null) {
      throw new NullPointerException("bar");
    }
    this.bar = new ArrayList<T>();
    while (bar.hasNext()) {
      T item = bar.next();
      if (item == null) {
        throw new NullPointerException("bar: null item");
      }
      this.bar.add(item);
    }
    return this;
  }

  @SafeVarargs
  @SuppressWarnings("varargs")
  public final GenericFoobarBuilder<T> bar(T... bar) {
    if (bar == null) {
      throw new NullPointerException("bar");
    }
    return bar(Arrays.asList(bar));
  }

  public Map<String, T> bazs() {
    if (this.bazs == null) {
      this.bazs = new HashMap<String, T>();
    }
    return bazs;
  }

  public GenericFoobarBuilder<T> bazs(Map<? extends String, ? extends T> bazs) {
    if (bazs == null) {
      throw new NullPointerException("bazs");
    }
    for (Map.Entry<? extends String, ? extends T> entry : bazs.entrySet()) {
      if (entry.getKey() == null) {
        throw new NullPointerException("bazs: null key");
      }
      if (entry.getValue() == null) {
        throw new NullPointerException("bazs: null value");
      }
    }
    this.bazs = new HashMap<String, T>(bazs);
    return this;
  }

  public GenericFoobarBuilder<T> bazs(String k1, T v1) {
    if (k1 == null) {
      throw new NullPointerException("bazs: k1");
    }
    if (v1 == null) {
      throw new NullPointerException("bazs: v1");
    }
    bazs = new HashMap<String, T>();
    bazs.put(k1, v1);
    return this;
  }

  public GenericFoobarBuilder<T> bazs(String k1, T v1, String k2, T v2) {
    bazs(k1, v1);
    if (k2 == null) {
      throw new NullPointerException("bazs: k2");
    }
    if (v2 == null) {
      throw new NullPointerException("bazs: v2");
    }
    bazs.put(k2, v2);
    return this;
  }

  public GenericFoobarBuilder<T> bazs(String k1, T v1, String k2, T v2, String k3, T v3) {
    bazs(k1, v1, k2, v2);
    if (k3 == null) {
      throw new NullPointerException("bazs: k3");
    }
    if (v3 == null) {
      throw new NullPointerException("bazs: v3");
    }
    bazs.put(k3, v3);
    return this;
  }

  public GenericFoobarBuilder<T> bazs(String k1, T v1, String k2, T v2, String k3, T v3, String k4,
      T v4) {
    bazs(k1, v1, k2, v2, k3, v3);
    if (k4 == null) {
      throw new NullPointerException("bazs: k4");
    }
    if (v4 == null) {
      throw new NullPointerException("bazs: v4");
    }
    bazs.put(k4, v4);
    return this;
  }

  public GenericFoobarBuilder<T> bazs(String k1, T v1, String k2, T v2, String k3, T v3, String k4,
      T v4, String k5, T v5) {
    bazs(k1, v1, k2, v2, k3, v3, k4, v4);
    if (k5 == null) {
      throw new NullPointerException("bazs: k5");
    }
    if (v5 == null) {
      throw new NullPointerException("bazs: v5");
    }
    bazs.put(k5, v5);
    return this;
  }

  public GenericFoobarBuilder<T> putBaz(String key, T value) {
    if (key == null) {
      throw new NullPointerException("baz: key");
    }
    if (value == null) {
      throw new NullPointerException("baz: value");
    }
    if (this.bazs == null) {
      this.bazs = new HashMap<String, T>();
    }
    bazs.put(key, value);
    return this;
  }

  public GenericFoobar<T> build() {
    List<T> _bar = (bar != null) ? Collections.unmodifiableList(new ArrayList<T>(bar)) : Collections.<T>emptyList();
    Map<String, T> _bazs = (bazs != null) ? Collections.unmodifiableMap(new HashMap<String, T>(bazs)) : Collections.<String, T>emptyMap();
    return new Value<T>(foo, _bar, _bazs);
  }

  public static <T> GenericFoobarBuilder<T> from(GenericFoobar<? extends T> v) {
    return new GenericFoobarBuilder<T>(v);
  }

  public static <T> GenericFoobarBuilder<T> from(GenericFoobarBuilder<? extends T> v) {
    return new GenericFoobarBuilder<T>(v);
  }

  @AutoMatter.Generated
  private static final class Value<T> implements GenericFoobar<T> {
    private final T foo;

    private final List<T> bar;

    private final Map<String, T> bazs;

    private Value(@AutoMatter.Field("foo") T foo, @AutoMatter.Field("bar") List<T> bar,
        @AutoMatter.Field("bazs") Map<String, T> bazs) {
      if (foo == null) {
        throw new NullPointerException("foo");
      }
      this.foo = foo;
      this.bar = (bar != null) ? bar : Collections.<T>emptyList();
      this.bazs = (bazs != null) ? bazs : Collections.<String, T>emptyMap();
    }

    @AutoMatter.Field
    @Override
    public T foo() {
      return foo;
    }

    @AutoMatter.Field
    @Override
    public List<T> bar() {
      return bar;
    }

    @AutoMatter.Field
    @Override
    public Map<String, T> bazs() {
      return bazs;
    }

    public GenericFoobarBuilder<T> builder() {
      return new GenericFoobarBuilder<T>(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof GenericFoobar)) {
        return false;
      }
      final GenericFoobar<?> that = (GenericFoobar<?>) o;
      if (foo != null ? !foo.equals(that.foo()) : that.foo() != null) {
        return false;
      }
      if (bar != null ? !bar.equals(that.bar()) : that.bar() != null) {
        return false;
      }
      if (bazs != null ? !bazs.equals(that.bazs()) : that.bazs() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (this.foo != null ? this.foo.hashCode() : 0);
      result = 31 * result + (this.bar != null ? this.bar.hashCode() : 0);
      result = 31 * result + (this.bazs != null ? this.bazs.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "GenericFoobar{" +
      "foo=" + foo +
      ", bar=" + bar +
      ", bazs=" + bazs +
      '}';
    }
  }
}
