/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cqlverify;

import io.nosqlbench.activitytype.cql.api.ResultSetCycleOperator;
import io.nosqlbench.activitytype.cql.core.CqlActivity;
import io.nosqlbench.activitytype.cql.statements.rsoperators.AssertSingleRowResultSet;
import io.nosqlbench.activitytype.cqlverify.DiffType;
import io.nosqlbench.activitytype.cqlverify.RowDifferencer;
import io.nosqlbench.activitytype.cqlverify.VerificationMetrics;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtDef;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.virtdata.api.Bindings;
import io.nosqlbench.virtdata.api.BindingsTemplate;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlVerifyActivity
extends CqlActivity {
    private static final Logger logger = LoggerFactory.getLogger(CqlVerifyActivity.class);
    private BindingsTemplate expectedValuesTemplate;
    private VerificationMetrics verificationMetrics;

    public CqlVerifyActivity(ActivityDef activityDef) {
        super(activityDef);
    }

    public synchronized void initActivity() {
        this.verificationMetrics = new VerificationMetrics(this.getActivityDef());
        super.initActivity();
        if (this.stmts.size() > 1) {
            throw new RuntimeException("More than one statement was configured as active. " + this.getActivityDef().getActivityType() + " requires exactly one.");
        }
        Optional<String> randomMapper = this.stmts.stream().flatMap(s -> s.getBindings().values().stream()).filter(t -> t.matches(".*Random.*") || t.matches(".*random.*")).findAny();
        if (randomMapper.isPresent()) {
            throw new RuntimeException("You should not try to verify data generated with random mapping functions, like " + randomMapper.get() + " as it does not produce stable results in different invocation order.");
        }
    }

    public synchronized BindingsTemplate getExpectedValuesTemplate() {
        if (this.expectedValuesTemplate == null) {
            this.expectedValuesTemplate = new BindingsTemplate();
            Map bindings = ((StmtDef)this.stmts.get(0)).getBindings();
            if (((StmtDef)this.stmts.get(0)).getParams().containsKey("verify-fields")) {
                ArrayList<String> fields = new ArrayList<String>();
                String fieldsSpec = (String)((StmtDef)this.stmts.get(0)).getParams().get("verify-fields");
                String[] vfields = fieldsSpec.split("\\s*,\\s*");
                for (String vfield : vfields) {
                    if (vfield.equals("*")) {
                        bindings.forEach((k, v) -> fields.add((String)k));
                        continue;
                    }
                    if (vfield.startsWith("+")) {
                        fields.add(vfield.substring(1));
                        continue;
                    }
                    if (vfield.startsWith("-")) {
                        fields.remove(vfield.substring(1));
                        continue;
                    }
                    if (vfield.matches("\\w+(\\w+->[\\w-]+)?")) {
                        fields.add(vfield);
                        continue;
                    }
                    throw new RuntimeException("unknown verify-fields format: '" + vfield + "'");
                }
                for (String vfield : fields) {
                    String bindingName;
                    String[] fieldNameAndBindingName = vfield.split("\\s*->\\s*", 2);
                    String fieldName = fieldNameAndBindingName[0];
                    String string = bindingName = fieldNameAndBindingName.length == 1 ? fieldName : fieldNameAndBindingName[1];
                    if (!bindings.containsKey(bindingName)) {
                        throw new RuntimeException("binding name '" + bindingName + "' referenced in verify-fields, but it is not present in available bindings.");
                    }
                    this.expectedValuesTemplate.addFieldBinding(fieldName, (String)bindings.get(bindingName));
                }
            } else {
                bindings.forEach((k, v) -> this.expectedValuesTemplate.addFieldBinding(k, v));
            }
        }
        return this.expectedValuesTemplate;
    }

    public synchronized VerificationMetrics getVerificationMetrics() {
        return this.verificationMetrics;
    }

    public void shutdownActivity() {
        super.shutdownActivity();
        VerificationMetrics metrics = this.getVerificationMetrics();
        long unverifiedValues = metrics.unverifiedValuesCounter.getCount();
        long unverifiedRows = metrics.unverifiedRowsCounter.getCount();
        if (unverifiedRows > 0L || unverifiedValues > 0L) {
            throw new RuntimeException("There were " + unverifiedValues + " unverified values across " + unverifiedRows + " unverified rows.");
        }
        logger.info("verified " + metrics.verifiedValuesCounter.getCount() + " values across " + metrics.verifiedRowsCounter.getCount() + " verified rows");
    }

    public void onActivityDefUpdate(ActivityDef activityDef) {
        super.onActivityDefUpdate(activityDef);
        this.addResultSetCycleOperator((ResultSetCycleOperator)new AssertSingleRowResultSet());
        String verify = activityDef.getParams().getOptionalString(new String[]{"compare"}).orElse("all");
        DiffType diffType = DiffType.valueOf(verify);
        Bindings verifyBindings = this.getExpectedValuesTemplate().resolveBindings();
        RowDifferencer.ThreadLocalWrapper differ = new RowDifferencer.ThreadLocalWrapper(this.getVerificationMetrics(), verifyBindings, diffType);
        this.addRowCycleOperator(differ);
    }
}

