/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cqlverify;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import io.nosqlbench.activitytype.cql.api.RowCycleOperator;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.RowVerificationException;
import io.nosqlbench.activitytype.cqlverify.DiffType;
import io.nosqlbench.activitytype.cqlverify.VerificationMetrics;
import io.nosqlbench.virtdata.api.Bindings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class RowDifferencer
implements RowCycleOperator {
    private final StringBuilder logbuffer = new StringBuilder();
    private final Map<String, Object> refMap = new HashMap<String, Object>();
    private final DiffType difftype;
    private final Bindings bindings;
    private final VerificationMetrics metrics;

    private RowDifferencer(VerificationMetrics metrics, Bindings bindings, DiffType diffType) {
        this.metrics = metrics;
        this.bindings = bindings;
        this.difftype = diffType;
    }

    private static boolean isEqual(DataType.Name typeName, Row row, String fieldName, Object genValue) {
        switch (typeName) {
            case ASCII: 
            case VARCHAR: 
            case TEXT: {
                String textValue = row.getString(fieldName);
                return textValue.equals(genValue);
            }
            case BIGINT: 
            case COUNTER: {
                long longValue = row.getLong(fieldName);
                return longValue == (Long)genValue;
            }
            case BLOB: 
            case CUSTOM: {
                ByteBuffer blobValue = row.getBytes(fieldName);
                return blobValue.equals(genValue);
            }
            case BOOLEAN: {
                boolean boolValue = row.getBool(fieldName);
                return boolValue == (Boolean)genValue;
            }
            case DECIMAL: {
                BigDecimal bigDecimalValue = row.getDecimal(fieldName);
                return bigDecimalValue.equals(genValue);
            }
            case DOUBLE: {
                double doubleValue = row.getDouble(fieldName);
                return doubleValue == (Double)genValue;
            }
            case FLOAT: {
                float floatValue = row.getFloat(fieldName);
                return floatValue == ((Float)genValue).floatValue();
            }
            case INET: {
                InetAddress inetAddressValue = row.getInet(fieldName);
                return inetAddressValue.equals(genValue);
            }
            case INT: {
                int intValue = row.getInt(fieldName);
                return intValue == (Integer)genValue;
            }
            case TIMESTAMP: {
                Date timestamp = row.getTimestamp(fieldName);
                return timestamp.equals(genValue);
            }
            case UUID: 
            case TIMEUUID: {
                UUID uuidValue = row.getUUID(fieldName);
                return uuidValue.equals(genValue);
            }
            case VARINT: {
                BigInteger bigIntValue = row.getVarint(fieldName);
                return bigIntValue.equals(genValue);
            }
            case LIST: {
                List list = row.getList(fieldName, String.class);
                return list.equals(genValue);
            }
            case SET: {
                Set set = row.getSet(fieldName, String.class);
                return set.equals(genValue);
            }
            case MAP: {
                Map map = row.getMap(fieldName, String.class, String.class);
                return map.equals(genValue);
            }
            case UDT: {
                UDTValue udtValue = row.getUDTValue(fieldName);
                return udtValue.equals(genValue);
            }
            case TUPLE: {
                TupleValue tupleValue = row.getTupleValue(fieldName);
                return tupleValue.equals(genValue);
            }
            case SMALLINT: {
                short shortVal = row.getShort(fieldName);
                return shortVal == (Short)genValue;
            }
            case TINYINT: {
                byte byteValue = row.getByte(fieldName);
                return byteValue == (Byte)genValue;
            }
            case DATE: {
                LocalDate dateValue = row.getDate(fieldName);
                return dateValue.equals(genValue);
            }
            case TIME: {
                long timeValue = row.getTime(fieldName);
                return timeValue == (Long)genValue;
            }
        }
        throw new RuntimeException("Unrecognized type:" + typeName);
    }

    private static String prettyPrint(DataType.Name typeName, Row row, String fieldName) {
        switch (typeName) {
            case ASCII: 
            case VARCHAR: 
            case TEXT: {
                return row.getString(fieldName);
            }
            case BIGINT: 
            case COUNTER: {
                long counterValue = row.getLong(fieldName);
                return String.valueOf(counterValue);
            }
            case BLOB: 
            case CUSTOM: {
                ByteBuffer blobValue = row.getBytes(fieldName);
                return String.valueOf(blobValue);
            }
            case BOOLEAN: {
                boolean boolValue = row.getBool(fieldName);
                return String.valueOf(boolValue);
            }
            case DECIMAL: {
                BigDecimal bigDecimalValue = row.getDecimal(fieldName);
                return String.valueOf(bigDecimalValue);
            }
            case DOUBLE: {
                double doubleValue = row.getDouble(fieldName);
                return String.valueOf(doubleValue);
            }
            case FLOAT: {
                float floatValue = row.getFloat(fieldName);
                return String.valueOf(floatValue);
            }
            case INET: {
                InetAddress inetAddressValue = row.getInet(fieldName);
                return String.valueOf(inetAddressValue);
            }
            case INT: {
                int intValue = row.getInt(fieldName);
                return String.valueOf(intValue);
            }
            case TIMESTAMP: {
                Date timestamp = row.getTimestamp(fieldName);
                return String.valueOf(timestamp);
            }
            case UUID: 
            case TIMEUUID: {
                UUID uuidValue = row.getUUID(fieldName);
                return String.valueOf(uuidValue);
            }
            case VARINT: {
                BigInteger bigIntValue = row.getVarint(fieldName);
                return String.valueOf(bigIntValue);
            }
            case LIST: {
                List list = row.getList(fieldName, String.class);
                return String.valueOf(list);
            }
            case SET: {
                Set set = row.getSet(fieldName, String.class);
                return String.valueOf(set);
            }
            case MAP: {
                Map map = row.getMap(fieldName, String.class, String.class);
                return String.valueOf(map);
            }
            case UDT: {
                UDTValue udtValue = row.getUDTValue(fieldName);
                return String.valueOf(udtValue);
            }
            case TUPLE: {
                TupleValue tupleValue = row.getTupleValue(fieldName);
                return String.valueOf(tupleValue);
            }
            case SMALLINT: {
                short val = row.getShort(fieldName);
                return String.valueOf(val);
            }
            case TINYINT: {
                byte byteValue = row.getByte(fieldName);
                return String.valueOf(byteValue);
            }
            case DATE: {
                LocalDate dateValue = row.getDate(fieldName);
                return String.valueOf(dateValue);
            }
            case TIME: {
                long timeValue = row.getTime(fieldName);
                return String.valueOf(timeValue);
            }
        }
        throw new RuntimeException("Type not recognized:" + typeName);
    }

    private int compare(Row row, Map<String, Object> referenceMap) {
        List missingRefFields;
        List missingRowFields;
        int diff = 0;
        ColumnDefinitions cdefs = row.getColumnDefinitions();
        this.logbuffer.setLength(0);
        if (this.difftype.is(DiffType.reffields) && (missingRowFields = referenceMap.keySet().stream().filter(gk -> !cdefs.contains(gk)).collect(Collectors.toList())).size() > 0) {
            diff += missingRowFields.size();
            this.logbuffer.append("\nexpected fields '");
            this.logbuffer.append(String.join((CharSequence)"','", missingRowFields));
            this.logbuffer.append("' not in row.");
        }
        if (this.difftype.is(DiffType.rowfields) && (missingRefFields = cdefs.asList().stream().map(ColumnDefinitions.Definition::getName).filter(k -> !referenceMap.containsKey(k)).collect(Collectors.toList())).size() > 0) {
            diff += missingRefFields.size();
            this.logbuffer.append("\nexpected fields '");
            this.logbuffer.append(String.join((CharSequence)"','", missingRefFields));
            this.logbuffer.append("' not in reference data: " + referenceMap);
        }
        if (this.difftype.is(DiffType.values)) {
            for (ColumnDefinitions.Definition definition : row.getColumnDefinitions()) {
                String name = definition.getName();
                if (!referenceMap.containsKey(name)) continue;
                DataType type = definition.getType();
                if (!RowDifferencer.isEqual(type.getName(), row, name, referenceMap.get(name))) {
                    this.logbuffer.append("\nvalue differs for '").append(name).append("' ");
                    this.logbuffer.append("expected:'").append(referenceMap.get(name).toString()).append("'");
                    this.logbuffer.append(" actual:'").append(RowDifferencer.prettyPrint(type.getName(), row, name)).append("'");
                    ++diff;
                    this.metrics.unverifiedValuesCounter.inc();
                    continue;
                }
                this.metrics.verifiedValuesCounter.inc();
            }
        }
        if (diff == 0) {
            this.metrics.verifiedRowsCounter.inc();
        } else {
            this.metrics.unverifiedRowsCounter.inc();
        }
        return diff;
    }

    public String getDetail() {
        return this.logbuffer.toString();
    }

    public int apply(Row row, long cycle) {
        this.refMap.clear();
        this.bindings.setMap(this.refMap, cycle);
        int diffs = this.compare(row, this.refMap);
        if (diffs > 0) {
            HashMap<String, Object> mapcopy = new HashMap<String, Object>();
            mapcopy.putAll(this.refMap);
            throw new RowVerificationException(cycle, row, mapcopy, this.getDetail());
        }
        return 0;
    }

    public static class ThreadLocalWrapper
    implements RowCycleOperator {
        private final VerificationMetrics metrics;
        private final Bindings bindings;
        private final DiffType diffType;
        private ThreadLocal<RowDifferencer> tl;

        public ThreadLocalWrapper(VerificationMetrics metrics, Bindings bindings, DiffType diffType) {
            this.metrics = metrics;
            this.bindings = bindings;
            this.diffType = diffType;
            this.tl = ThreadLocal.withInitial(() -> new RowDifferencer(metrics, bindings, diffType));
        }

        public int apply(Row row, long cycle) {
            return this.tl.get().apply(row, cycle);
        }
    }
}

